
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Magnus Danielson    cfmd@swipnet.se

//---------------------------------------------------------------------------
#include "IIR_PhysicalSubtypeDefinition.hh"
#include "IIR_PhysicalUnit.hh"
#include "IIR_PhysicalLiteral.hh"
#include "IIR_FunctionDeclaration.hh"

IIRScram_PhysicalSubtypeDefinition::~IIRScram_PhysicalSubtypeDefinition(){}

void 
IIRScram_PhysicalSubtypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out){
  // We have to do this because IIR_PhysicalTypeDefinition (our parent)
  // has overloaded this method, but we want one lower than that.
  IIR_ScalarTypeDefinition::_publish_vhdl_decl( _vhdl_out );
}

IIR_Boolean
IIRScram_PhysicalSubtypeDefinition::_is_subtype(){
  return TRUE;
}


void 
IIRScram_PhysicalSubtypeDefinition::_publish_cc_type_info( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_PhysicalSubtypeDefinition::_publish_cc_type_info" );
  IIR_PhysicalTypeDefinition::_publish_cc_type_info( _cc_out );
}

void 
IIRScram_PhysicalSubtypeDefinition::_publish_cc_extern_type_info( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_PhysicalSubtypeDefinition::_publish_cc_extern_type_info" );
  IIR_PhysicalTypeDefinition::_publish_cc_extern_type_info( _cc_out );
}

void 
IIRScram_PhysicalSubtypeDefinition::_type_check(){
  if( get_resolution_function() != NULL ){
    get_resolution_function()->_type_check_resolution_function( this );
  }
  IIR_PhysicalTypeDefinition::_type_check();
}

IIR *
IIRScram_PhysicalSubtypeDefinition::_clone(){
  IIR_PhysicalSubtypeDefinition *retval = new IIR_PhysicalSubtypeDefinition();
  _clone( retval );
  return retval;
}

void 
IIRScram_PhysicalSubtypeDefinition::_clone( IIR *copy_into ){
  ASSERT( copy_into->_is_iir_physical_subtype_definition() == TRUE );
  IIR_PhysicalSubtypeDefinition *as_physical_subtype = 
    (IIR_PhysicalSubtypeDefinition *)copy_into;
  
  as_physical_subtype->set_resolution_function( get_resolution_function() );

  IIRScram_PhysicalTypeDefinition::_clone( copy_into );
}



visitor_return_type *
IIRScram_PhysicalSubtypeDefinition::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_PhysicalSubtypeDefinition(this, arg);
};
