
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRScram_TerminalInterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Identifier.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "error_func.hh"

IIRScram_TerminalInterfaceDeclaration::~IIRScram_TerminalInterfaceDeclaration(){}

void
IIRScram_TerminalInterfaceDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << " terminal ";
  _publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);
}

IIRScram_Declaration::declaration_type
IIRScram_TerminalInterfaceDeclaration::_get_type(){
   return INTERFACE_TERMINAL;
}

void
IIRScram_TerminalInterfaceDeclaration::_type_check(  IIRScram_InterfaceDeclaration::_InterfaceListType ){

 IIR_InterfaceDeclaration::_type_check();
}

void
IIRScram_TerminalInterfaceDeclaration::_publish_cc_lvalue(published_file &_cc_out){
  ASSERT( get_declarator()->get_kind() == IIR_IDENTIFIER );
  _get_declarator()->_publish_cc_lvalue(_cc_out);
}

void
IIRScram_TerminalInterfaceDeclaration::_publish_cc_elaborate(published_file &_cc_out) {
 SCRAM_CC_REF( _cc_out, "IIRScram_TerminalInterfaceDeclaration::_publish_cc_elaborate" ); 
 _get_declarator()->_publish_cc_elaborate(_cc_out);
}

