/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <Python.h>
#include "sg_formula_dialog.h"
#include "sg.h"
#include "sg_dialogs.h"
#include "python/python_main.h"

static GtkWidget *name_entry;
static GtkWidget *from_spin;
static GtkWidget *to_spin;
static gint the_column;
static GtkSheet *the_sheet;

static gboolean
mw_destroy(GtkWidget *widget)
{
  sg_dialog_kill(widget);

  return FALSE;
}


static void
update_worksheet(GtkWidget *widget,gpointer data)
{
  gchar *text;
  gint from, to, i;
  text = gtk_entry_get_text(GTK_ENTRY(name_entry));
  from = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(from_spin));
  to = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(to_spin));
  sg_worksheet_update_column_exp(active_worksheet,text,the_column,from,to);
  sg_worksheet_column_set_exp(active_worksheet, the_column, text);
  gtk_widget_destroy(widget);
}


void
sg_formula_dialog (SGworksheet *worksheet, gint col)
{
  GtkWidget *window = NULL;
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *ok_button, *cancel_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkWidget *label;
  GtkSheetColumn *column;
  GtkAdjustment *adj;
  gchar text[100];

  the_column = col;
  the_sheet = GTK_SHEET(worksheet->sheet);
  column = &(GTK_SHEET(worksheet->sheet)->column[col]);

  window=gtk_window_new (GTK_WINDOW_DIALOG);
  sg_dialog_new(window);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window),"Column values");

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (main_box), frame, FALSE, FALSE, 0);

  table = gtk_table_new(2, 4, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  label = gtk_label_new("From Row"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 0, 1);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., the_sheet->maxrow, 1., 1., 0.);
  from_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(from_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(from_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), from_spin, 1, 2, 0, 1);

  label = gtk_label_new("To Row"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 0, 1);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., the_sheet->maxrow, 1., 1., 0.);
  to_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(to_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(to_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), to_spin, 3, 4, 0, 1);

  if(column->name)
    sprintf(text,"col(\"%s\")=",column->name);
  else
    sprintf(text,"col(%d)=",col);

  name_entry = gtk_entry_new();   

  label = gtk_label_new(text),
  gtk_misc_set_alignment(GTK_MISC(label), 0., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), name_entry, 1, 4, 1, 2);

  /* Action Area */
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = sg_stock_button ("Button_Ok");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  cancel_button = sg_stock_button ("Button_Cancel");
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (window));

  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (update_worksheet),
                             GTK_OBJECT (window));
  gtk_signal_connect_object (GTK_OBJECT (name_entry), "activate",
                             GTK_SIGNAL_FUNC (update_worksheet),
                             GTK_OBJECT (window));

  gtk_signal_connect_object (GTK_OBJECT (name_entry), "destroy",
                             GTK_SIGNAL_FUNC (mw_destroy),
                             GTK_OBJECT (window));


  /* Show widgets */

  if(worksheet->column[col].exp)
    sprintf(text,"%s",worksheet->column[col].exp);
  else
    sprintf(text,"%s", "");

  gtk_entry_set_text(GTK_ENTRY(name_entry), text);
  gtk_editable_select_region(GTK_EDITABLE(name_entry),0,-1);
  gtk_editable_set_position(GTK_EDITABLE(name_entry),-1);



  gtk_spin_button_set_value(GTK_SPIN_BUTTON(from_spin), 0);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(to_spin), the_sheet->maxrow);
  
  gtk_widget_grab_focus(name_entry);
  gtk_widget_show_all (window);

  return;
}
