#include <cstring>
#include <cctype>

#include "lib_utils.h"

gint stardict_strcmp(const gchar *s1, const gchar *s2)
{
  gint a = g_ascii_strcasecmp(s1, s2);
  if(0==a)
    return strcmp(s1, s2);
  else
    return a;
}

bool bIsPureEnglish(const gchar *str) // i think this should work even when it is UTF8 string :).
{
  for(gint i=0; str[i]!=0; i++)
    if(!isascii(str[i]))
      return false;
        
  return true;
}

gchar* GetHeadWord(gchar *str)
{
  while(g_ascii_isspace(*str))
    str++;
  glong len = g_utf8_strlen(str, -1);
  if(len){
    gchar *last_str = g_utf8_offset_to_pointer(str, len-1);
    gunichar last = g_utf8_get_char(last_str);
    while((g_unichar_isspace(last) || g_unichar_ispunct(last)) ||
	  g_unichar_isdigit(last)){
      *last_str = '\0';
      last_str = g_utf8_find_prev_char(str, last_str);
      if(!last_str)
	break;
      last = g_utf8_get_char(last_str);
    }
  }
  return str;
}

bool bContainRule(const gchar* sWord)
{  
  for(gint i=0; sWord[i]!=0; i++)
    if(sWord[i]=='*' || sWord[i]=='?')
      return true;
    
  return false;
}
