/*
 * Smart Gnome Control - main file
 * Copyright (C) 2004 by Mark J. Fine <fineware@users.sourceforge.net>
 *
 * This program provides a graphical user interface to multiple
 * communications receivers using the Hamlib library.
 *
 * $Id: main.c,v 1.29 2004/12/31 06:55:34 fineware Exp $
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 *      Free Software Foundation, Inc.
 *      59 Temple Place - Suite 330
 *      Boston, MA  02111-1307
 *      USA
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <libgnomeui/gnome-window-icon.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "extra.h"
#include "database.h"
#include "logfile.h"

int
main (int argc, char *argv[])
{
  GtkWidget* inWidget;

  gnome_init ("sgcontrol", VERSION, argc, argv);
  if (!g_thread_supported())
  	g_thread_init(NULL);
  gnome_window_icon_set_default_from_file(PACKAGE_PIXMAPS_DIR "/sgcontrol.png");

  if (!gconf_is_initialized())
	  gconf_init (argc, argv, NULL);

  confclient = gconf_client_get_default ();
  if (!confclient) {
	  g_print(_("\nERROR: Could not get GConf client.\n"));
	  return 1;
  }

  /*get program user defaults */
  gconf_client_add_dir (confclient, "/apps/sgcontrol",
  					   GCONF_CLIENT_PRELOAD_RECURSIVE,
  		      		   NULL);
  guint rig_model = gconf_client_get_int (confclient,
				       "/apps/sgcontrol/rig_model",
				       NULL);
  gchar* rig_make = gconf_client_get_string (confclient,
				       "/apps/sgcontrol/rig_make",
				       NULL);
  gchar* rig_name = gconf_client_get_string (confclient,
				       "/apps/sgcontrol/rig_name",
				       NULL);
  gchar* rig_port = gconf_client_get_string (confclient,
				       "/apps/sgcontrol/rig_port",
				       NULL);
  gchar* port_text = gconf_client_get_string (confclient,
				       "/apps/sgcontrol/port_text",
				       NULL);
  guint show_pad = gconf_client_get_int (confclient,
				       "/apps/sgcontrol/keypad",
				       NULL);
  guint show_cpanel = gconf_client_get_int (confclient,
				       "/apps/sgcontrol/controlpanel",
				       NULL);
  guint show_hist = gconf_client_get_int (confclient,
				       "/apps/sgcontrol/history",
				       NULL);
  guint show_plan = gconf_client_get_int (confclient,
				       "/apps/sgcontrol/bandplan",
				       NULL);
  db_name = gconf_client_get_string (confclient,
				       "/apps/sgcontrol/last_db",
				       NULL);
  db_filt = gconf_client_get_string (confclient,
				       "/apps/sgcontrol/last_filter",
				       NULL);
  guint lock_freq = gconf_client_get_int (confclient,
				       "/apps/sgcontrol/lock_freq",
				       NULL);
  log_name = gconf_client_get_string (confclient,
				       "/apps/sgcontrol/last_log",
				       NULL);

  /*gchar* btn_style = gconf_client_get_string (confclient,
				       "/desktop/gnome/interface/toolbar_style",
				       NULL);*/

  db_ext_name = g_strdup("<none>");

  app1 = create_app1 ();
  l_popup = create_LtlTunePopup ();
  b_popup = create_BigTunePopup ();
  
  /*get off-screen images */
  GtkWidget* TuneBar = lookup_widget(app1,"TuneBar");
  GtkWidget* meters_pix = create_pixmap (app1, "sgcontrol/meter.xpm", FALSE);
  gtk_widget_set_name (meters_pix, "meters_pix");
  gtk_widget_ref (meters_pix);
  gtk_object_set_data_full (GTK_OBJECT (app1), "meters_pix", meters_pix,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_fixed_put (GTK_FIXED (TuneBar), meters_pix, 0, 0);
  gtk_widget_set_uposition (meters_pix, 0, 0);
  gtk_widget_set_usize (meters_pix, 816, 32);
  gtk_widget_set_sensitive (meters_pix, FALSE);

  GtkWidget* digits_pix = create_pixmap (app1, "sgcontrol/digits_small.xpm", FALSE);
  gtk_widget_set_name (digits_pix, "digits_pix");
  gtk_widget_ref (digits_pix);
  gtk_object_set_data_full (GTK_OBJECT (app1), "digits_pix", digits_pix,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_fixed_put (GTK_FIXED (TuneBar), digits_pix, 0, 0);
  gtk_widget_set_uposition (digits_pix, 0, 0);
  gtk_widget_set_usize (digits_pix, 204, 24);
  gtk_widget_set_sensitive (digits_pix, FALSE);

  opt1 = create_OptionsDlg();
  mem1 = create_MemWindow();
  tun1 = create_TuningDlg();
  query1 = create_QueryDlg();
  log1 = create_LogWindow();
  lentry = create_LogEntryDlg();

  /*set up faceplate colors */
  gchar* fg_color_str = "#00FF00";
  gchar* bg_color_str1 = "#000000";
  
  set_widget_color(app1,"RadioDisplay",bg_color_str1);
  set_widget_color(app1,"eventbox1",bg_color_str1);
  set_widget_color(app1,"eventbox2",bg_color_str1);
  set_widget_color(app1,"eventbox3",bg_color_str1);
  set_widget_text_color(app1,"MeterLbl",fg_color_str);
  set_widget_text_color(app1,"HzLbl",fg_color_str);
  set_widget_text_color(app1,"MemLbl",fg_color_str);
  set_widget_text_color(app1,"Mem2Lbl",fg_color_str);
  set_widget_text_color(app1,"LocalLbl",fg_color_str);
  set_widget_text_color(app1,"UTCLbl",fg_color_str);
  set_widget_text_color(app1,"Local2Lbl",fg_color_str);
  set_widget_text_color(app1,"UTC2Lbl",fg_color_str);
  set_widget_text_color(app1,"NoiseLbl",fg_color_str);
  set_widget_text_color(app1,"DNRLbl",fg_color_str);
  set_widget_text_color(app1,"AttLbl",fg_color_str);
  set_widget_text_color(app1,"PreampLbl",fg_color_str);
  set_widget_text_color(app1,"NotchLbl",fg_color_str);
  set_widget_text_color(app1,"ANFLbl",fg_color_str);
  set_widget_text_color(app1,"TapeLbl",fg_color_str);
  set_widget_text_color(app1,"TimerLbl",fg_color_str);
  set_widget_text_color(app1,"ScanLbl",fg_color_str);
  set_widget_text_color(app1,"Scan2Lbl",fg_color_str);
  set_widget_text_color(app1,"VFOLbl",fg_color_str);
  set_widget_text_color(app1,"AntLbl",fg_color_str);
  set_widget_text_color(app1,"AGCLbl",fg_color_str);
  set_widget_text_color(app1,"BWLbl",fg_color_str);
  set_widget_text_color(app1,"ModeLbl",fg_color_str);
  set_widget_text_color(app1,"ModeLbl",fg_color_str);
  //set_widget_text_color(app1,"timer1",fg_color_str);

  /*hide some yet unimplemented things */

  /*Main Window*/
  /*File Menu*/
  set_visible(app1,"SaveBtn",FALSE);
  set_visible(app1,"save_database1",FALSE);
  set_visible(app1,"SaveAsBtn",FALSE);
  set_visible(app1,"save_database_as1",FALSE);
  set_visible(app1,"dump_database1",FALSE);
  set_visible(app1,"UpdateBtn",FALSE);
  set_visible(app1,"update_database1",FALSE);
  set_visible(app1,"import_database1",FALSE);
  set_visible(app1,"PrintBtn",FALSE);
  set_visible(app1,"printer_setup1",FALSE);
  set_visible(app1,"separator4",FALSE);
  set_visible(app1,"vseparator8",FALSE);
  /*Edit Menu*/
  set_visible(app1,"mark1",FALSE);
  set_visible(app1,"delete1",FALSE);
  /*View Menu*/
  set_visible(app1,"pan_display1",FALSE);
  /*Radio Menu*/
  set_visible(app1,"TapeBtn",FALSE);
  set_visible(app1,"tape_vox1",FALSE);
  set_visible(app1,"separator20",FALSE);
  set_visible(app1,"other1",FALSE);
  set_visible(app1,"vseparator3",FALSE);
  /*Tuning Menu*/
  set_visible(app1,"edit_step_sizes1",FALSE);
  set_visible(app1,"separator10",FALSE);
  set_visible(app1,"ScanBtn",FALSE);
  set_visible(app1,"scan_mode1",FALSE);
  set_visible(app1,"scan_pause1",FALSE);
  set_visible(app1,"scan_parameters1",FALSE);
  set_visible(app1,"separator12",FALSE);
  set_visible(app1,"TimerBtn",FALSE);
  set_visible(app1,"timer_mode1",FALSE);
  set_visible(app1,"ShowTimerBtn",FALSE);
  set_visible(app1,"timer_parameters1",FALSE);
  set_visible(app1,"separator13",FALSE);
  set_visible(app1,"ConnectBtn",FALSE);
  set_visible(app1,"disconnect1",FALSE);
  /*Memory Menu*/
  set_visible(app1,"new1",FALSE);
  set_visible(app1,"open1",FALSE);
  set_visible(app1,"save1",FALSE);
  set_visible(app1,"save_as1",FALSE);
  set_visible(app1,"print1",FALSE);
  set_visible(app1,"separator14",FALSE);
  set_visible(app1,"separator15",FALSE);
  set_visible(app1,"fill_radio1",FALSE);
  set_visible(app1,"insert_channel1",FALSE);
  /*Query Menu*/
  set_visible(app1,"ProgBtn",FALSE);
  set_visible(app1,"swbc_programs1",FALSE);
  set_visible(app1,"UsageBtn",FALSE);
  set_visible(app1,"find_freq_usage1",FALSE);
  set_visible(app1,"print_station_sked1",FALSE);
  /*Log Menu*/
  set_visible(app1,"print2",FALSE);
  set_visible(app1,"export1",FALSE);
  /*Tools Menu*/
  set_visible(app1,"hf_prediction1",FALSE);
  set_visible(app1,"separator9",FALSE);
  set_visible(app1,"CloseWinBtn",FALSE);
  set_visible(app1,"close_windows1",FALSE);
  /*Help Menu*/
  set_visible(app1,"contents1",FALSE);
  set_visible(app1,"topic_search1",FALSE);
  set_visible(app1,"using_help1",FALSE);
  set_visible(app1,"separator7",FALSE);
  set_visible(app1,"faceplate_operation1",FALSE);
  set_visible(app1,"memory_management1",FALSE);
  set_visible(app1,"logging_system1",FALSE);
  set_visible(app1,"separator8",FALSE);

  /*Memory Window*/
  /*File Menu*/
  set_visible(mem1,"button18",FALSE);
  set_visible(mem1,"new4",FALSE);
  set_visible(mem1,"button19",FALSE);
  set_visible(mem1,"open4",FALSE);
  set_visible(mem1,"button20",FALSE);
  set_visible(mem1,"save3",FALSE);
  set_visible(mem1,"button21",FALSE);
  set_visible(mem1,"save_as4",FALSE);
  set_visible(mem1,"button22",FALSE);
  set_visible(mem1,"print4",FALSE);
  set_visible(mem1,"vseparator18",FALSE);
  /*Edit Menu*/
  set_visible(mem1,"vseparator19",FALSE);
  set_visible(mem1,"button25",FALSE);
  set_visible(mem1,"set3",FALSE);
  set_visible(mem1,"button26",FALSE);
  set_visible(mem1,"modify3",FALSE);
  set_visible(mem1,"button28",FALSE);
  set_visible(mem1,"move1",FALSE);
  set_visible(mem1,"button27",FALSE);
  set_visible(mem1,"insert1",FALSE);
  set_visible(mem1,"button29",FALSE);
  set_visible(mem1,"clear1",FALSE);
  /*Sort Menu*/
  set_visible(mem1,"sort1",FALSE); 
  /*Tools Menu*/
  set_visible(mem1,"fill1",FALSE);
  set_visible(mem1,"separator23",FALSE);
  set_visible(mem1,"edit_comment1",FALSE);

  /*Database Window*/
  /*Edit Menu*/
  set_visible(tun1,"MarkBtn",FALSE);
  set_visible(tun1,"mark3",FALSE);
  set_visible(tun1,"ModifyBtn",FALSE);
  set_visible(tun1,"modify1",FALSE);
  set_visible(tun1,"InsertAbvBtn",FALSE);
  set_visible(tun1,"insert_above1",FALSE);
  set_visible(tun1,"InsertBlwBtn",FALSE);
  set_visible(tun1,"insert_below1",FALSE);
  set_visible(tun1,"DeleteBtn",FALSE);
  set_visible(tun1,"delete2",FALSE);
  set_visible(tun1,"separator21",FALSE);
  set_visible(tun1,"select_all1",FALSE);
  set_visible(tun1,"select_marked1",FALSE);
  set_visible(tun1,"vseparator13",FALSE);
  /*View Menu*/
  /*Filter Menu*/

  /*Log Window*/
  /*File Menu*/
  set_visible(log1,"separator24",FALSE);
  set_visible(log1,"LogExportBtn",FALSE);
  set_visible(log1,"log_export_all",FALSE);
  set_visible(log1,"log_export_selected",FALSE);
  set_visible(log1,"separator25",FALSE);
  set_visible(log1,"LogPrintBtn",FALSE);
  set_visible(log1,"log_print",FALSE);
  set_visible(log1,"log_print_report",FALSE);
  /*Edit Menu*/
  /*Sort Menu*/
  set_visible(log1,"log_frequency",FALSE);
  set_visible(log1,"log_time",FALSE);
  set_visible(log1,"log_date",FALSE);
  set_visible(log1,"log_mode",FALSE);
  set_visible(log1,"log_sinpo",FALSE);
  set_visible(log1,"log_call",FALSE);
  set_visible(log1,"log_country",FALSE);
  set_visible(log1,"log_station",FALSE);
  set_visible(log1,"log_original_order",FALSE);
  /*Format Menu*/
  set_visible(log1,"log_export_format",FALSE);
  set_visible(log1,"log_report_format",FALSE);

  /* set display highlighting colors */
  high_color_str = "#0000FF";
  reg_color_str = "#000000";
  inact_color_str = "#909090";
  bg_color_str = "#FFFFFF";
  bg_color_str2 = "#FFFFDF";

  /*set global l&f for the toolbars */
  GtkToolbarStyle style = GTK_TOOLBAR_ICONS;
  /*if (btn_style) {
  	if (strcmp(btn_style,"both")==0)
		style = GTK_TOOLBAR_BOTH;
	if (strcmp(btn_style,"both_horiz")==0)
		style = GTK_TOOLBAR_BOTH;
	if (strcmp(btn_style,"text")==0)
		style = GTK_TOOLBAR_TEXT;
	if (strcmp(btn_style,"both_horiz")==0)
		style = GTK_TOOLBAR_BOTH;
  }*/
  set_toolbar_style(app1,"RadioBar",style);
  set_toolbar_style(app1,"DatabaseBar",style);

  /*set up justification in clist columns */
  inWidget = lookup_widget(app1,"clist1");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),1,GTK_JUSTIFY_CENTER);
  inWidget = lookup_widget(app1,"HistList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),1,GTK_JUSTIFY_RIGHT);
  inWidget = lookup_widget(app1,"BCList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),0,GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),1,GTK_JUSTIFY_RIGHT);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),2,GTK_JUSTIFY_RIGHT);
  inWidget = lookup_widget(app1,"UteList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),0,GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),1,GTK_JUSTIFY_RIGHT);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),2,GTK_JUSTIFY_RIGHT);

  inWidget = lookup_widget(mem1,"MemList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),1,GTK_JUSTIFY_RIGHT);

  inWidget = lookup_widget(log1,"LogList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),0,GTK_JUSTIFY_RIGHT);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),1,GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),2,GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),3,GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),4,GTK_JUSTIFY_CENTER);

  inWidget = lookup_widget(tun1,"SkedList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),1,GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),5,GTK_JUSTIFY_RIGHT);
  inWidget = lookup_widget(tun1,"BCList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),0,GTK_JUSTIFY_CENTER);
  inWidget = lookup_widget(tun1,"UteList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),0,GTK_JUSTIFY_CENTER);
  inWidget = lookup_widget(tun1,"BCBList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),0,GTK_JUSTIFY_CENTER);
  inWidget = lookup_widget(tun1,"WhoList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),1,GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),5,GTK_JUSTIFY_RIGHT);
  inWidget = lookup_widget(tun1,"FreqList");
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),1,GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_justification(GTK_CLIST(inWidget),3,GTK_JUSTIFY_RIGHT);
  
  fill_band_display();

  /*set callbacks for sliders in the control panel */
  inWidget = lookup_widget(app1,"AFScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_af), NULL);
  inWidget = lookup_widget(app1,"RFScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_rf), NULL);
  inWidget = lookup_widget(app1,"IFScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_if), NULL);
  inWidget = lookup_widget(app1,"PIScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_pi), NULL);
  inWidget = lookup_widget(app1,"POScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_po), NULL);
  inWidget = lookup_widget(app1,"CPScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_cp), NULL);
  inWidget = lookup_widget(app1,"SQScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_sq), NULL);
  inWidget = lookup_widget(app1,"NOScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_no), NULL);
  inWidget = lookup_widget(app1,"NRScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_nr), NULL);
  inWidget = lookup_widget(app1,"APScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_ap), NULL);
  /*inWidget = lookup_widget(app1,"TOScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_to), NULL);*/
  inWidget = lookup_widget(app1,"BWCScale");
  gtk_signal_connect(GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE (inWidget))),
				    "value-changed", GTK_SIGNAL_FUNC (set_bwc), NULL);
  
  rig_set_debug(RIG_DEBUG_WARN);

  /* set up radio list and radio options */
  inWidget = lookup_widget(opt1,"RadioList");
  if (inWidget) {
	GSList* rig_list = get_hamlib_radio_list();
    hamlib_fill_radio_list(rig_list, GTK_CLIST(inWidget));
    gint row = gtk_clist_find_row_from_data(GTK_CLIST(inWidget),GUINT_TO_POINTER(rig_model));
    if (row != -1) {
      gtk_clist_select_row(GTK_CLIST(inWidget),row,0);
	}
  }
  set_text(opt1,"PortBoxEdit",rig_port);
  set_text(opt1,"PortEdit",port_text);

  gtk_widget_show (app1);

  if (show_pad == 1)
	  set_checked(app1,"keypad1",TRUE);
  if (show_cpanel == 1)
	  set_checked(app1,"control_panel1",TRUE);
  if (show_hist == 1)
	  set_checked(app1,"history1",TRUE);
  if (show_plan == 1)
	  set_checked(app1,"band_plan1",TRUE);
  set_down(tun1,"FreqLockBtn",(lock_freq == 1));

  has_get_freq = TRUE;
  has_get_vfo = TRUE;
  has_set_vfo = TRUE;
  has_get_mode = TRUE;
  has_set_mode = TRUE;
  has_power = TRUE;
  has_noise = TRUE;
  has_dnr = TRUE;
  has_atten = TRUE;
  has_preamp = TRUE;
  has_notch = TRUE;
  has_anf = TRUE;
  has_vfo = TRUE;
  has_get_agc = TRUE;
  has_set_agc = TRUE;
  has_get_ant = TRUE;
  has_set_ant = TRUE;
  has_meter = TRUE;
  ispower=FALSE;
  isnoise=FALSE;
  isdnr=FALSE;
  isnotch=FALSE;
  isanf=FALSE;
  istape=FALSE;
  ismem=FALSE;
  isscan=FALSE;
  istimer=FALSE;
  vfo=1;
  ant=1;
  agc=3;
  bw=2;
  mode=1;
  memch=0;
  cur_atten=0;
  cur_preamp=0;
  frequency=0.0;
  atten_val[0]=0;
  preamp_val[0]=0;
  minf=0;
  maxf=30000000;
  meter_level = 0;
  tune_ok = TRUE;
  hist_index = -1;
  hist_total = 0;
  num_freqs = 0;
  num_stats = 0;
  num_couns = 0;
  num_langs = 0;
  sml_step = 0.01;
  lrg_step = 5.00;

  prep_user_dir();

  g_timeout_add(500, (GSourceFunc)get_meter, NULL);
  
  hamlib_new(rig_model,rig_port,port_text,rig_make,rig_name);

  if (db_name)
	  open_database();

  if (log_name == NULL)
  	log_name = g_strdup_printf("%s/sgcontrol.log",get_user_base());
  if (log_name)
	open_logfile();
  
  gtk_main ();

  return 0;
}

