/***************************************************************************
                          interface_callbacks__track_properties.cpp  -  description
                             -------------------
    begin                : Thu Oct 19 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

/********************************************************
                       B U T T O N S
*********************************************************/
void Interface::button_track_clone_pressed() {

	if (song->get_tracks()==0) {

		return;
	}

	player->stop();

	song->clone_track(selected_track);
	selected_track++;
        update_track_list();

	player->reset();
}

void Interface::button_track_add_variables_pressed() {

	variables_popup=new Window_Variables_Popup(song,selected_track);
	variables_popup->button_ok.clicked.connect(slot(this,&Interface::popup_variables_ok_pressed));
}

void Interface::button_track_new_pressed() {

	if (song->get_tracks()==0) {

		if (selected_track==-1) selected_track=0;
		cout << "Enabling back stuff?? " << endl;
	}

	player->stop();

	song->add_track(1);

	selected_track=song->get_tracks()-1;

	request_update_track_properties(selected_track);		
	
        update_track_list();

	player->reset();


}

void Interface::button_value_delete_pressed(int p_index) {

	int i;
        Instrument::Initial_Value_List::iterator I;
	I=song->get_instrument(selected_track)->initial_value.begin();

	for (i=0;i<initial_values.size();i++) {

                if (i==p_index) {
		
			song->get_instrument(selected_track)->initial_value.erase(I);
			break;
		}
		
         	I++;
	}

	request_update_track_properties(selected_track);
			
}

void Interface::button_track_remove_pressed() {

	if (song->get_tracks()==0) return;

	player->stop();

	song->delete_track(selected_track);
	if (song->get_tracks()==0) {

		selected_track=-1;
	}

	if (selected_track>=song->get_tracks()) selected_track=song->get_tracks()-1;
	request_update_track_properties(selected_track);
        update_track_list();

	player->reset();


}

void Interface::button_track_moveup_pressed() {

	player->stop();

	if (song->move_track_up(selected_track)) {

		selected_track--;
	        update_track_list();
	}
	
	player->reset();

}

void Interface::button_track_movedown_pressed() {

	player->stop();

	if (song->move_track_down(selected_track)) {

		selected_track++;
	        update_track_list();
	}


	player->reset();
}

/********************************************************
                       C L I S T s
*********************************************************/


void Interface::clist_track_list_row_clicked(gint row,gint column,GdkEvent *event) {
	
        selected_track=row;
	request_update_track_properties(selected_track);

}

void Interface::clist_track_patches_row_clicked(gint row,gint column,GdkEvent *event) {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->midi.patch=row;
	entry_track_selected_patch->set_text(clist_track_patches->get_text(row,column));	

}


/********************************************************
                       C O M B O s
*********************************************************/

int Interface::string_to_int(string inputstring) {

	int tmpnum;

	tmpnum=(inputstring[0]-'0')*100;
	tmpnum+=(inputstring[1]-'0')*10;
	tmpnum+=(inputstring[2]-'0');

	return tmpnum;
}



void Interface::combo_track_devices_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->midi.device=string_to_int(combo_track_devices->get_entry()->get_text());
	song->get_instrument(selected_track)->midi.bank=0;

	track_properties_updating_in_progress=true;
		
	request_update_combobox_banks(selected_track);
	request_update_clist_patches(selected_track);

	track_properties_updating_in_progress=false;


}

void Interface::combo_track_banks_changed() {

 	if (track_properties_updating_in_progress) return; 	

	song->get_instrument(selected_track)->midi.bank=string_to_int(combo_track_banks->get_entry()->get_text());

	track_properties_updating_in_progress=true;
		
	request_update_clist_patches(selected_track);

	track_properties_updating_in_progress=false;

}

void Interface::entry_track_name_changed() {

 	if (track_properties_updating_in_progress) return; 	

	// first update it internally
	song->get_instrument(selected_track)->name=entry_track_name->get_text();
	// then re-add it to the CLIST
	track_list->set_text(selected_track,0,song->get_instrument(selected_track)->name);

}

/********************************************************
                 S P I N B U T T O N S
*********************************************************/



void Interface::spinbutton_track_channel_adj_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->midi.channel=spinbutton_track_channel->get_value_as_int()-1;

}

void Interface::spinbutton_track_def_volume_adj_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->def_volume=spinbutton_track_def_volume->get_value_as_int();
}

void Interface::spinbutton_track_glb_volume_adj_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->glb_volume=spinbutton_track_glb_volume->get_value_as_int();
}
void Interface::spinbutton_track_bender_sens_adj_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->midi.PBS=spinbutton_track_bender_sens->get_value_as_int();

}
void Interface::spinbutton_track_bender_def_adj_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->midi.DBV=spinbutton_track_bender_def->get_value_as_int();
}
void Interface::spinbutton_track_volume_post_controller_adj_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->PNVA_controller=spinbutton_track_volume_post_controller->get_value_as_int();
}


void Interface::spinbutton_track_controller_list_adj_changed(int whichone) {

	if (track_properties_updating_in_progress) return;	
	
//	song->get_instrument(selected_track)->initial_controller_value[whichone]=controller_line[whichone].controller_spinbutton->get_value_as_int();

}



/********************************************************
                  R A D I O B U T T O N s
*********************************************************/

void Interface::radiobutton_tracker_post_volume_nothing_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->PNVA_type=Instrument::PNVA_NOTHING;
	
}
void Interface::radiobutton_tracker_post_volume_note_aftertouch_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->PNVA_type=Instrument::PNVA_NOTE_AFTERTOUCH;

}
void Interface::radiobutton_tracker_post_volume_channel_aftertouch_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->PNVA_type=Instrument::PNVA_CHAN_AFTERTOUCH;

}
void Interface::radiobutton_tracker_post_volume_controller_changed() {

 	if (track_properties_updating_in_progress) return;

	song->get_instrument(selected_track)->PNVA_type=Instrument::PNVA_CONTROLLER;

}
void Interface::radiobutton_track_volume_behavior_normal_changed() {

 	if (track_properties_updating_in_progress) return;

        song->get_instrument(selected_track)->VCB=Instrument::VCB_NORMAL;

}
void Interface::radiobutton_track_volume_behavior_tracker_changed() {

 	if (track_properties_updating_in_progress) return;

        song->get_instrument(selected_track)->VCB=Instrument::VCB_TRACKER;

}

void Interface::togglebutton_track_mute_pressed() {

	cout << "toggle mute pressed" << endl;	
}