/***************************************************************************
                          instrument.h  -  description
                             -------------------
    begin                : Sun Sep 17 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INSTRUMENT_H
#define INSTRUMENT_H

#include "typedefs.h"
#include "int_value.h"
#include <list>
/**Shake Instrument definition
  *@author Juan Sebastian Linietsky
  */

/*

	Data contained for each track's instrument.
	Includes some midi initial info and other hacks.
*/



struct Instrument {

        struct Initial_Value {

		enum Types {

			CONTROLLER,
			MACRO
		};

		char type;
		Int_Value value;

		union {

			int controller;
			int macro;
		};

                Initial_Value() : value(-1,127) {

		}
	};

	struct Midi_Data {

		Int_Value device;
		Int_Value bank;
		Int_Value patch;
	 	Int_Value channel;
		Int_Value PBS; // initial pitch bend sensitivity
		Int_Value DBV; // default bender value
	
		Midi_Data() : device(0,127),bank(0,127),patch(0,127),channel(0,15),PBS(1,127),DBV(1,127) {

		};

	};
        typedef list<Initial_Value> Initial_Value_List;
	Initial_Value_List initial_value;

	/* Volume hacking because in midi, volume is not linear most of the times */
	bool force_linear_volume;
	char linear_volume_forcing_table[128];

	/* Instrument muted (should be heard or not) */
	bool mute;

	/* Name */	
	string name;

	/* post note volume action */
	enum PNVA {

		PNVA_NOTHING,
		PNVA_NOTE_AFTERTOUCH,
		PNVA_CHAN_AFTERTOUCH,
		PNVA_CONTROLLER
	};	

	enum VCB {

		VCB_NORMAL,
		VCB_TRACKER		
	};

	/* Midi Specific */
        Midi_Data midi;

	/* initial values */
	Int_Value def_volume;
	Int_Value glb_volume;

	Int_Value PNVA_type;
	Int_Value VCB;


	Int_Value PNVA_controller;

	/* clear instrument data */

	void set_name(string p_name);

	void clear();

	/* ctor/dtor/operators */
	Instrument();
	~Instrument();
};

#endif
