/* Public domain. */

#include "uint32.h"
#include "biguint.h"

/*
   q = y/x mod m. m and x must be relatively prime. Otherwise, infinite loop.
   Original idea: see http://research.sun.com/techrep/2001/abstract-95.html
*/

int bu_divmod (uint32 *q, uint32 const *y, uint32 const *x, uint32 const *m, unsigned int n)
{
  uint32 aa[BIGUINT_MAXLIMBS] ;
  uint32 bb[BIGUINT_MAXLIMBS] ;
  uint32 uu[BIGUINT_MAXLIMBS] ;
  uint32 vv[BIGUINT_MAXLIMBS] ;  /* fixed */
  register uint32 *a = aa, *b = bb, *u = uu, *v = vv ; /* may move around */

 /* init: a=x, b=m, u=y, v=0 */
  bu_copy(a, x, n) ;
  bu_copy(b, m, n) ;
  bu_copy(u, y, n) ;
  bu_zero(v, n) ;

 /*** XXX: this iterates much, should be optimized */
  for (;;)
  {
    while (!(a[0] & 1))
    {
      bu_srb(a, n) ;
      if (u[0] & 1) bu_add(u, u, m, n) ;
      bu_srb(u, n) ;
    }
    if ((a[0] == 1) && (bu_len(a, n) == 1)) break ;
    if (bu_cmp(a, b, n) < 0)
    {
      register uint32 *t = a ; a = b ; b = t ;
      t = u ; u = v ; v = t ;
    }
    bu_add(a, a, b, n) ;
    bu_add(u, u, v, n) ;
  }
  bu_copy(q, u, n) ;
  return 1 ;
}
