%{

#include <stdlib.h>
#include <stdio.h>
#include "symbol.h"
#include "scanner.h"

extern int yylex();
extern int yyerror(const char *);

%}

%union {
  symbol_t symbol;
  int value;
}

%token <symbol> ID
%type <value> expr bool
%token BOOL TRUTH FALSEHOOD IF ELSE OTHER
%left OR
%left XOR
%left AND
%right NOT
%left EQ NEQ
%start start
%%

start:
  policy { print_end(); }
;

policy:

| policy item
;

item:
  ID { print_token(); }
| NOT { print_token(); }
| EQ { print_token(); }
| NEQ { print_token(); }
| AND { print_token(); }
| XOR { print_token(); }
| OR { print_token(); }
| OTHER { print_token(); }
| ';' { print_token(); }
| '(' { print_token(); }
| ')' { print_token(); }
| '{' { print_token(); } policy '}' { print_token(); }
| BOOL ID bool ';' { assign($2, $3); }
| IF cond
;

cond:
  expr '{'
  { if (muted()) $1 |= 2; else print_text("\n"); if (!$1) mute(1); }
  policy '}' otherwise
  { if (!($1&2)) mute(0); }
;

otherwise:

| ELSE '{'
  { if (!($<value>-5&2)) mute($<value>-5); }
  policy '}'
;

bool:
  FALSEHOOD { $$ = 0; }
| TRUTH { $$ = 1; }
;

expr:
  ID { $$ = fetch($1); }
| bool
| expr OR expr { $$ = $1 || $3; }
| expr XOR expr { $$ = $1 ^ $3; }
| expr AND expr { $$ = $1 && $3; }
| NOT expr { $$ = !$2; }
| expr EQ expr { $$ = $1 == $3; }
| expr NEQ expr { $$ = $1 != $3; }
| '(' expr ')' { $$ = $2; }
;
%%
