/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_GTK

#include "../player.h"
#include "../other.h"
#include "graphic.h"
#include "queue.h"

void
queue_insert (list * data)
{
  queue *q, *t;
  int i = 1;

  pthread_mutex_lock (&play->queue_mutex);

  q = play->queue_list;
  if (q)
    {
      if (q->item == data)
	{
	  play->queue_list = play->queue_list->next;
	  q->item->queue = 0;
	  free (q);
	  queue_refresh ();
	  pthread_mutex_unlock (&play->queue_mutex);
	  return;
	}

      while (q->next)
	{
	  if (data == q->next->item)
	    {
	      t = q->next;
	      t->item->queue = 0;
	      q->next = t->next;
	      free (t);
	      queue_refresh ();
	      pthread_mutex_unlock (&play->queue_mutex);
	      return;
	    }

	  q = q->next;
	}
    }

  if (!(q = (queue *) malloc (sizeof (queue))))
    fatal (_("Error: memory."));

  q->item = data;
  q->next = NULL;

  if (!play->queue_list)
    play->queue_list = q;
  else
    {
      t = play->queue_list;
      while (t->next)
	{
	  i++;
	  t = t->next;
	}

      i++;
      t->next = q;
    }

  data->queue = i;
  queue_refresh ();

  pthread_mutex_unlock (&play->queue_mutex);
}

list *
queue_next (void)
{
  list *data = NULL;

  pthread_mutex_lock (&play->queue_mutex);
  if (play->queue_list)
    {
      queue *q = play->queue_list;
      data = q->item;
      data->queue = 0;
      play->queue_list = q->next;
      free (q);

      q = play->queue_list;
      while (q)
	{
	  q->item->queue--;
	  q = q->next;
	}
    }

  queue_refresh ();

  pthread_mutex_unlock (&play->queue_mutex);

  return data;
}

void
queue_remove (list * d)
{
  queue *data;

  if (!play->queue_list)
    return;

  pthread_mutex_lock (&play->queue_mutex);

  data = play->queue_list;
  if (data->item == d)
    {
      play->queue_list = data->next;
      free (data);
    }

  else
    {

      data = play->queue_list;
      while (data)
	{
	  if (data->next && data->next->item == d)
	    {
	      queue *t = data->next;
	      data->next = data->next->next;
	      free (t);
	      break;
	    }

	  data = data->next;
	}
    }

  if (data)
    queue_refresh ();

  pthread_mutex_unlock (&play->queue_mutex);
}

void
queue_refresh (void)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  list *data;
  char *n = NULL;
  queue *q;
  char num[10];
  int i = 1;

  q = play->queue_list;
  while (q)
    {
      q->item->queue = i++;
      q = q->next;
    }

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (playlist));
  if (gtk_tree_model_get_iter_first (model, &iter) != TRUE)
    return;

  do
    {
      gtk_tree_model_get (model, &iter, 1, &data, 2, &n, -1);
      i = 0;

      q = play->queue_list;
      while (q)
	{
	  if (q->item == data)
	    {
	      i = 1;
	      if (((!n || !n[0]) && q->item->queue)
		  || ((n && n[0]) && q->item->queue != atoi (n)))
		{
		  if (q->item->queue)
		    snprintf (num, sizeof (num), "%d", q->item->queue);
		  else
		    num[0] = 0;

		  gtk_list_store_set (GTK_LIST_STORE (model), &iter, 2, num,
				      -1);
		}
	    }

	  q = q->next;
	}

      if (n && n[0] && !i)
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, 2, "", -1);
    }
  while (gtk_tree_model_iter_next (model, &iter));
}

#endif

/* EOF */
