/*
	writer	: Ma Su An
	E-Mail	: msa@wri.com.cn
	
	Copyright by Ma Su An.
	All rights reserved.
	Permission to use ,copy,modify,and distribute this software for
	individual use and without fee is granted with that condition:

    	Every copy of this software must have the writer's name displayed 
	on the top label.
*/

// filename: regdef.cc
// msa 1999.1

#include <assert.h>
#include <string.h>

#include "regdef.h"

//*****************************************************************
MSARegExp::MSARegExp(char* sRule)
{
	assert(sRule!=NULL);
	if(sRule==NULL) 
	{
		iStatus_=ILLEGAL;
		return;
	}
	
	int iError=regcomp(&reg_,sRule,REG_EXTENDED|REG_ICASE);
	if(!iError)
	{
		iStatus_=OK;
	}
	else
	{
		if(iError==REG_ESPACE) iStatus_=TOOLONG; // overflow
		else		iStatus_=ILLEGAL;
	}
	return;
}

//*****************************************************************
MSARegExp::~MSARegExp()
{
	regfree(&reg_);
	return;
}

//*****************************************************************
int MSARegExp::bIsMatch(const char* sWord,int& iFrom,int& iLength) const
{
	assert(iStatus()==OK);
	if(iStatus()!=OK) return(0);
	if(sWord==NULL) return(0);

	int bMatch;
	regmatch_t pmatch;
	if(!regexec(&reg_,sWord,1,&pmatch,0))
	{
		bMatch=1;
		iFrom=pmatch.rm_so;
		iLength=pmatch.rm_eo-pmatch.rm_so;
	}
	else
	{
		bMatch=0;
	}

	return(bMatch);
}

//*****************************************************************
int MSARegExp::bIsMatch(const char* sWord,char* sBuff,int iBuffLen) const
{
	int iFrom,iLength;
	int bMatch=bIsMatch(sWord,iFrom,iLength);
	if(bMatch)
	{
		// get effective march length.
		int iRealLen;
		if(iLength<iBuffLen-1) iRealLen=iLength;
		else			iRealLen=iBuffLen-1;

		// copy march length to sBuff.
		char* sTmpBuff=new char[iRealLen+1];
		memcpy(sTmpBuff,sWord+iFrom,iRealLen);
		sTmpBuff[iRealLen]='\0';
		strcpy(sBuff,sTmpBuff);
		delete []sTmpBuff;
	}

	return(bMatch);
}

//*****************************************************************
int MSARegExp::bIsEntireMatch(const char* sWord) const
{
	int iFrom,iLength;
	int bMatch=bIsMatch(sWord,iFrom,iLength);
	return(bMatch && iFrom==0 && sWord[iLength]=='\0');
}

//****************************** END ******************************
