inherit "/classes/Object";

#include <macros.h>

static int    iRemote_ObjectID; // the id of the remote object
static string sRemote_ServerID; // the remote server the object is located
static int              iLocal; 
static int     iTemporary = -1;
static function fExecuteRemote;

static mapping fTableRemote = ([ ]);


void set_remote_ObjectID(int objectID)
{
    iRemote_ObjectID = objectID;
    write(sprintf("\nSet_remote_ObjectID to: %d\n",iRemote_ObjectID));
    require_save();
}

void set_remote_ServerID(string serverID) 
{
    sRemote_ServerID = serverID;
    require_save();
}

int get_remote_ObjectID() 
{
    return iRemote_ObjectID;
}

string get_remote_ServerID() 
{
    return sRemote_ServerID;
}

int set_temporary() 
{
    iTemporary = 1;
    write("Shadow.pike: set_temporary!\n");
    return iTemporary;
}

mixed `[](mixed index) 
{
    mixed m;
    if (is_local()==0)
    {
	if (m = fTableRemote[index]) {
	    return m;
	}
	else {
	    fTableRemote[index] = getlambda(index);
	    return fTableRemote[index];
	}
    }
    write("\nShadow> Failed Indexing: "+ index +"\n");
    return 0;
}

function getlambda (string fname) 
{
    return  lambda (mixed args) {  
	return remote_call(fname, args); 
    };
}


static mixed remote_call(string fname, mixed args) 
{
    write( sIdentifier + "("+ iObjectID +")" + ": remote_call on: ");
    write(sprintf("%d@%s",iRemote_ObjectID, sRemote_ServerID));
    write("\n");

    mixed result = fExecuteRemote(this_user(), iRemote_ObjectID,
				  sRemote_ServerID, fname, args);
    if (!result) {
        write("\nShadow: Kein Result!\n");
        return 0;
    }
    else {
        return result;
    }
    object cluster = get_module("Cluster");
    if ( objectp(cluster) )
	return cluster->send_command(
	    sRemote_ServerID, iRemote_ObjectID, fname, args);
    steam_error("Failed to locate server cluster.");
}

int is_local() 
{
    return iLocal;
}

bool is_shadow() 
{
    return true;
}

