#include <classes.h>
#include <attributes.h>
#include <macros.h>

string contentof(object obj)
{
  return obj->get_content();
}

string get_thumbnail(object img, int xsize, int ysize, bool|void maintain)
{
    object thumb;

    thumb= img->query_attribute(DOC_IMAGE_THUMBNAIL);
    if ( objectp(thumb) && thumb->query_attribute(DOC_IMAGE_SIZEX) == xsize )
      return thumb->get_content();
    return query_thumbnail(img, xsize, ysize, maintain);
}

string query_thumbnail(object img, int xsize, int ysize, bool|void maintain)
{
#if !constant(Image.JPEG)
  return "";
#else
    int        factor;
    mapping  imageMap;
    Image.Image image;
 
    [imageMap, image ] = get_image(img);

    int rxsize, rysize;

    if ( xsize == 0 )
	xsize = image->xsize();
    if ( ysize == 0 )
	ysize = image->ysize();

    if ( maintain ) {
	rxsize = image->xsize();
	rysize = image->ysize();
	factor = min(xsize*100/rxsize, ysize*100/rysize);
    }
    if ( factor > 100 )
	factor = 100;
    xsize = factor * rxsize / 100;
    ysize = factor * rysize / 100;

    object new_image = image->scale(xsize, ysize);
    
    string str = Image.JPEG.encode(new_image);
    destruct(image);
    destruct(new_image);
    return str;
#endif
    
}

string get_image_data(object obj)
{
#if constant(Image.JPEG)
    if ( intp(obj->query_attribute(DOC_IMAGE_ROTATION)) &&
	 obj->query_attribute(DOC_IMAGE_ROTATION) > 0  ) 
    {
	Image.Image image = get_image(obj)[1];
	string str = Image.JPEG.encode(image);
	destruct(image);
	return str;
    }
#endif
    return contentof(obj);
}

array get_image(object obj)
{
    string        mt;
    mapping imageMap;
    int       factor;
    
    mt = obj->query_attribute(DOC_MIME_TYPE);

    switch ( mt ) {
    case "image/gif":
#if constant(Image.GIF)
	imageMap = Image.GIF.decode_map(contentof(obj));
#endif
	break;
    case "image/jpeg":
#if constant(Image.JPEG)
	imageMap = Image.JPEG._decode(contentof(obj));
#endif
	break;
#if constant(Image.PNG) && constant(Image.PNG._decode) 
    case "image/png":
	imageMap = Image.PNG._decode(contentof(obj));
	break;
#endif
    case "image/bmp":
	imageMap = Image.BMP._decode(contentof(obj));
	break;
    default:
	imageMap = Image.ANY._decode(contentof(obj));
	break;
    }
    
    Image.Image image = imageMap->image;
    if ( intp(obj->query_attribute(DOC_IMAGE_ROTATION)) ) {
	image = image->rotate(obj->query_attribute(DOC_IMAGE_ROTATION));
	imageMap->xsize = image->xsize();
	imageMap->ysize = image->ysize();
    }

    return ({ imageMap, image });
}

object this() { return get_module("thumbnails"); }
object get_object() { return get_module("thumbnails"); }
int get_object_id() { return 1; }
bool trust(object obj) { return true; }
string get_identifier() { return "Graphic Module"; }
