/*
 *  word.h
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __WORD_H__
#define __WORD_H__
typedef enum _word_type {
    WORD_TYPE_ANTHY,
    WORD_TYPE_CANNA,
    WORD_TYPE_SKK,
    WORD_TYPE_PRIME,
} word_type;

typedef struct _word {
    word_type   type;               /* : word_type*/

    /* common fields */
    char       *phon;		    /* ɤ */
    char       *desc;	            /*  */
    char       *cclass_code;	    /* ʻ쥳 or ʻ */
    int	        freq;		    /*  */

    /* SKK specific fields */
    int	        okuri;	            /* ̵ͭ (boolean) */
    char       *following_kana;     /* ͭξ˼³꤬ XXX */
    char       *annotation;	    /* Υơ */

    struct _word *next;
} word;

/* ͤޤäƤʤΤǾά */
/* prototypes */
void  word_append    (word ** head, word_type type,
		      char *phon, char *desc,
		      char *cclass_code, int freq,
		      int okuri, char *annotation);
void  word_free_list (word *head);
word *word_last      (word *list);
#endif /* __WORD_H__ */
