# $Id: FileTree.py,v 1.21 2003/01/16 17:01:14 chalky Exp $
#
# This file is a part of Synopsis.
# Copyright (C) 2000-2003 Stephen Davies
# Copyright (C) 2000, 2001 Stefan Seefeld
#
# Synopsis is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#
# $Log: FileTree.py,v $
# Revision 1.21  2003/01/16 17:01:14  chalky
# Fix class name
#
# Revision 1.20  2003/01/16 16:48:23  chalky
# Using FileTree now forces FileListing, FileIndexer and FileDetails to be used.
#
# Revision 1.19  2003/01/16 12:46:46  chalky
# Renamed FilePages to FileSource, FileTree to FileListing. Added FileIndexer
# (used to be part of FileTree) and FileDetails.
#
#


# HTML modules
import Page, FileListing, FileIndexer, FileDetails
from core import config

class FileTree (Page.Page):
    """A page which wraps the three pages now used for creating file-related
    info in the doco. For backwards compatibility only. The three new pages
    which should be used are FileListing, FileIndexer and FileDetails."""
    def __init__(self, manager):
	Page.Page.__init__(self, manager)
	config.pages.extend(['FileListing','FileIndexer','FileDetails'])
	self.pages = (
	    FileListing.htmlPageClass(manager),
	    FileIndexer.htmlPageClass(manager),
	    FileDetails.htmlPageClass(manager)
	)
    def register(self):
	for page in self.pages:
	    page.register()
    def register_filenames(self, start):
	for page in self.pages:
	    page.register_filenames(start)
    def process(self, start):
	for page in self.pages:
	    page.process(start)
	

htmlPageClass = FileTree
