/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Iterator;

public class PPFunctionProfile
implements Comparable {
    private ParaProfTrial trial = null;
    private Thread thread;
    private FunctionProfile functionProfile;
    private FunctionProfile meanProfile;
    private int sortType;
    private int xBeg = 0;
    private int xEnd = 0;
    private int yBeg = 0;
    private int yEnd = 0;

    public PPFunctionProfile(ParaProfTrial paraProfTrial, Thread thread, FunctionProfile functionProfile) {
        this.trial = paraProfTrial;
        this.thread = thread;
        this.functionProfile = functionProfile;
        this.meanProfile = this.functionProfile.getFunction().getMeanProfile();
    }

    public int getNodeID() {
        return this.thread.getNodeID();
    }

    public int getContextID() {
        return this.thread.getContextID();
    }

    public int getThreadID() {
        return this.thread.getThreadID();
    }

    public FunctionProfile getFunctionProfile() {
        return this.functionProfile;
    }

    public Function getFunction() {
        return this.functionProfile.getFunction();
    }

    public String getFunctionName() {
        return this.functionProfile.getFunction().getName();
    }

    public Color getColor() {
        return this.functionProfile.getFunction().getColor();
    }

    public boolean isGroupMember(Group group) {
        return this.functionProfile.getFunction().isGroupMember(group);
    }

    public boolean isCallPathObject() {
        return this.functionProfile.getFunction().isCallPathFunction();
    }

    public double getInclusiveValue() {
        return this.functionProfile.getInclusive(this.trial.getSelectedMetricID());
    }

    public double getExclusiveValue() {
        return this.functionProfile.getExclusive(this.trial.getSelectedMetricID());
    }

    public double getInclusivePercentValue() {
        return this.functionProfile.getInclusivePercent(this.trial.getSelectedMetricID());
    }

    public double getExclusivePercentValue() {
        return this.functionProfile.getExclusivePercent(this.trial.getSelectedMetricID());
    }

    public double getNumberOfCalls() {
        return this.functionProfile.getNumCalls();
    }

    public double getNumberOfSubRoutines() {
        return this.functionProfile.getNumSubr();
    }

    public double getInclusivePerCall() {
        return this.functionProfile.getInclusivePerCall(this.trial.getSelectedMetricID());
    }

    public Iterator getChildProfiles() {
        return this.functionProfile.getChildProfiles();
    }

    public Iterator getParentProfiles() {
        return this.functionProfile.getParentProfiles();
    }

    public int compareTo(Object object) {
        switch (this.sortType) {
            case 0: {
                return ((PPFunctionProfile)object).getFunctionName().compareTo(this.getFunctionName());
            }
            case 1: {
                return this.getFunctionName().compareTo(((PPFunctionProfile)object).getFunctionName());
            }
            case 2: {
                return this.compareToHelper(((PPFunctionProfile)object).getExclusiveValue(), this.getExclusiveValue());
            }
            case 3: {
                return this.compareToHelper(this.getExclusiveValue(), ((PPFunctionProfile)object).getExclusiveValue());
            }
            case 4: {
                return this.compareToHelper(((PPFunctionProfile)object).getInclusiveValue(), this.getInclusiveValue());
            }
            case 5: {
                return this.compareToHelper(this.getInclusiveValue(), ((PPFunctionProfile)object).getInclusiveValue());
            }
            case 6: {
                return this.compareToHelper(((PPFunctionProfile)object).getNumberOfCalls(), this.getNumberOfCalls());
            }
            case 7: {
                return this.compareToHelper(this.getNumberOfCalls(), ((PPFunctionProfile)object).getNumberOfCalls());
            }
            case 8: {
                return this.compareToHelper(((PPFunctionProfile)object).getNumberOfSubRoutines(), this.getNumberOfSubRoutines());
            }
            case 9: {
                return this.compareToHelper(this.getNumberOfSubRoutines(), ((PPFunctionProfile)object).getNumberOfSubRoutines());
            }
            case 10: {
                return this.compareToHelper(((PPFunctionProfile)object).getInclusivePerCall(), this.getInclusivePerCall());
            }
            case 11: {
                return this.compareToHelper(this.getInclusivePerCall(), ((PPFunctionProfile)object).getInclusivePerCall());
            }
            case 20: {
                return this.compareToHelper(((PPFunctionProfile)object).meanProfile.getExclusive(this.trial.getSelectedMetricID()), this.meanProfile.getExclusive(this.trial.getSelectedMetricID()), this, (PPFunctionProfile)object);
            }
            case 21: {
                return this.compareToHelper(this.meanProfile.getExclusive(this.trial.getSelectedMetricID()), ((PPFunctionProfile)object).meanProfile.getExclusive(this.trial.getSelectedMetricID()), this, (PPFunctionProfile)object);
            }
            case 22: {
                return this.compareToHelper(((PPFunctionProfile)object).meanProfile.getInclusive(this.trial.getSelectedMetricID()), this.meanProfile.getInclusive(this.trial.getSelectedMetricID()));
            }
            case 23: {
                return this.compareToHelper(this.meanProfile.getInclusive(this.trial.getSelectedMetricID()), ((PPFunctionProfile)object).meanProfile.getInclusive(this.trial.getSelectedMetricID()));
            }
            case 24: {
                return this.compareToHelper(((PPFunctionProfile)object).meanProfile.getNumCalls(), this.meanProfile.getNumCalls());
            }
            case 25: {
                return this.compareToHelper(this.meanProfile.getNumCalls(), ((PPFunctionProfile)object).meanProfile.getNumCalls());
            }
            case 26: {
                return this.compareToHelper(((PPFunctionProfile)object).meanProfile.getNumSubr(), this.meanProfile.getNumSubr());
            }
            case 27: {
                return this.compareToHelper(this.meanProfile.getNumSubr(), ((PPFunctionProfile)object).meanProfile.getNumSubr());
            }
            case 28: {
                return this.compareToHelper(((PPFunctionProfile)object).meanProfile.getInclusivePerCall(this.trial.getSelectedMetricID()), this.meanProfile.getInclusivePerCall(this.trial.getSelectedMetricID()));
            }
            case 29: {
                return this.compareToHelper(this.meanProfile.getInclusivePerCall(this.trial.getSelectedMetricID()), ((PPFunctionProfile)object).meanProfile.getInclusivePerCall(this.trial.getSelectedMetricID()));
            }
            case 30: {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)object;
                if (pPFunctionProfile.getNodeID() != this.getNodeID()) {
                    return pPFunctionProfile.getNodeID() - this.getNodeID();
                }
                if (pPFunctionProfile.getContextID() != this.getContextID()) {
                    return pPFunctionProfile.getContextID() - this.getContextID();
                }
                return pPFunctionProfile.getThreadID() - this.getThreadID();
            }
            case 31: {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)object;
                if (pPFunctionProfile.getNodeID() != this.getNodeID()) {
                    return this.getNodeID() - pPFunctionProfile.getNodeID();
                }
                if (pPFunctionProfile.getContextID() != this.getContextID()) {
                    return this.getContextID() - pPFunctionProfile.getContextID();
                }
                return this.getThreadID() - pPFunctionProfile.getThreadID();
            }
        }
        throw new RuntimeException("Unexpected sort type: " + this.sortType);
    }

    private int compareToHelper(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return 0;
        }
        return 1;
    }

    private int compareToHelper(double d, double d2, PPFunctionProfile pPFunctionProfile, PPFunctionProfile pPFunctionProfile2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return pPFunctionProfile.functionProfile.getFunction().compareTo((Object)pPFunctionProfile2.functionProfile.getFunction());
        }
        return 1;
    }

    public void setDrawCoords(int n, int n2, int n3, int n4) {
        this.xBeg = n;
        this.xEnd = n2;
        this.yBeg = n3;
        this.yEnd = n4;
    }

    public int getXBeg() {
        return this.xBeg;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public int getYBeg() {
        return this.yBeg;
    }

    public int getYEnd() {
        return this.yEnd;
    }

    public void setSortType(int n) {
        this.sortType = n;
    }

    public ParaProfTrial getTrial() {
        return this.trial;
    }

    public String getStatString(int n) {
        int n2 = this.trial.getSelectedMetricID();
        DecimalFormat decimalFormat = new DecimalFormat("##0.0");
        String string = UtilFncs.lpad((String)decimalFormat.format(this.functionProfile.getInclusivePercent(n2)), (int)13);
        string = string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getExclusive(n2), (int)14);
        string = string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getInclusive(n2), (int)16);
        string = string + "  " + UtilFncs.formatDouble((double)this.functionProfile.getNumCalls(), (int)12);
        string = string + "  " + UtilFncs.formatDouble((double)this.functionProfile.getNumSubr(), (int)12);
        string = string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getInclusivePerCall(n2), (int)19);
        return string;
    }

    public static String getStatStringHeading(String string) {
        return UtilFncs.lpad((String)("%Total " + string), (int)13) + UtilFncs.lpad((String)string, (int)16) + UtilFncs.lpad((String)("Total " + string), (int)18) + UtilFncs.lpad((String)"#Calls", (int)14) + UtilFncs.lpad((String)"#Subrs", (int)14) + UtilFncs.lpad((String)("Total " + string + "/Call"), (int)21) + "   ";
    }
}

