/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ThreadDataWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private int xPanelSize = 640;
    private int yPanelSize = 480;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 250;
    private int barLength = 0;
    private int textOffset = 60;
    private ParaProfTrial trial = null;
    private ThreadDataWindow window = null;
    private Thread thread = null;
    private Vector list = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;
    private int lastHeaderEndPosition = 0;

    public ThreadDataWindowPanel(ParaProfTrial paraProfTrial, int n, int n2, int n3, ThreadDataWindow threadDataWindow) {
        this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.trial = paraProfTrial;
        this.window = threadDataWindow;
        this.barLength = this.baseBarLength;
        this.thread = n == -1 ? paraProfTrial.getDataSource().getMeanData() : paraProfTrial.getDataSource().getThread(n, n2, n3);
        JMenuItem jMenuItem = new JMenuItem("Show Function Details");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
        jMenuItem2.addActionListener(this);
        this.popup.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
        jMenuItem3.addActionListener(this);
        this.popup.add(jMenuItem3);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.renderIt((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) throws ParaProfException {
        this.list = this.window.getData();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = this.barLength + this.textOffset;
        PPFunctionProfile pPFunctionProfile = null;
        if (this.list.size() == 0) {
            return;
        }
        this.trial.getPreferences().setBarDetails(graphics2D);
        this.barSpacing = this.trial.getPreferences().getBarSpacing();
        this.barHeight = this.trial.getPreferences().getBarHeight();
        Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        d2 = this.window.getPPThread().getMaxValue(this.window.getValueType(), this.window.isPercent());
        if (this.window.isPercent()) {
            n = fontMetrics.stringWidth(UtilFncs.getOutputString((int)0, (double)d2, (int)6) + "%");
            n3 += n;
        } else {
            n = fontMetrics.stringWidth(UtilFncs.getOutputString((int)this.window.units(), (double)d2, (int)ParaProf.defaultNumberPrecision));
            n3 += n;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        if (!bl2) {
            if (bl) {
                rectangle = graphics2D.getClipBounds();
                n4 = (int)rectangle.getY();
                n5 = (int)((double)n4 + rectangle.getHeight());
            } else {
                rectangle2 = this.window.getViewRect();
                n4 = (int)rectangle2.getY();
                n5 = (int)((double)n4 + rectangle2.getHeight());
            }
            n6 = (n4 - n2) / this.barSpacing - 1;
            n7 = (n5 - n2) / this.barSpacing + 1;
            if (n6 < 0) {
                n6 = 0;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            if (n6 > this.list.size() - 1) {
                n6 = this.list.size() - 1;
            }
            if (n7 > this.list.size() - 1) {
                n7 = this.list.size() - 1;
            }
            if (bl) {
                n2 += n6 * this.barSpacing;
            }
        } else {
            n6 = 0;
            n7 = this.list.size() - 1;
        }
        if (this.resizePanel(fontMetrics, n3, this.list, n6, n7) && bl) {
            this.revalidate();
            return;
        }
        if (bl3) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Insets insets = this.getInsets();
            n2 += this.barSpacing;
            String string = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                attributedString.addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - insets.left - insets.right;
                float f2 = insets.left;
                float f3 = insets.right;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                    textLayout.draw(graphics2D, f2, n2 += this.barSpacing);
                    f2 = insets.left;
                }
            }
            this.lastHeaderEndPosition = n2;
        }
        int n8 = n6;
        while (n8 <= n7) {
            pPFunctionProfile = (PPFunctionProfile)this.list.elementAt(n8);
            d = ParaProfUtils.getValue(pPFunctionProfile, this.window.getValueType(), this.window.isPercent());
            this.drawBar(graphics2D, fontMetrics, d, d2, n3, n2 += this.barSpacing, this.barHeight, pPFunctionProfile, bl);
            ++n8;
        }
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, double d, double d2, int n, int n2, int n3, PPFunctionProfile pPFunctionProfile, boolean bl) {
        int n4 = 0;
        double d3 = 0.0;
        String string = null;
        int n5 = 0;
        int n6 = 0;
        Function function = pPFunctionProfile.getFunction();
        String string2 = pPFunctionProfile.getFunctionName();
        boolean bl2 = pPFunctionProfile.isGroupMember(this.trial.getColorChooser().getHighlightedGroup());
        d3 = d / d2;
        n4 = (int)(d3 * (double)this.barLength);
        if (n4 == 0) {
            n4 = 1;
        }
        if (n4 > 2 && n3 > 2) {
            graphics2D.setColor(pPFunctionProfile.getColor());
            graphics2D.fillRect(n - n4 + 1, n2 - n3 + 1, n4 - 1, n3 - 1);
            if (function == this.trial.getColorChooser().getHighlightedFunction()) {
                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
                graphics2D.drawRect(n - n4 + 1, n2 - n3 + 1, n4 - 2, n3 - 2);
            } else if (bl2) {
                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
                graphics2D.drawRect(n - n4 + 1, n2 - n3 + 1, n4 - 2, n3 - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
            }
        } else {
            if (function == this.trial.getColorChooser().getHighlightedFunction()) {
                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
            } else if (bl2) {
                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
            } else {
                graphics2D.setColor(pPFunctionProfile.getColor());
            }
            graphics2D.fillRect(n - n4, n2 - n3, n4, n3);
        }
        graphics2D.setColor(Color.black);
        string = this.window.isPercent() && this.window.getValueType() <= 4 ? UtilFncs.getOutputString((int)0, (double)d, (int)6) + "%" : UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision);
        n5 = fontMetrics.stringWidth(string);
        n6 = n - n4 - n5 - 5;
        graphics2D.drawString(string, n6, n2);
        graphics2D.drawString(string2, n + 5, n2);
        n5 = fontMetrics.stringWidth(string2);
        if (bl) {
            pPFunctionProfile.setDrawCoords(n6, n + 5 + n5, n2 - n3, n2);
        }
    }

    public void changeInMultiples() {
        this.computeBarLength();
        this.repaint();
    }

    public void computeBarLength() {
        double d = this.window.getSliderValue();
        double d2 = this.window.getSliderMultiple();
        this.barLength = this.baseBarLength * (int)(d * d2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof Function) {
                        Function function = (Function)this.clickedOnObject;
                        this.trial.getColorChooser().setHighlightedFunction(function);
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(this.trial, function, this.window.getDataSorter());
                        this.trial.getSystemEvents().addObserver(functionDataWindow);
                        functionDataWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    if (this.clickedOnObject instanceof Function) {
                        Function function = (Function)this.clickedOnObject;
                        Color color = function.getColor();
                        if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                            function.setSpecificColor(color);
                            function.setColorFlag(true);
                            this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                        }
                    }
                } else if (string.equals("Reset to Generic Color") && this.clickedOnObject instanceof Function) {
                    Function function = (Function)this.clickedOnObject;
                    function.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            PPFunctionProfile pPFunctionProfile = null;
            int n4 = n2 / this.trial.getPreferences().getBarSpacing();
            if (this.list != null && n4 < this.list.size()) {
                pPFunctionProfile = (PPFunctionProfile)this.list.elementAt(n4);
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    this.clickedOnObject = pPFunctionProfile.getFunction();
                    this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                this.trial.getColorChooser().toggleHighlightedFunction(pPFunctionProfile.getFunction());
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n, Vector vector, int n2, int n3) {
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        PPFunctionProfile pPFunctionProfile = null;
        int n7 = n2;
        while (n7 <= n3) {
            pPFunctionProfile = (PPFunctionProfile)vector.elementAt(n7);
            n6 = n + 5 + fontMetrics.stringWidth(pPFunctionProfile.getFunctionName()) + 500;
            if (n6 > n4) {
                n4 = n6;
            }
            ++n7;
        }
        n5 = this.barSpacing + (vector.size() + 1) * this.barSpacing;
        if (n5 != this.yPanelSize || n4 != this.xPanelSize) {
            this.yPanelSize = n5;
            this.xPanelSize = n4;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }
}

