/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.util.Bezier;
import org.jgraph.util.Spline2D;

public class EdgeRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    private static final int MAINLABEL_INDEX = -1;
    public boolean simpleExtraLabels = true;
    public Font extraLabelFont = null;
    protected transient Graphics fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
    protected transient FontMetrics metrics;
    protected transient JGraph graph;
    protected transient EdgeView view;
    protected transient int beginDeco;
    protected transient int endDeco;
    protected transient int beginSize;
    protected transient int endSize;
    protected transient int lineStyle;
    protected transient float lineWidth;
    protected transient boolean labelBorder;
    protected transient boolean beginFill;
    protected transient boolean endFill;
    protected transient boolean focus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient boolean childrenSelected;
    protected transient boolean labelTransformEnabled;
    protected transient Color borderColor;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color fontColor;
    protected transient float[] lineDash;
    protected transient float dashOffset = 0.0f;
    transient Color gradientColor = null;
    protected Bezier bezier;
    protected Spline2D spline;

    void setView(CellView cellView) {
        if (cellView instanceof EdgeView) {
            this.view = (EdgeView)cellView;
            this.installAttributes(this.view);
        } else {
            this.view = null;
        }
    }

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof EdgeView && jGraph != null) {
            this.graph = jGraph;
            this.focus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.childrenSelected = jGraph.getSelectionModel().isChildrenSelected(cellView.getCell());
            this.setView(cellView);
            return this;
        }
        return null;
    }

    public boolean intersects(JGraph jGraph, CellView cellView, Rectangle rectangle) {
        if (cellView instanceof EdgeView && jGraph != null && cellView != null) {
            this.setView(cellView);
            Graphics2D graphics2D = (Graphics2D)jGraph.getGraphics();
            boolean bl = graphics2D.hit(rectangle, this.view.getShape(), true);
            if (bl) {
                return true;
            }
            Rectangle2D rectangle2D = this.getLabelBounds(jGraph, this.view);
            if (rectangle2D != null && rectangle2D.intersects(rectangle)) {
                return true;
            }
            Object[] objectArray = GraphConstants.getExtraLabels(this.view.getAllAttributes());
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    rectangle2D = this.getExtraLabelBounds(this.view, n);
                    if (rectangle2D != null && rectangle2D.intersects(rectangle)) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        return false;
    }

    public Rectangle2D getBounds(CellView cellView) {
        if (cellView instanceof EdgeView && cellView != null) {
            int n;
            Object[] objectArray;
            this.setView(cellView);
            Rectangle2D rectangle2D = this.getPaintBounds(this.view);
            Rectangle2D rectangle2D2 = this.getLabelBounds(this.graph, this.view);
            if (rectangle2D2 != null) {
                Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
            }
            if ((objectArray = GraphConstants.getExtraLabels(this.view.getAllAttributes())) != null) {
                n = 0;
                while (n < objectArray.length) {
                    rectangle2D2 = this.getExtraLabelBounds(this.view, n);
                    if (rectangle2D2 != null) {
                        Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
                    }
                    ++n;
                }
            }
            n = (int)Math.ceil(this.lineWidth);
            rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(2 * n), rectangle2D.getHeight() + (double)(2 * n));
            return rectangle2D;
        }
        return null;
    }

    private boolean isLabelTransformEnabled() {
        return this.labelTransformEnabled;
    }

    private boolean isLabelTransform(String string) {
        if (!this.isLabelTransformEnabled()) {
            return false;
        }
        Point2D point2D = this.getLabelPosition(this.view);
        if (point2D != null && string != null && string.length() > 0) {
            int n = this.metrics.stringWidth(string);
            if (this.view.getPointCount() == 2) {
                Point2D point2D2 = this.view.getPoint(0);
                Point2D point2D3 = this.view.getPoint(1);
                double d = Math.sqrt((point2D3.getX() - point2D2.getX()) * (point2D3.getX() - point2D2.getX()) + (point2D3.getY() - point2D2.getY()) * (point2D3.getY() - point2D2.getY()));
                if (!(d <= Double.NaN) && !(d < (double)n)) {
                    return true;
                }
            }
        }
        return false;
    }

    private double getLabelAngle(String string) {
        Point2D point2D = this.getLabelPosition(this.view);
        double d = 0.0;
        if (point2D != null && string != null && string.length() > 0) {
            int n = this.metrics.stringWidth(string);
            if (this.view.getPointCount() == 2) {
                Point2D point2D2 = this.view.getPoint(0);
                Point2D point2D3 = this.view.getPoint(1);
                double d2 = Math.sqrt((point2D3.getX() - point2D2.getX()) * (point2D3.getX() - point2D2.getX()) + (point2D3.getY() - point2D2.getY()) * (point2D3.getY() - point2D2.getY()));
                if (!(d2 <= Double.NaN) && !(d2 < (double)n)) {
                    double d3 = (point2D3.getX() - point2D2.getX()) / d2;
                    double d4 = (point2D3.getY() - point2D2.getY()) / d2;
                    d = Math.acos(d3);
                    if (d4 < 0.0) {
                        d = Math.PI * 2 - d;
                    }
                }
            }
            if (d > 1.5707963267948966 && d <= 4.71238898038469) {
                d -= Math.PI;
            }
        }
        return d;
    }

    public Rectangle2D getLabelBounds(JGraph jGraph, EdgeView edgeView) {
        this.setView(edgeView);
        Point2D point2D = this.getLabelPosition(this.view);
        String string = this.graph != null ? jGraph.convertValueToString(edgeView) : edgeView.getCell().toString();
        String string2 = string != null ? string.toString() : null;
        Dimension dimension = this.getLabelSize(string2, edgeView);
        return this.getLabelBounds(point2D, dimension, string2);
    }

    public Rectangle2D getExtraLabelBounds(EdgeView edgeView, int n) {
        this.setView(edgeView);
        Object[] objectArray = GraphConstants.getExtraLabels(edgeView.getAllAttributes());
        Point2D point2D = this.getExtraLabelPosition(this.view, n);
        Dimension dimension = this.getExtraLabelSize(this.view, n);
        String string = n < objectArray.length ? this.graph.convertValueToString(objectArray[n]) : null;
        return this.getLabelBounds(point2D, dimension, string);
    }

    public Rectangle2D getLabelBounds(Point2D point2D, Dimension dimension, String string) {
        if (string != null && this.isLabelTransform(string)) {
            double d = this.getLabelAngle(string);
            if (d < 0.0) {
                d = -d;
            }
            if (d > 1.5707963267948966) {
                d %= 1.5707963267948966;
            }
            double d2 = Math.abs(Math.cos(d) * (double)dimension.height + Math.sin(d) * (double)dimension.width);
            double d3 = Math.abs((double)dimension.width * Math.cos(d) + (double)dimension.height * Math.sin(d));
            if (d3 > d2) {
                d2 = d3;
            }
            if (d2 > d3) {
                d3 = d2;
            }
            d = this.getLabelAngle(string);
            dimension.width = (int)d3 + dimension.height;
            dimension.height = (int)d2 + dimension.height;
        }
        if (point2D != null && dimension != null) {
            return new Rectangle2D.Double(point2D.getX() - (double)(dimension.width / 2), point2D.getY() - (double)(dimension.height / 2), dimension.width + 1, dimension.height + 1);
        }
        return null;
    }

    public Point2D getLabelPosition(EdgeView edgeView) {
        this.setView(edgeView);
        return this.getLabelPosition(edgeView.getLabelPosition());
    }

    public Point2D getExtraLabelPosition(EdgeView edgeView, int n) {
        this.setView(edgeView);
        Point[] pointArray = GraphConstants.getExtraLabelPositions(edgeView.getAllAttributes());
        if (pointArray != null && n < pointArray.length) {
            return this.getLabelPosition(pointArray[n]);
        }
        return null;
    }

    protected Point2D getLabelPosition(Point2D point2D) {
        Rectangle2D rectangle2D = this.getPaintBounds(this.view);
        int n = 1000;
        Point2D point2D2 = this.view.getPoint(0);
        Point2D point2D3 = this.view.getPoint(this.view.getPointCount() - 1);
        if (point2D != null && rectangle2D != null) {
            double d = rectangle2D.getX();
            int n2 = 1;
            if (point2D2.getX() > point2D3.getX()) {
                d += rectangle2D.getWidth();
                n2 = -1;
            }
            double d2 = rectangle2D.getY();
            int n3 = 1;
            if (point2D2.getY() > point2D3.getY()) {
                d2 += rectangle2D.getHeight();
                n3 = -1;
            }
            double d3 = d + (double)n2 * (rectangle2D.getWidth() * point2D.getX() / (double)n);
            double d4 = d2 + (double)n3 * (rectangle2D.getHeight() * point2D.getY() / (double)n);
            return new Point2D.Double(d3, d4);
        }
        return null;
    }

    public Dimension getLabelSize(String string, EdgeView edgeView) {
        this.setView(edgeView);
        return this.getLabelSize(string);
    }

    public Dimension getExtraLabelSize(EdgeView edgeView, int n) {
        this.setView(edgeView);
        Object[] objectArray = GraphConstants.getExtraLabels(edgeView.getAllAttributes());
        String string = n < objectArray.length ? this.graph.convertValueToString(objectArray[n]) : null;
        return this.getLabelSize(string);
    }

    public Dimension getLabelSize(String string) {
        this.setView(this.view);
        if (string != null && string.toString().length() > 0) {
            this.fontGraphics.setFont(GraphConstants.getFont(this.view.getAllAttributes()));
            this.metrics = this.fontGraphics.getFontMetrics();
            int n = this.metrics.stringWidth(string.toString());
            int n2 = this.metrics.getHeight();
            return new Dimension(n, n2);
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        AttributeMap attributeMap = cellView.getAllAttributes();
        this.beginDeco = GraphConstants.getLineBegin(attributeMap);
        this.beginSize = GraphConstants.getBeginSize(attributeMap);
        this.beginFill = GraphConstants.isBeginFill(attributeMap) && this.isFillable(this.beginDeco);
        this.endDeco = GraphConstants.getLineEnd(attributeMap);
        this.endSize = GraphConstants.getEndSize(attributeMap);
        this.endFill = GraphConstants.isEndFill(attributeMap) && this.isFillable(this.endDeco);
        this.lineWidth = GraphConstants.getLineWidth(attributeMap);
        this.lineStyle = GraphConstants.getLineStyle(attributeMap);
        this.lineDash = GraphConstants.getDashPattern(attributeMap);
        this.dashOffset = GraphConstants.getDashOffset(attributeMap);
        this.borderColor = GraphConstants.getBorderColor(attributeMap);
        Color color = GraphConstants.getLineColor(attributeMap);
        this.setForeground(color != null ? color : this.defaultForeground);
        Color color2 = GraphConstants.getBackground(attributeMap);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        Color color3 = GraphConstants.getGradientColor(attributeMap);
        this.setGradientColor(color3);
        this.setOpaque(GraphConstants.isOpaque(attributeMap));
        this.setFont(GraphConstants.getFont(attributeMap));
        Color color4 = GraphConstants.getForeground(attributeMap);
        this.fontColor = color4 != null ? color4 : this.getForeground();
        this.fontGraphics.setFont(this.getFont());
        this.metrics = this.fontGraphics.getFontMetrics();
        this.labelTransformEnabled = GraphConstants.isLabelAlongEdge(attributeMap);
    }

    protected boolean isFillable(int n) {
        return n != 4 && n != 7 && n != 8;
    }

    public Rectangle2D getPaintBounds(EdgeView edgeView) {
        this.setView(edgeView);
        return edgeView.getShape().getBounds();
    }

    public void paint(Graphics graphics) {
        if (this.view.isLeaf()) {
            Shape shape = this.view.getShape();
            if (shape != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n = 0;
                int n2 = 0;
                graphics2D.setStroke(new BasicStroke(this.lineWidth, n, n2));
                this.setOpaque(false);
                super.paint(graphics);
                this.translateGraphics(graphics);
                graphics.setColor(this.getForeground());
                if (this.gradientColor != null && !this.preview) {
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                }
                if (this.view.beginShape != null) {
                    if (this.beginFill) {
                        graphics2D.fill(this.view.beginShape);
                    }
                    graphics2D.draw(this.view.beginShape);
                }
                if (this.view.endShape != null) {
                    if (this.endFill) {
                        graphics2D.fill(this.view.endShape);
                    }
                    graphics2D.draw(this.view.endShape);
                }
                if (this.lineDash != null) {
                    graphics2D.setStroke(new BasicStroke(this.lineWidth, n, n2, 10.0f, this.lineDash, this.dashOffset));
                }
                if (this.view.lineShape != null) {
                    graphics2D.draw(this.view.lineShape);
                }
                if (this.selected) {
                    graphics2D.setStroke(GraphConstants.SELECTION_STROKE);
                    graphics2D.setColor(this.graph.getHighlightColor());
                    if (this.view.beginShape != null) {
                        graphics2D.draw(this.view.beginShape);
                    }
                    if (this.view.lineShape != null) {
                        graphics2D.draw(this.view.lineShape);
                    }
                    if (this.view.endShape != null) {
                        graphics2D.draw(this.view.endShape);
                    }
                }
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics.setFont(this.extraLabelFont != null ? this.extraLabelFont : this.getFont());
                Object[] objectArray = GraphConstants.getExtraLabels(this.view.getAllAttributes());
                if (objectArray != null) {
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        this.paintLabel(graphics, this.graph.convertValueToString(objectArray[n3]), this.getExtraLabelPosition(this.view, n3), !this.simpleExtraLabels);
                        ++n3;
                    }
                }
                if (this.graph.getEditingCell() != this.view.getCell()) {
                    graphics.setFont(this.getFont());
                    String string = this.graph.convertValueToString(this.view);
                    if (string != null) {
                        this.paintLabel(graphics, string.toString(), this.getLabelPosition(this.view), true);
                    }
                }
            }
        } else {
            this.paintSelectionBorder(graphics);
        }
    }

    protected void paintSelectionBorder(Graphics graphics) {
        ((Graphics2D)graphics).setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected) {
            graphics.setColor(this.graph.getGridColor());
        } else if (this.focus && this.selected) {
            graphics.setColor(this.graph.getLockedHandleColor());
        } else if (this.selected) {
            graphics.setColor(this.graph.getHighlightColor());
        }
        if (this.childrenSelected || this.selected) {
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    protected void translateGraphics(Graphics graphics) {
        graphics.translate(-this.getX(), -this.getY());
    }

    protected void paintLabel(Graphics graphics, String string, Point2D point2D, boolean bl) {
        if (point2D != null && string != null && string.length() > 0) {
            int n = this.metrics.stringWidth(string);
            int n2 = this.metrics.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl2 = this.isLabelTransform(string);
            double d = 0.0;
            graphics2D.translate(point2D.getX(), point2D.getY());
            if (bl2) {
                d = this.getLabelAngle(string);
                graphics2D.rotate(d);
            }
            if (this.isOpaque() && bl) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(-n / 2 - 1, -n2 / 2 - 1, n + 2, n2 + 2);
            }
            if (this.borderColor != null && bl) {
                graphics.setColor(this.borderColor);
                graphics.drawRect(-n / 2 - 1, -n2 / 2 - 1, n + 2, n2 + 2);
            }
            graphics.setColor(this.fontColor);
            int n3 = -n / 2;
            int n4 = n2 / 4;
            if (bl2 && this.borderColor == null && !this.isOpaque()) {
                n4 = -this.metrics.getDescent();
            }
            graphics.drawString(string, n3, n4);
            if (bl2) {
                graphics2D.rotate(-d);
            }
            graphics2D.translate(-point2D.getX(), -point2D.getY());
        }
    }

    protected Shape createShape() {
        int n = this.view.getPointCount();
        if (n > 1) {
            Object[] objectArray;
            EdgeView edgeView = this.view;
            Point2D[] point2DArray = new Point2D[n];
            int n2 = 0;
            while (n2 < n) {
                point2DArray[n2] = edgeView.getAttributes().createPoint(edgeView.getPoint(n2));
                ++n2;
            }
            if (this.view != edgeView) {
                this.view = edgeView;
                this.installAttributes(this.view);
            }
            if (this.view.sharedPath == null) {
                this.view.sharedPath = new GeneralPath(1);
            } else {
                this.view.sharedPath.reset();
            }
            this.view.endShape = null;
            this.view.lineShape = null;
            this.view.beginShape = null;
            Point2D point2D = point2DArray[0];
            Point2D point2D2 = point2DArray[n - 1];
            Point2D point2D3 = point2DArray[1];
            Point2D point2D4 = point2DArray[n - 2];
            if (this.lineStyle == 12 && n > 2) {
                this.bezier = new Bezier(point2DArray);
                point2D4 = this.bezier.getPoint(this.bezier.getPointCount() - 1);
            } else if (this.lineStyle == 13 && n > 2) {
                this.spline = new Spline2D(point2DArray);
                objectArray = this.spline.getPoint(0.99);
                point2D4.setLocation(objectArray[0], objectArray[1]);
            }
            if (this.beginDeco != 0) {
                this.view.beginShape = this.createLineEnd(this.beginSize, this.beginDeco, point2D3, point2D);
            }
            if (this.endDeco != 0) {
                this.view.endShape = this.createLineEnd(this.endSize, this.endDeco, point2D4, point2D2);
            }
            this.view.sharedPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            if (this.lineStyle == 12 && n > 2) {
                objectArray = this.bezier.getPoints();
                this.view.sharedPath.quadTo((float)objectArray[0].getX(), (float)objectArray[0].getY(), (float)point2D3.getX(), (float)point2D3.getY());
                int n3 = 2;
                while (n3 < n - 1) {
                    double d = objectArray[2 * n3 - 3];
                    double d2 = objectArray[2 * n3 - 2];
                    this.view.sharedPath.curveTo((float)d.getX(), (float)d.getY(), (float)d2.getX(), (float)d2.getY(), (float)point2DArray[n3].getX(), (float)point2DArray[n3].getY());
                    ++n3;
                }
                this.view.sharedPath.quadTo((float)objectArray[objectArray.length - 1].getX(), (float)objectArray[objectArray.length - 1].getY(), (float)point2DArray[n - 1].getX(), (float)point2DArray[n - 1].getY());
            } else if (this.lineStyle == 13 && n > 2) {
                double d = 0.0;
                while (d <= 1.0) {
                    double[] dArray = this.spline.getPoint(d);
                    this.view.sharedPath.lineTo((float)dArray[0], (float)dArray[1]);
                    d += 0.01;
                }
            } else {
                int n4 = 1;
                while (n4 < n - 1) {
                    this.view.sharedPath.lineTo((float)point2DArray[n4].getX(), (float)point2DArray[n4].getY());
                    ++n4;
                }
                this.view.sharedPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            }
            this.view.sharedPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
            this.view.lineShape = (GeneralPath)this.view.sharedPath.clone();
            if (this.view.endShape != null) {
                this.view.sharedPath.append(this.view.endShape, true);
            }
            if (this.view.beginShape != null) {
                this.view.sharedPath.append(this.view.beginShape, true);
            }
            return this.view.sharedPath;
        }
        return null;
    }

    protected Shape createLineEnd(int n, int n2, Point2D point2D, Point2D point2D2) {
        if (point2D == null || point2D2 == null) {
            return null;
        }
        int n3 = (int)Math.max(1.0, point2D2.distance(point2D));
        int n4 = (int)(-((double)n * (point2D2.getX() - point2D.getX()) / (double)n3));
        int n5 = (int)(-((double)n * (point2D2.getY() - point2D.getY()) / (double)n3));
        if (n2 == 9) {
            Polygon polygon = new Polygon();
            polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            polygon.addPoint((int)(point2D2.getX() + (double)(n4 / 2) + (double)(n5 / 3)), (int)(point2D2.getY() + (double)(n5 / 2) - (double)(n4 / 3)));
            Point2D point2D3 = (Point2D)point2D2.clone();
            point2D2.setLocation(point2D2.getX() + (double)n4, point2D2.getY() + (double)n5);
            polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            polygon.addPoint((int)(point2D3.getX() + (double)(n4 / 2) - (double)(n5 / 3)), (int)(point2D3.getY() + (double)(n5 / 2) + (double)(n4 / 3)));
            return polygon;
        }
        if (n2 == 2 || n2 == 1) {
            Polygon polygon = new Polygon();
            polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            polygon.addPoint((int)(point2D2.getX() + (double)n4 + (double)(n5 / 2)), (int)(point2D2.getY() + (double)n5 - (double)(n4 / 2)));
            Point2D point2D4 = (Point2D)point2D2.clone();
            if (n2 == 1) {
                point2D2.setLocation((int)(point2D2.getX() + (double)(n4 * 2 / 3)), (int)(point2D2.getY() + (double)(n5 * 2 / 3)));
                polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            } else if (n2 == 9) {
                point2D2.setLocation(point2D2.getX() + (double)(2 * n4), point2D2.getY() + (double)(2 * n5));
                polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            } else {
                point2D2.setLocation((int)(point2D2.getX() + (double)n4), (int)(point2D2.getY() + (double)n5));
            }
            polygon.addPoint((int)(point2D4.getX() + (double)n4 - (double)(n5 / 2)), (int)(point2D4.getY() + (double)n5 + (double)(n4 / 2)));
            return polygon;
        }
        if (n2 == 4) {
            GeneralPath generalPath = new GeneralPath(1, 4);
            generalPath.moveTo((float)(point2D2.getX() + (double)n4 + (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 - (double)(n4 / 2)));
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)(point2D2.getX() + (double)n4 - (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 + (double)(n4 / 2)));
            return generalPath;
        }
        if (n2 == 5) {
            Ellipse2D.Float float_ = new Ellipse2D.Float((float)(point2D2.getX() + (double)(n4 / 2) - (double)(n / 2)), (float)(point2D2.getY() + (double)(n5 / 2) - (double)(n / 2)), n, n);
            point2D2.setLocation(point2D2.getX() + (double)n4, point2D2.getY() + (double)n5);
            return float_;
        }
        if (n2 == 7 || n2 == 8) {
            GeneralPath generalPath = new GeneralPath(1, 4);
            generalPath.moveTo((float)(point2D2.getX() + (double)(n4 / 2) + (double)(n5 / 2)), (float)(point2D2.getY() + (double)(n5 / 2) - (double)(n4 / 2)));
            generalPath.lineTo((float)(point2D2.getX() + (double)(n4 / 2) - (double)(n5 / 2)), (float)(point2D2.getY() + (double)(n5 / 2) + (double)(n4 / 2)));
            if (n2 == 8) {
                generalPath.moveTo((float)(point2D2.getX() + (double)(n4 / 3) + (double)(n5 / 2)), (float)(point2D2.getY() + (double)(n5 / 3) - (double)(n4 / 2)));
                generalPath.lineTo((float)(point2D2.getX() + (double)(n4 / 3) - (double)(n5 / 2)), (float)(point2D2.getY() + (double)(n5 / 3) + (double)(n4 / 2)));
            }
            return generalPath;
        }
        return null;
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color color) {
        this.gradientColor = color;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

