dnl $Id: ri-config-script.m4,v 1.4 2004/06/13 18:31:07 rillig Exp $
dnl
dnl ri_SEARCH_PROGRAM(variable,
dnl                   program-name,
dnl                  [path])
dnl
dnl looks for the executable $2 in the PATH and returns the full
dnl name of the executable in the shell variable $1. If no executable
dnl of the appropriate name is found, the shell variable $1 is set
dnl to the empty string.
AC_DEFUN([ri_SEARCH_PROGRAM],
[
  ri_old_IFS="$IFS"
  IFS=":"
  $1=""
  for ri_dir in ifelse([$3], [], $PATH, [$3]); do
    if test -x "$ri_dir/$2"; then
      $1="$ri_dir/$2"
      break;
    fi
  done
  IFS="$ri_old_IFS"

])

dnl ri_CONFIG_SCRIPT(package-name,
dnl                 [minimal-version],
dnl                  cflags-variable,
dnl                  ldflags-variable,
dnl                 [action-if-not-found],
dnl                 [action-if-too-old])
dnl
dnl Defines two Makefile variables that contain the CFLAGS and the
dnl LIBS for the package called ${package-name}.
dnl
dnl This macro looks for a script called ${package-name}-config. It then
dnl checks the version of the package (optional). If the version is high
dnl enough, it sets the two Makefile variables ${cflags-variable} and
dnl ${ldflags-variable} to the command line options returned by the script.

AC_DEFUN([ri_CONFIG_SCRIPT], [
define([ri_pkgname], patsubst([$1], [[^A-Za-z0-9]], _))[]dnl
define([ri_PKGNAME], translit(ri_pkgname, [a-z], [A-Z]))[]dnl

AC_ARG_WITH([$1],
  AS_HELP_STRING(
    [--with-$1[=<dir>]],
    [Prefix where $1 is installed]))

if test "x$with_[]ri_pkgname[]" != "xno"; then
  AC_DEFINE(WITH_[]ri_PKGNAME[], 1, [Define to 1 if you want to build with $1.])
  case "x$with_[]ri_pkgname[]" in
    xyes | x)
      ri_script_path="$PATH"
      ;;
    x/* | x?:/*)
      ri_script_path="$with_[]ri_pkgname[]/bin"
      ;;
    *)
      AC_MSG_ERROR([The $1 directory must be absolute])
      ;;
  esac
  AC_MSG_CHECKING(for [$1]-config)
  ri_SEARCH_PROGRAM(ri_script_bin, $1-config, $ri_script_path)
  
  if test "x$ri_script_bin" = "x"; then
    AC_MSG_RESULT(not found)
    ifelse([$5], ,
      AC_MSG_ERROR([$1-config could not be found in $ri_script_path]),
      [$5])
  else
    AC_MSG_RESULT($ri_script_bin)
    ri_version_ok="yes"
    ifelse([$2], , , [
    AC_MSG_CHECKING(for [$1] >= [$2])
    ri_pkg_version="`$ri_script_bin --version`"
    if test "`echo "$ri_pkg_version" | \
        sed 's/^\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*$/ok/'`" != "ok"; then
      AC_MSG_ERROR(output of '$ri_script_bin --version' ($ri_pkg_version) unparseable)
    fi
    ri_pkg_major_version=`echo $ri_pkg_version.0.0 | \
        sed 's/^\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*$/\1/'`
    ri_pkg_minor_version=`echo $ri_pkg_version.0.0 | \
        sed 's/^\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*$/\2/'`
    ri_pkg_patch_version=`echo $ri_pkg_version.0.0 | \
        sed 's/^\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*$/\3/'`
	
    ri_need_version="$2"
    ri_need_major_version=`echo $ri_need_version.0.0 | \
        sed 's/^\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*$/\1/'`
    ri_need_minor_version=`echo $ri_need_version.0.0 | \
        sed 's/^\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*$/\2/'`
    ri_need_patch_version=`echo $ri_need_version.0.0 | \
        sed 's/^\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*$/\3/'`

    ri_version_ok="no"
    test "$ri_pkg_major_version" -gt "$ri_need_major_version" && \
      ri_version_ok="yes"
    test "$ri_pkg_major_version" -eq "$ri_need_major_version" && \
      test "$ri_pkg_minor_version" -gt "$ri_need_minor_version" && \
        ri_version_ok="yes"
    test "$ri_pkg_major_version" -eq "$ri_need_major_version" && \
      test "$ri_pkg_minor_version" -eq "$ri_need_minor_version" && \
        test "$ri_pkg_patch_version" -ge "$ri_need_patch_version" && \
          ri_version_ok="yes"
    if test "x$ri_version_ok" = "xyes"; then
      AC_MSG_RESULT(yes)
    else
      AC_MSG_RESULT(no)
    fi
    ])[]dnl ifelse([$2], , ...

    if test "x$ri_version_ok" = "xyes"; then
      AC_MSG_CHECKING(for additional compiler flags for [$1])
      ri_flags_failed=no
      if `$ri_script_bin --cflags >/dev/null 2>&1`; then
        $3="`$ri_script_bin --cflags`"
      elif `$ri_script_bin compile >/dev/null 2>&1`; then
        $3="`$ri_script_bin compile`"
      else
        ri_flags_failed=yes
      fi
      if `$ri_script_bin --libs >/dev/null 2>&1`; then
        $4="`$ri_script_bin --libs`"
      elif `$ri_script_bin link >/dev/null 2>&1`; then
        $4="`$ri_script_bin link`"
      else
        ri_flags_failed=yes
      fi
      if test "x$ri_flags_failed" = "xno"; then
        AC_MSG_RESULT(ok)
      else
        AC_MSG_RESULT(failed)
	AC_MSG_ERROR([Error while getting the compiler flags for $1])
      fi
    else
      ifelse([$6], ,
        AC_MSG_ERROR([$1 is too old (version $ri_need_version required, $ri_pkg_version found)]),
	[$6])
      $6
    fi
  fi
  AC_SUBST($3)[]dnl
  AC_SUBST($4)[]dnl
fi

])
