/*  XGDVI
 *  Copyright (C) 1999  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#include <dvi-2_6.h>
#include <gtk/gtk.h>

#include "defs.h"
#include "xgdvi.h"
#include "gui.h"
#include "buff.h"


#define WIDTH    450
#define HEIGHT   350

#define MIN_WIDTH_FILE   150
#define MAX_WIDTH_FILE   400
#define MIN_WIDTH_PAGE    30
#define MAX_WIDTH_PAGE    80
#define MIN_WIDTH_PATH   800
#define MAX_WIDTH_PATH  1000


static int        BufferSelectionShown = 0;
static GtkWidget *BufferSelection      = NULL;
static GtkWidget *BufferList           = NULL;



static void
on_destry                              (GtkObject       *obj,
                                        gpointer         user_data);

void
on_buffFile_clicked                     (GtkWidget *widget,
					 gint row, 
					 gint column, 
					 GdkEventButton *ev,
					 gpointer user_data);
void
on_buffButtonSelect_clicked            (GtkButton       *button,
                                        gpointer         user_data);
void
on_buffButtonClose_clicked             (GtkButton       *button,
                                        gpointer         user_data);
void
on_buffButtonCancel_clicked            (GtkButton       *button,
                                        gpointer         user_data);


static void  gbuff_insert_ith(char *f, int p, int i);




GtkWidget*
create_BufferSelection ()
{
  static char *titles[3];
  GtkWidget *vbox;
  GtkWidget *separator;
  GtkWidget *frame1;
  GtkWidget *frame2;
  GtkWidget *scrolled_win;
  GtkWidget *hbox2;
  GtkWidget *achbox;
  GtkWidget *buffButtonSel;
  GtkWidget *buffButtonClose;
  GtkWidget *buffButtonCancel;

  titles[0] = _("File name");
  titles[1] = _("Page");
  titles[2] = _("Path name");
  titles[3] = NULL;
  
  BufferSelection = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  BufferSelectionShown = 0;

#if 0
  gtk_widget_set_events(BufferSelection, GDK_KEY_PRESS_MASK);
  gtk_signal_connect(GTK_OBJECT(BufferSelection), "key_press_event", 
		     GTK_SIGNAL_FUNC(event_key_press), NULL);
#endif
  gtk_signal_connect(GTK_OBJECT(BufferSelection), "destroy", 
		     GTK_SIGNAL_FUNC(on_destry), NULL);
  gtk_signal_connect (GTK_OBJECT (BufferSelection), "destroy",
		      GTK_SIGNAL_FUNC(gtk_widget_destroyed), NULL);

  gtk_window_set_title (GTK_WINDOW (BufferSelection), 
			_("xgdvi: DVI Buffers"));
  gtk_container_set_border_width (GTK_CONTAINER (BufferSelection), 10);
  gtk_widget_set_usize (BufferSelection, WIDTH, HEIGHT);
  gtk_object_set_data (GTK_OBJECT (xgdvi), "BufferSelection", BufferSelection);

  vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (BufferSelection), vbox);
  gtk_widget_show (vbox);

  frame1 = gtk_frame_new (_("List of Opened DVI Files"));
  gtk_box_pack_start (GTK_BOX (vbox), frame1, TRUE, TRUE, 5);
  gtk_widget_show (frame1);

  BufferList = gtk_clist_new_with_titles (3, titles);
  gtk_clist_set_selection_mode (GTK_CLIST (BufferList), GTK_SELECTION_SINGLE);
  gtk_clist_set_reorderable (GTK_CLIST(BufferList), TRUE);
  gtk_clist_set_column_min_width (GTK_CLIST (BufferList), 0, MIN_WIDTH_FILE);
  gtk_clist_set_column_max_width (GTK_CLIST (BufferList), 0, MAX_WIDTH_FILE);
  gtk_clist_set_column_min_width (GTK_CLIST (BufferList), 1, MIN_WIDTH_PAGE);
  gtk_clist_set_column_max_width (GTK_CLIST (BufferList), 1, MAX_WIDTH_PAGE);
  gtk_clist_set_column_min_width (GTK_CLIST (BufferList), 2, MIN_WIDTH_PATH);
  gtk_clist_set_column_max_width (GTK_CLIST (BufferList), 2, MAX_WIDTH_PATH);
  gtk_clist_column_titles_passive (GTK_CLIST (BufferList));
  gtk_signal_connect (GTK_OBJECT (BufferList), "select_row",
		      GTK_SIGNAL_FUNC(on_buffFile_clicked), NULL);
  gtk_widget_show (BufferList);

  scrolled_win = gtk_scrolled_window_new 
    ( gtk_clist_get_hadjustment(GTK_CLIST(BufferList)),
      gtk_clist_get_vadjustment(GTK_CLIST(BufferList)));
  gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
  gtk_container_add (GTK_CONTAINER (frame1), scrolled_win);
  gtk_widget_show (scrolled_win);
  gtk_scrolled_window_set_placement (GTK_SCROLLED_WINDOW (scrolled_win),
				     GTK_CORNER_BOTTOM_RIGHT);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scrolled_win), BufferList);

  frame2 = gtk_frame_new (_("Buffer Commands"));
  gtk_box_pack_start (GTK_BOX (vbox), frame2, FALSE, TRUE, 5);
  gtk_widget_show (frame2);
  hbox2 = gtk_hbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame2), hbox2);
  gtk_container_border_width (GTK_CONTAINER (hbox2), 5);
  gtk_widget_show (hbox2);

  buffButtonSel = gtk_button_new_with_label (_("Select to Display"));
  GTK_WIDGET_SET_FLAGS (buffButtonSel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox2), buffButtonSel, TRUE, TRUE, 5);
  gtk_widget_show (buffButtonSel);
  gtk_signal_connect (GTK_OBJECT (buffButtonSel), "clicked",
		      GTK_SIGNAL_FUNC (on_buffButtonSelect_clicked),
                      NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), buffButtonSel,
     (gchar*) _("Select a DVI file in buffer to be displayed."),
     (gchar*) NULL);

  buffButtonClose = gtk_button_new_with_label (_("Delete from Buffer"));
  GTK_WIDGET_SET_FLAGS (buffButtonClose, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (hbox2), buffButtonClose, TRUE, TRUE, 0);
  gtk_widget_show (buffButtonClose);
  gtk_signal_connect (GTK_OBJECT (buffButtonClose), "clicked",
		      GTK_SIGNAL_FUNC (on_buffButtonClose_clicked),
                      NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), buffButtonClose,
     (gchar*) _("Close an opened DVI file in buffer. (This operation never deletes DVI file itself.)"),
     (gchar*) NULL);


  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);

  achbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(achbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(achbox), 5);
  gtk_box_pack_end (GTK_BOX (vbox), achbox, FALSE, TRUE, 0);
  gtk_widget_show (achbox);

  buffButtonCancel = gtk_button_new_with_label (_("Close"));
  GTK_WIDGET_SET_FLAGS (buffButtonCancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (achbox), buffButtonCancel, TRUE, TRUE, 0);
  gtk_widget_grab_default (buffButtonCancel);
  gtk_widget_show (buffButtonCancel);
  gtk_signal_connect (GTK_OBJECT (buffButtonCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_buffButtonCancel_clicked),
                      NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), buffButtonCancel,
    (gchar*) _("Close the buffer selection window."),
    (gchar*) NULL);

  return BufferSelection;
}


static void
on_destry                              (GtkObject       *obj,
                                        gpointer         user_data)
{
  int   i, p;
  char *f;

  BufferSelectionShown = 0;
  BufferSelection = create_BufferSelection ();

  for (i = buffer_size() - 1; i >= 0; i--){
    if ((f = buffer_file_name(i, &p, NULL, NULL, NULL, NULL, NULL)) != NULL){
      gbuff_insert_last(f, p);
    }
  }

  if ((buffer_size() > 0) && (dvi_file != NULL)){
    for (i = 0; i < buffer_size(); i++){
      f = buffer_file_name(i, NULL, NULL, NULL, NULL, NULL, NULL);
      if ((f != NULL) && (strcmp(f, dvi_file) == 0)){
	gtk_clist_select_row (GTK_CLIST(BufferList), i, -1);
      }
    }
  }
}


void
on_Buffer_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  if (BufferSelectionShown == 0){
    BufferSelectionShown = 1;
    gtk_widget_show (BufferSelection);
  } else {
    BufferSelectionShown = 0;
    gtk_widget_hide (BufferSelection);
  }
}


void
show_BufferSelection(void)
{
  if (BufferSelectionShown == 0){
    BufferSelectionShown = 1;
    gtk_widget_show (BufferSelection);
  }
}

void
hide_BufferSelection(void)
{
  if (BufferSelectionShown == 1){
    BufferSelectionShown = 0;
    gtk_widget_hide (BufferSelection);
  }
}




void
on_buffButtonCancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  on_Buffer_clicked(NULL, NULL);
}


void
on_buffFile_clicked                     (GtkWidget *widget,
					 gint row, 
					 gint column, 
					 GdkEventButton *ev,
					 gpointer user_data)
{
  char  *f;

  if ((ev != NULL) && (ev->type == GDK_2BUTTON_PRESS)){
    f = gtk_clist_get_row_data (GTK_CLIST (BufferList), row);
    if (f != NULL){
      buffer_save_current_state();
      buffer_select((char*)f);
      switched_buffer();
    }
  }
}


void
on_buffButtonSelect_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList  *clist; 
  char  *f;
  gint row;

  clist = GTK_CLIST (BufferList);
  if (clist->selection != NULL) {
    row = GPOINTER_TO_INT (clist->selection->data);
    f = (char*)gtk_clist_get_row_data (clist, row);
    if (f != NULL){
      buffer_save_current_state();
      buffer_select(f);
      switched_buffer();
    }
  }
}


void
on_buffButtonClose_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList  *clist; 
  char  *f;
  gint row;

  clist = GTK_CLIST (BufferList);
  if (clist->selection){
    row = GPOINTER_TO_INT (clist->selection->data);
    f = (char*)gtk_clist_get_row_data (clist, row);
    buffer_kill(f);
    switched_buffer();
  }
}



void
gbuff_insert_top(char *f, int p)
{
  int  i;

  i = 0;
  gbuff_insert_ith(f, p, i);
}

void
gbuff_insert_last(char *f, int p)
{
  int  i;

  i = GTK_CLIST(BufferList)->rows;
  gbuff_insert_ith(f, p, i);
}

void
gbuff_insert_here(char *f, int p, char *g)
{
  int  i;

  i = gtk_clist_find_row_from_data(GTK_CLIST(BufferList), g);
  if (i < 0){
    i = GTK_CLIST(BufferList)->rows;
  }
  gbuff_insert_ith(f, p, i);
}

static void
gbuff_insert_ith(char *f, int p, int i)
{
  char       text[3][1024];
  char      *texts[4];
  char      *base;

  if ((base = strrchr(f, '/')) != NULL)
    base++;
  else 
    base = f;
  
  strcpy(text[0], base);
  sprintf(text[1], "%d", p);
  strcpy(text[2], f);
  texts[0] = text[0];
  texts[1] = text[1];
  texts[2] = text[2];
  texts[3] = NULL;

  gtk_clist_freeze (GTK_CLIST (BufferList));
  gtk_clist_insert (GTK_CLIST (BufferList), i, texts);
  gtk_clist_set_row_data (GTK_CLIST (BufferList), i, f);
  gtk_clist_thaw (GTK_CLIST (BufferList));
}


void
gbuff_change_page(char *f, int p)
{
  int  row;
  char s[256];

  if ((row = gtk_clist_find_row_from_data(GTK_CLIST(BufferList), f)) < 0)
    return;

  gtk_clist_freeze (GTK_CLIST(BufferList));
  sprintf(s, "%d", p);
  gtk_clist_set_text (GTK_CLIST(BufferList), row, 1, s);
  gtk_clist_thaw (GTK_CLIST(BufferList));
}

void
gbuff_select(char *f)
{
  int  row;

  if ((row = gtk_clist_find_row_from_data(GTK_CLIST(BufferList), f)) < 0)
    return;

  gtk_clist_freeze (GTK_CLIST(BufferList));
  gtk_clist_unselect_all (GTK_CLIST(BufferList));
  gtk_clist_select_row (GTK_CLIST(BufferList), row, -1);
  gtk_clist_thaw (GTK_CLIST(BufferList));
}


void
gbuff_kill(char *f)
{
  int  row;

  if ((row = gtk_clist_find_row_from_data(GTK_CLIST(BufferList), f)) < 0)
    return;

  gtk_clist_freeze (GTK_CLIST(BufferList));
  gtk_clist_unselect_all (GTK_CLIST(BufferList));
  gtk_clist_remove (GTK_CLIST(BufferList), row);
  gtk_clist_thaw (GTK_CLIST(BufferList));
}

char*
gbuff_get_top(void)
{
  return  gtk_clist_get_row_data (GTK_CLIST (BufferList), 0);
}

char*
gbuff_get_ith(int i)
{
  int  n;

#if 0
  printf("** n=%d\n", GTK_CLIST(BufferList)->rows);
  for (n=0;n<GTK_CLIST(BufferList)->rows;n++){
    printf("*%d: %s\n",
	   n, (char*)gtk_clist_get_row_data (GTK_CLIST (BufferList), n));
  }
#endif

  n = GTK_CLIST(BufferList)->rows - 1;
  if ((i < 0) || (n < i))
    return NULL;

  return  gtk_clist_get_row_data (GTK_CLIST (BufferList), i);
}

char*
gbuff_get_near(char *f)
{
  int   near, r;

  if (GTK_CLIST(BufferList)->rows <= 1)
    return NULL;
  if ((r = gtk_clist_find_row_from_data(GTK_CLIST(BufferList), f)) < 0)
    return NULL;

  if (r > 0){
    near = r - 1;
  } else {
    near = 1;
  }

  return  gtk_clist_get_row_data (GTK_CLIST (BufferList), near);
}

void
gbuff_move_to_top(char *f)
{
  int  row;

  if ((row = gtk_clist_find_row_from_data(GTK_CLIST(BufferList), f)) < 0)
    return;
  if (row == 0)
    return;

  gtk_clist_freeze (GTK_CLIST(BufferList));
  gtk_clist_unselect_all (GTK_CLIST(BufferList));
  gtk_clist_row_move (GTK_CLIST(BufferList), row, 0);
  gtk_clist_thaw (GTK_CLIST(BufferList));
}

char*
gbuff_get_next(char *f, int next)
{
  int   near, r;

  if (f == NULL)
    return NULL;
  if (GTK_CLIST(BufferList)->rows <= 1)
    return NULL;
  if ((r = gtk_clist_find_row_from_data(GTK_CLIST(BufferList), f)) < 0)
    return NULL;

  if (next == 1){
    if (r < GTK_CLIST(BufferList)->rows - 1){
      near = r + 1;
    } else {
      near = 0;
    }
  } else {
    if (r > 0){
      near = r - 1;
    } else {
      near = GTK_CLIST(BufferList)->rows - 1;
    }
  }

  return  gtk_clist_get_row_data (GTK_CLIST (BufferList), near);
}
