/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "commonElements.H"

wxSizer* common::listChangeButtons (wxWindow* parent) {
  wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
  wxButton* b = new wxButton(parent,BTN_ADD,_("Add"),
			     wxDefaultPosition,wxDefaultSize,wxBU_EXACTFIT);
  sizer->Add(b,1,wxEXPAND|wxBOTTOM,5);
  b = new wxButton(parent,BTN_DEL,_("Delete"),
		   wxDefaultPosition,wxDefaultSize,wxBU_EXACTFIT);
  sizer->Add(b,1,wxEXPAND|wxBOTTOM,5);
  b = new wxButton(parent,BTN_EDIT,_("Edit"),
		   wxDefaultPosition,wxDefaultSize,wxBU_EXACTFIT);
  sizer->Add(b,1,wxEXPAND);
  return sizer;
}

#include <wx/wfstream.h>

wxInputStream* common::getInputStream (wxURL& url) {
  wxInputStream* retval;
  {
    wxLogNull logTarget; //ignore and don't display error message
    retval = url.GetInputStream();
  }

  if (retval == 0
      || (url.GetProtocolName() == wxString(_T("file"))
	  && !((wxFileInputStream*)retval)->Ok())) {
    delete retval;
    return 0;
  } else {
    return retval;
  }
}

wxBitmap* common::getLogo () {
  LessonPath logopath;
  logopath.setFullFileName(_T("logo.png"));
  return common::getBitmap(logopath);
}

#include <wx/image.h>

wxBitmap* common::getBitmap (UrlFile& file) {
  wxURL* u = file.getURL();
  wxInputStream* stream = common::getInputStream(*u);

  wxBitmap* b = 0;
  if (stream != 0) {
    wxImage logo(*stream,
		 common::getBitmapType(u->GetProtocol().GetContentType(),
				       file.getFileExt()));
    if (logo.Ok()) {
      b = new wxBitmap(logo);
    }
  }
  delete stream;
  delete u;
  return b;
}

long common::getBitmapType (const wxString& mime,
			    const wxString& fileExt) {
  /* wxBITMAP_TYPE_ANY is supposed to work but of current
   * wxWindows-2.4.1, it does only for local files, not
   * HTTP or FTP files.
   * Thus, this is meant to be a work-around.
   */
  wxList& l = wxImage::GetHandlers();
  wxList::Node* node;
  wxImageHandler* handler;
  for (node = l.GetFirst(); node; node = node->GetNext()) {
    handler=(wxImageHandler*)node->GetData();
    if (mime == handler->GetMimeType() ||
	fileExt == handler->GetExtension()) {
      return handler->GetType();
    }
  }
  /* If none of the above matched,
   * the following surely will not work either.
   * However it produces the default error message.
   */
  return wxBITMAP_TYPE_ANY;
}

wxArrayString common::getIndexFile (wxInputStream& stream, const wxString& charset)
{
  wxCSConv temp(charset);
  return common::getIndexFile(stream,temp);
}

wxArrayString common::getIndexFile (wxInputStream& stream, wxMBConv& charset)
{
  wxArrayString retval;
  wxString content;
  wxTextInputStream f(stream);
  do {
    content = readTextLine(f,charset);
    if (stream.IsOk()) {
      retval.Add(content);
    }
  } while(stream.IsOk() && !stream.Eof());
  return retval;
}

wxString common::readTextAll (wxInputStream& stream, const wxString& charset,
			      const wxString& lineEnding)
{
  wxCSConv temp(charset);
  return readTextAll(stream,temp,lineEnding);
}

wxString common::readTextAll (wxInputStream& stream, wxMBConv& charset,
			      const wxString& lineEnding)
{
  wxString content;
  wxString retval;
  wxTextInputStream f(stream);
  do {
    content = readTextLine(f,charset);
    retval += content + lineEnding;
  } while(stream.IsOk() && !stream.Eof());
  return retval;
}

wxString common::readTextLine (wxInputStream& stream, const wxString& charset)
{
  wxCSConv temp(charset);
  return readTextLine(stream,temp);
}

wxString common::readTextLine (wxInputStream& stream, wxMBConv& charset)
{
  wxTextInputStream f(stream,_T(" \t")
#if wxUSE_UNICODE
		      ,charset
#endif
		      );
  return readTextLine(f,charset);
}

wxString common::readTextLine (wxTextInputStream& stream, const wxString& charset)
{
  wxCSConv temp(charset);
  return readTextLine(stream,temp);
}

wxString common::readTextLine(wxTextInputStream& stream, wxMBConv& charset) {
//wxMSW crashes on UTF-8 files created with the WindowsXP Editor
#if wxUSE_UNICODE
  return stream.ReadLine();
#else
  return wxString(charset.cMB2WC(stream.ReadLine()), wxConvLocal);
#endif
}

wxString* common::toStringPtr(wxArrayString& input) {
  wxString** retval = new wxString*[input.GetCount()];
  for (unsigned int i=0;i<input.GetCount();++i) {
    retval[i]=&input[i];
  }
  return *retval;
}

wxUChar common::specialLineEnd (wxFontEncoding charset) {
#if wxUSE_UNICODE
  return wxUChar(0xb6);
#else
  switch (charset) {
  case wxFONTENCODING_ISO8859_1:
  case wxFONTENCODING_ISO8859_15:
  case wxFONTENCODING_CP1252:
    return wxUChar(0xb6);
    break;
  default:
    return wxUChar(0);
    break;
  }
#endif
}
