/****************************************************************************
    Copyright (C) 1987-2004 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#define STRMAX			1024			/* Maxmimum length of a string */
#define THYMEWHEEL_SIZE		0x1000			/* Size of timewheel (must be power of two) */
#define THYMEWHEEL_MASK		0x0fff			/* Mask for thymewheel (= size-1) */
#define MAXPADS			16			/* Maximum number of pad on a gate */
#define MAXPADPINS		1000			/* Maximum number of pins on a pad */

#define POLL_RATE		50			/* Time between input checks (milliseconds) */

/* end of configuration parameters */
/****************************************************************************/

#define SSWORDMASK		((unsigned)~0)		/* Word with all bits set */
#define SSWORDSIZE		(8*sizeof(unsigned))	/* # bits in an unsigned */
#define SSBITMASK		0x1f			/* Mask to get bit in word */
#define SSWORDSHIFT		5			/* Shift to get word index */


/*
  LMASK returns a mask with the low n bits set
  HMASK returns a mask with the high n bits set
 */
#define LMASK(n)	(SSWORDMASK >> (SSWORDSIZE-(n)))
#define HMASK(n)	(SSWORDMASK << (SSWORDSIZE-(n)))
#define LMASKZ(n)	(SSWORDMASK >> (n))
#define HMASKZ(n)	(SSWORDMASK << (n))

/*
 * Number of words needed for b bits.
 */
#define SSNUMWORDS(b)	(((b)>>SSWORDSHIFT) + (((b)&SSBITMASK)!=0))

/*
 * Bit position (in the high words) of the high bit in a b-bit word
 */
#define SSHIGHBIT(b)	(((b)-1)&SSBITMASK)

typedef struct sstate SState;
typedef struct snet SNet;
typedef struct sport SPort;
typedef struct sportlist SPortList;
typedef struct sgate SGate;
typedef struct smodule SModule;
typedef struct evqueue EvQueue;
typedef union sevent SEvent;
typedef struct breakpoint SBreakpoint;

