/* vim: set tabstop=4: */
/*
 * This file is part of TraceProto.
 * Copyright 2004 Eric Hope
 * skippysaurus@skippylair.net
 *
 * TraceProto is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * TraceProto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TraceProto; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include "as.h"

#ifdef USE_DMALLOC
#include <dmalloc.h>
#endif /* USE_DMALLOC */

int setup_as ( )
{
	char * ra_env;
	int ra_env_len;

	// look up the server name if present
	ra_env = getenv ( "RA_SERVER" );

	if ( ra_env == NULL )
	{
		ra_server = ( char * ) malloc ( sizeof ( char ) * 13 );
		memset ( ra_server, '\0', sizeof ( char ) * 13 );
		strncpy ( ra_server, "whois.ra.net", 12 );
	} else {
		ra_env_len = strlen ( ra_env );
		ra_server = ( char * ) malloc ( sizeof ( char ) * ( ra_env_len + 1 ) );
		strncpy ( ra_server, ra_env, ra_env_len );
	}

	if ( ( ra_hostent = gethostbyname ( ra_server ) ) == NULL )
	{
		strcpy ( as_string, "unable to lookup ra_server IP" );
		return -1;
	}

	ra_env = NULL;
	ra_env_len = 0;

	// look up the port
	ra_env = getenv ( "RA_SERVICE" );

	if ( ra_env == NULL )
	{
		ra_service = ( char * ) malloc ( sizeof ( char ) * 6 );
		memset ( ra_service, '\0', sizeof ( char ) * 6 );
		strncpy ( ra_service, "whois", 5 );
	} else {
		ra_env_len = strlen ( ra_env );
		ra_service = ( char * ) malloc ( sizeof ( char ) * ( ra_env_len + 1 ) );
		memset ( ra_service, '\0', strlen ( ra_env ) + 1 );
		strncpy ( ra_service, ra_env, ra_env_len );
	}

	if ( ( ra_servent = getservbyname ( ra_service, "tcp" ) ) == NULL )
	{
		strcpy ( as_string, "unable to lookup ra_server port" );
		return -1;
	}

	return 0;
}


int find_as ( char * dotted_quad )
{
	int as_socket;
	struct protoent * protoent;
	struct sockaddr_in as_server_addr;

	char send_buf [ 18 ];
	char recv_buf [ 512 ];
	char * sub_string;
	char * end_string;

	fd_set as_select;
	struct timeval timeout;

	protoent = getprotobyname ( "tcp" );

	if ( ( as_socket = socket ( PF_INET, SOCK_STREAM, protoent->p_proto ) ) == -1 )
	{
		strcpy ( as_string, "as socket error" );
		return -1;
	} 

	as_server_addr.sin_family = PF_INET;
	//as_server_addr.sin_port = htons ( ra_servent->s_port );
	as_server_addr.sin_port = ra_servent->s_port;
	bcopy ( ra_hostent->h_addr_list[0], & as_server_addr.sin_addr, ra_hostent->h_length );

	if ( connect ( as_socket,
		( struct sockaddr * ) & as_server_addr,
		sizeof ( struct sockaddr_in ) ) == -1 )
	{
		// FIX: parse connect errors more fully here
		strcpy ( as_string, "unable to connect to server" );
		return -1;
	}

	FD_ZERO ( & as_select );
	FD_SET ( as_socket, & as_select );

	timeout.tv_sec = 10;
	timeout.tv_usec = 0;

	memset ( send_buf, '\0', sizeof ( send_buf ) );
	memset ( recv_buf, '\0', sizeof ( recv_buf ) );
	snprintf ( send_buf, sizeof ( send_buf ), "%s\r\n", dotted_quad );

	if ( send ( as_socket, send_buf, sizeof ( send_buf ), 0 ) == -1 )
	{
		// FIX: parse send errors more fully here
		strcpy ( as_string, "error sending" );
		return -1;
	}

	if ( select ( as_socket + 1, & as_select, NULL, NULL, & timeout ) == 0 )
	{
		strcpy ( as_string, "UNKNOWN" );
		return -1;
	}

	if ( recv ( as_socket, recv_buf, sizeof ( recv_buf ) - 1, 0 ) == -1 )
	{
		// FIX: blah blah blah
		strcpy ( as_string, "error receiving" );
		return -1;
	}

	sub_string = strstr ( recv_buf, "AS" );
	if ( sub_string == NULL )
	{
		sub_string = "UNKNOWN";
	} else {
		end_string = strchr ( sub_string, '\n' );
		* end_string = '\0';
	}

	bcopy ( sub_string, as_string, sizeof ( as_string ) - 1 );

	return 0;
	
}
