<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup BASE
 * @module history_show
 * @package BASE
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 # Needs nearly everything
 include_once 'product.pinc';
 include_once 'bug.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';
 include_once 'appointment.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("history","show");
 loadlayout();
 /**
  * display a history page
  */
 class history_show extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$tutos;

     if ( $this->id == -1 ) {
       $cols = 7;
     } else {
       $cols = 5;
     }
     if ( $this->adr_id != -1 ) {
       $cols--;
     }
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo " <th colspan=\"". $cols ."\">\n";
     if ( $this->obj != -1 ) {
       echo sprintf($lang['HistoryShow'],$lang[$this->obj->getType()],menulink($this->obj->getURL(),$this->obj->getFullName()));
     } else {
       if ( $this->id != -1 ) {
         echo sprintf($lang['HistoryShow'],"","(". $lang['HistoryDeleted']) .")";
       } else {
         echo sprintf($lang['HistoryShow'],"","\"". $lang['AppEverything']) ."\"";
       }
       # Pseudo empty object
       $this->obj = new tutos_base($this->user->dbconn);
       $this->obj->init($this->user->dbconn);
       $this->obj->id = $this->id;
     }
     if ( $this->adr_id != -1 ) {
       $adr = getObject($this->user->dbconn,$this->adr_id);
       echo " by ". $adr->getFullName();
     }
     echo " </th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     if ( $this->id == -1 ) {
       echo $this->orderheader("","Type",$this->link2);
       echo $this->orderheader("","ID",$this->link2);
     }
     echo $this->orderheader("",$lang['HistoryFld'],$this->link2);
     echo $this->orderheader("",$lang['HistoryOldV'],$this->link2);
     echo $this->orderheader("",$lang['HistoryNewV'],$this->link2);
     if ( $this->adr_id == -1 ) {
       echo $this->orderheader("",$lang['User'],$this->link2);
     }
     echo $this->orderheader("m_time",$lang['atDateTime'],$this->link2);
     echo "</tr>\n";
     echo "</thead>\n";

     $line = 0;
     $this->obj->readHistory($this->adr_id,$this->xf,$this->xo,$this->start);
	 $n = $this->obj->history_size;
     if ( $n == 0 ) {
       echo $this->error ( $lang['Err0048'] );
       echo "</table>\n";
       return;
     }
     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     echo "<tbody>\n";
     while ( ($a < $n) && ($a < $end) ) {
       $f = &$this->obj->history[$a];
       echo $this->OverviewRowStart($line);

       if ( $this->id == -1 ) {
         $x = getObject($this->dbconn,$f["obj_id"],1);
         if ( $x == -1 ) {
           echo " <td colspan=\"2\"><b>&nbsp;". $f["obj_id"] ."</b></td>\n";
         } else {
           echo " <td>&nbsp;". $lang[$x->getType()] ."</td><td>&nbsp;<b>". $x->getLink() ."</b></td>\n";
         }
         unset($x);
       }

       if ( $f['field'] == "TaskState" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;". $lang['TaskStates'][$f["old"]] ."</td>\n";
         echo " <td>&nbsp;". $lang['TaskStates'][$f["new"]] ."</td>\n";
       } else if ( $f['field'] == "BugState" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;". $lang['BugStates'][$f["old"]] ."</td>\n";
         echo " <td>&nbsp;". $lang['BugStates'][$f["new"]] ."</td>\n";
       } else if ( $f['field'] == "BugClass" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;". $lang['BugClasses'][$f["old"]] ."</td>\n";
         echo " <td>&nbsp;". $lang['BugClasses'][$f["new"]] ."</td>\n";
       } else if ( $f['field'] == "BugCreate" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;</td>\n";
         $b = new bug($this->dbconn);
         $b->read($f["new"]);
         if ( $b->id > 0 ) {
           echo " <td>&nbsp;". $b->getLink() ."</td>\n";
         } else {
           echo " <td><i>". makelink("history_show.php?id=". $f["new"],$lang['HistoryDeleted']) ."</i></td>\n";
         }
       } else if ( $f['field'] == "InvoiceState" ) {
         loadmodule("invoice");
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;". $lang['InvoiceStates'][$f["old"]] ."</td>\n";
         echo " <td>&nbsp;". $lang['InvoiceStates'][$f["new"]] ."</td>\n";
       } else if ( $f['field'] == "InstCreate" ) {
         loadmodule("installation");
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;</td>\n";
         $b = new installation($this->dbconn);
         $b->read($f["new"]);
         if ( $b->id > 0 ) {
           echo " <td>&nbsp;". $b->getLink() ."</td>\n";
         } else {
           echo " <td><i>". makelink("history_show.php?id=". $f["new"],$lang['HistoryDeleted']) ."</i></td>\n";
         }
       } else if ( $f['field'] == "NoteCreate" ) {
         loadmodule("note");
         $b = new note($this->dbconn);
         $b->read($f["new"]);
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;</td>\n";
         if ( $b->id > 0 ) {
           echo " <td>&nbsp;". $b->getLink() ."</td>\n";
         } else {
           echo " <td><i>". makelink("history_show.php?id=". $f["new"],$lang['HistoryDeleted']) ."</i></td>\n";
         }
       } else if ( $f['field'] == "FileCreate" ) {
         loadmodule("file");
         $b = new tutos_file($this->dbconn);
         $b->read($f["new"]);
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;</td>\n";
         if ( $b->id > 0 ) {
           echo " <td>&nbsp;". $b->getLink() ."</td>\n";
         } else {
           echo " <td><i>". $lang['HistoryDeleted'] ."</i></td>\n";
         }
       } else if ( $f['field'] == "Location2" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;". $lang['AppLoc'][$f["old"]] ."</td>\n";
         echo " <td>&nbsp;". $lang['AppLoc'][$f["new"]] ."</td>\n";
       } else if ( $f['field'] == "Company" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         $b = new company($this->dbconn);
         $b->read($f["old"]);
         if ( $b->id == $f["old"] ) {
           echo " <td>&nbsp;". $b->getLink() ."</td>\n";
         } else {
           echo " <td>&nbsp;". $f["old"] ."</td>\n";
         }
         $b = new company($this->dbconn);
         $b->read($f["new"]);
         if ( $b->id == $f["new"] ) {
           echo " <td>&nbsp;". $b->getLink() ."</td>\n";
         } else {
           echo " <td>&nbsp;". $f["new"] ."</td>\n";
         }
       } else if ( $f['field'] == "URLAdd" ) {
         $b = new url($this->dbconn);
         $b->read($f["new"]);
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;</td>\n";
         if ( $b->id > 0 ) {
           echo " <td>&nbsp;". $b->getLink() ."</td>\n";
         } else {
           echo " <td><i>". makelink("history_show.php?id=". $f["new"],$lang['HistoryDeleted']) ."</i></td>\n";
         }
       } else if ( $f['field'] == "TaskCreate" ) {
         $b = new task($this->dbconn);
         $b->read($f["new"]);
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;</td>\n";
         if ( $b->id > 0 ) {
           echo " <td>&nbsp;". $b->getLink() ."</td>\n";
         } else {
           echo " <td><i>". makelink("history_show.php?id=". $f["new"],$lang['HistoryDeleted']) ."</i></td>\n";
         }
       } else if ( $f['field'] == "AppointCommit" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;". $lang['AppState'][$f["old"]] ."</td>\n";
         echo " <td>&nbsp;". $lang['AppState'][$f["new"]] ."</td>\n";
       } else if ( $f['field'] == "ProductP" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         $b = new product($this->dbconn);
         $b->read($f["old"]);
         echo " <td>&nbsp;". $b->getLink() ."</td>\n";
         $b = new product($this->dbconn);
         $b->read($f["new"]);
         echo " <td>&nbsp;". $b->getLink() ."</td>\n";
       } else if ( $f['field'] == "TaskSubTask" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         $b = getObject($this->dbconn,$f["old"]);
         echo " <td>&nbsp;". $b->getLink() ."</td>\n";
		 unset($b);
         $b = getObject($this->dbconn,$f["new"]);
         echo " <td>&nbsp;". $b->getLink() ."</td>\n";
       } else if ( $f['field'] == "ProdState" ) {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;". $lang['ProdStates'][$f["old"]] ."</td>\n";
         echo " <td>&nbsp;". $lang['ProdStates'][$f["new"]] ."</td>\n";
       } else if ( ereg("ProdRole?",$f['field'])
                 ||  ($f['field'] == "Customer")
                 ||  ($f['field'] == "SoldBy")
                 ||  ($f['field'] == "FileAuthor")
                 ||  ($f['field'] == "TeamDel")
                 ||  ($f['field'] == "TeamAdd")
                 ||  ($f['field'] == "BugAssignedTo")
                 ||  ($f['field'] == "InstalledBy") ) {
         loadmodule("file");
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         if ( $f["old"] <= 0 ) {
           echo " <td>&nbsp;</td>\n";
         } else {
           $b = getObject($this->dbconn,$f["old"]);
           if ( $b->id > 0 ) {
             echo " <td>&nbsp;". $b->getLink() ."</td>\n";
           } else {
             echo " <td><i>". makelink("history_show.php?id=". $f["old"],$lang['HistoryDeleted']) ."</i></td>\n";
           }
         }
         if ( $f["new"] <= 0 ) {
           echo " <td>&nbsp;</td>\n";
         } else {
           $b = getObject($this->dbconn,$f["new"]);
           if ( $b->id > 0 ) {
             echo " <td>&nbsp;". $b->getLink() ."</td>\n";
           } else {
             echo " <td><i>". makelink("history_show.php?id=". $f["new"],$lang['HistoryDeleted']) ."</i></td>\n";
           }
         }
       } else {
         echo " <td><b>&nbsp;". (isset( $lang[$f["field"]]) ? $lang[$f["field"]] : $f["field"]) ."</b></td>\n";
         echo " <td>&nbsp;". myentities($f["old"]) ."</td>\n";
         echo " <td>&nbsp;". myentities($f["new"])."</td>\n";
       }
       if ( $this->adr_id == -1 ) {
         $adr = new tutos_address($this->dbconn);
         $adr->read($f["adr_id"]);
         echo " <td>&nbsp;". $adr->getLink() ."</td>\n";
       }
       $mt = new DateTime();
       $mt->setDateTime($f["m_time"]);
       echo " <td>&nbsp;". $mt->getDateTime() ."</td>\n";
       echo $this->OverviewRowEnd($line++);
       flush();
       unset($adr);
       unset($mt);
       unset($b);
       unset($f);
       $a++;
     }
     echo "</tbody>\n";
     echo $this->list_navigation($this->link1,$cols,$this->start,$a,$n);
     echo $this->OverviewTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->link1 = "history_show.php";
     $this->obj = -1;
     $this->adr_id = -1;

     if ( isset($_GET['id']) ) {
       $this->id = $_GET['id'];
       $this->obj = getObject($this->dbconn,$this->id);
       $this->link1 = addUrlParameter($this->link1,"id=".$this->id);
       if ( $this->obj != -1 ) {
         $this->id = $this->obj->id;
         $this->name = sprintf($lang['HistoryDetail'],$lang[$this->obj->getType()]);
       } else {
         $this->name = sprintf($lang['HistoryDetail']," (". $lang['HistoryDeleted'] ." ". $this->id .")");
       }
     } else {
       if ($this->user->admin != 0 ) {
         $this->id = -1;
         $this->name = sprintf($lang['HistoryDetail'],"\"". $lang['AppEverything'] ."\"");
       } else {
         $this->id = -1;
         $msg .= "Missing ID";
         $this->stop = true;
       }
     }
     if ( isset($_GET['adr_id']) ) {
       $this->adr_id = $_GET['adr_id'];
       $this->link1 = addUrlParameter($this->link1,"adr_id=".$this->adr_id);
     }
     $this->link2 = $this->link1;
     if ( ! isset($_GET['start']) ) {
       $this->start = 0;
     } else {
       $this->start = $_GET['start'];
     }
     if ( ! isset($_GET['xf']) ) {
       $this->xf = "m_time";
     } else {
       $this->xf = $_GET['xf'];
     }
     if ( ! isset($_GET['xo']) ) {
       $this->xo = 1;
     } else {
       $this->xo = $_GET['xo'];
     }

     if ( ! $this->user->feature_ok(usehistory,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],$this->name);
       $this->stop = true;
     }
   }
 }

 $l = new history_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: history_show.php,v 1.58 2003/02/03 05:41:42 gokohnert Exp $
    $Author: gokohnert $
-->
