<?php
	// database "definition"
	$dbnames = array( 	"twig_mail_prefs", 
				"twig_news_prefs", 
				"twig_folders", 
				"twig_contacts", 
				"twig_bookmarks", 
				"twig_todo", 
				"twig_schedule", 
				"twig_groups", 
				"twig_members", 
				"twig_accounts",
				"twig_acl_groups", 
				"twig_acl",
				"twig_bookmarks_prefs",
				"twig_contacts_prefs",
				"twig_global_prefs",
				"twig_schedule_prefs",
				"twig_todo_prefs",
				"twig_main_prefs",
				"twig_context",
				"twig_session",
				"twig_lhsqltable",
				"twig_notes",
				"twig_notes_prefs",
				"twig_meetings",
				"twig_meetings_prefs",
				"twig_meetings_registration",
				"twig_sclhsqltable",
				"twig_meetings_invitations",
				"twig_announce",
				"twig_contacts_lists_entries",
				"twig_schedule_recurring"
			);

	$dbnametranslate = array( 	"twig_mail_prefs"=>"0", 
					"twig_news_prefs"=>"1", 
					"twig_folders"=>"2", 
					"twig_contacts"=>"3", 
					"twig_bookmarks"=>"4", 
					"twig_todo"=>"5", 
					"twig_schedule"=>"6", 
					"twig_groups"=>"7", 
					"twig_members"=>"8", 
					"twig_accounts"=>"9",
					"twig_acl_groups"=>"10", 
					"twig_acl"=>"11",
					"twig_bookmarks_prefs"=>"12",
					"twig_contacts_prefs"=>"13",
					"twig_global_prefs"=>"14",
					"twig_schedule_prefs"=>"15",
					"twig_todo_prefs"=>"16",
					"twig_main_prefs"=>"17",
					"twig_context"=>"18",
					"twig_session"=>"19",
					"twig_lhsqltable"=>"20",
					"twig_notes"=>"21",
					"twig_notes_prefs"=>"22",
					"twig_meetings"=>"23",
					"twig_meetings_prefs"=>"24",
					"twig_meetings_registration"=>"25",
					"twig_sclhsqltable"=>"26",
					"twig_meetings_invitations"=>"27",
					"twig_announce"=>"28",
					"twig_contacts_lists_entries"=>29,
					"twig_schedule_recurring"=>30
				);

	$dbdefs = array( 
		array(						// twig_mail_prefs
			array("id",        "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
	        	array("realname",  "C", 50      ),
	        	array("signature", "C", 128     ),
		        array("linewrap",  "N", 3   , 0 ),
        		array("replyto",   "C", 50      ),
	        	array("pagesize",  "N", 3   , 0 ),
        		array("sortby",    "C", 10      ),
	        	array("sortorder", "N", 1   , 0 ),
	        	array("dande",     "N", 1   , 0 ),
	        	array("savesent",  "N", 1   , 0 ),
        		array("sentfold",  "C", 100     ),
        		array("draftfold", "C", 100     ),
	        	array("cmdline2",  "N", 1   , 0 ),
	        	array("newwindow", "N", 1   , 0 ),
	        	array("newcontact","N", 1   , 0 ),
			array("numup",	   "N", 1   , 0 ), 
			array("mailtree",  "N",	1   , 0	),
			array("mtexpand",  "N",	1   , 0	),
			array("mtview",	   "C",	128	),
			array("mdn",       "N",	1   , 0	),
			array("mdn_mode",  "N",	1   , 0	),
			array("areply",    "N",	1   , 0	),
			array("aforward",  "N",	1   , 0	),
			array("clines",    "N",	1   , 0	),
			array("mande",     "N",	1   , 0	),
			array("dreturn",   "N", 1   , 0 ),
			array("fromaddres","C", 128     )
		    	),

		array(						// twig_news_prefs
			array("id",        "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
        		array("replyto",   "C", 50      ),
	        	array("pagesize",  "N", 3   , 0 ),
	        	array("newwindow", "N", 3   , 0 ),
			array("linewrap",  "N", 3   , 0 ),
	        	array("realname",  "C", 50      ),
	        	array("signature", "C", 128     ),
			array("inline",    "N", 3   , 0 )
		    	),

		array(						// twig_folders
			array("id",        "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
        		array("server",    "C", 255     ),
			array("port",      "N", 3  , 0  ),
        		array("groupname", "C", 255     ),
        		array("usernamer", "C", 20      ),
        		array("password",  "C", 20      ),
        		array("servertype","C", 10      )
		    	),

		array(						// twig_contacts
			array("id",        "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
        		array("thedate",   "C", 14      ),
			array("groupid",   "N", 5  , 0  ),
        		array("item",      "C", 255     ),
        		array("descriptio","C", 255     ),
        		array("url",       "C", 255     ),
        		array("firstname", "C", 100     ),
        		array("lastname",  "C", 100     ),
        		array("email",     "C", 100     ),
        		array("company",   "C", 100     ),
        		array("home_phone","C", 30      ),
        		array("work_phone","C", 30      ),
        		array("mobile",    "C", 30      ),
        		array("fax",       "C", 30      ),
        		array("address1",  "C", 200     ),
        		array("address2",  "C", 200     ),
        		array("city",      "C", 100     ),
        		array("state",     "C", 10      ),
        		array("zipcode",   "C", 10      ),
        		array("country",   "C", 100     ),
			array("email2",    "C", 100     ),
			array("email3",    "C", 100     ),
			array("title",     "C", 100     ),
			array("pager",     "C", 30      ),
			array("ofax",      "C", 30      ),
			array("department","C", 100     ),
			array("office",    "C", 100     ),
			array("spouse",    "C", 100     ),
			array("bday",      "C", 40      ),
			array("oaddress1", "C", 100     ),
			array("oaddress2", "C", 100     ),
			array("ocity",     "C", 100     ),
			array("ozip",      "C", 100     ),
			array("ostate",    "C", 10      ),
			array("ocountry",  "C", 100     ),
			array("type",      "N", 3   , 0 )
		    	),

		array(						// twig_bookmarks
			array("id",        "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
        		array("thedate",   "C", 14      ),
			array("groupid",   "N", 5  , 0  ),
        		array("item",      "C", 255     ),
        		array("descriptio","C", 255   ),
        		array("url",       "C", 255     )
		    	),

		array(						// twig_todo
			array("id",        "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
        		array("thedate",   "C", 14      ),
			array("groupid",   "N", 5  , 0  ),
        		array("item",      "C", 255     ),
        		array("descriptio","C", 255     ),
        		array("priority",  "N", 5,   0  ),
        		array("completed", "N", 1,   0  ),
   			array("duedate",   "N", 14 , 0	),
   			array("duetype",   "N", 11 , 0	)
		    	),

		array(						// twig_schedule
			array("id",        "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
        		array("thedate",   "C", 14      ),
			array("groupid",   "N", 5  , 0  ),
        		array("itemstart", "C", 14      ),
        		array("itemstop",  "C", 14      ),
        		array("item",      "C", 255     ),
        		array("descriptio","C", 255     ),
			array("notime",	   "C",	1  , 0	),
			array("recurtype", "N", 1  , 0  ),
			array("recurid",   "N", 14 , 0  )
		    	),

		array(						// twig_groups
			array("id",        "N", 5  , 0  ),
	    		array("owner",     "C", 20      ),
        		array("groupname", "C", 100     ),
			array("type",      "C", 20      )
		    	),

		array(						// twig_members
			array("id",        "N", 5  , 0  ),
			array("groupid",   "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
			array("writeperms","N", 5  , 0  )
		    	),

		array(						// twig_accounts
			array("id",        "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
	    		array("password",  "C", 20      ),
			array("SID",       "N", 10 , 0  ),
			array("onnow",     "N", 21 , 0  ),
			array("expire",    "N", 21 , 0  ),
			array("laston",    "N", 21 , 0  )
		    	),

		array(						// twig_acl_groups
			array("SID",       "N", 10  , 0 ),
	    		array("groupname", "C", 64      ),
	    		array("username",  "C", 20      )
		    	),

		array(						// twig_acl
			array("SID",       "N", 10  , 0 ),
	    		array("ident",     "C", 64      ),
	    		array("alevel",    "N", 10  , 0 )
		    	),

		array(						// twig_bookmarks_prefs
			array("id",        "N", 11  , 0 ),
	    		array("username",  "C", 20      ),
	    		array("sortby",    "C", 10      ),
			array("sortorder", "N", 1   , 0 ),
			array("dgroup",    "N", 11  , 0 ),
   			array("pagesize",  "N",	11  , 0	),
	    		array("viewgrp",   "C", 10      )
		    	),

		array(						// twig_contacts_prefs
			array("id",        "N", 11  , 0 ),
	    		array("username",  "C", 20      ),
	    		array("sortby",    "C", 10      ),
			array("sortorder", "N", 1   , 0 ),
			array("dgroup",    "N", 11  , 0 ),
	        	array("pagesize",  "N", 3   , 0 ),
	    		array("viewgrp",   "C", 10      )
		    	),

		array(						// twig_global_prefs
			array("id",        "N", 11  , 0 ),
	    		array("username",  "C", 20      ),
			array("mstyle1",   "N", 4   , 0 ),
			array("mstyle2",   "N", 4   , 0 ),
	    		array("language",  "C", 20      ),
			array("mailfoot",  "N", 1   , 0 ),
	    		array("prevnext",  "C", 20      ),
			array("timeformat","N", 1   , 0 )
		    	),

		array(						// twig_schedule_prefs
			array("id",        "N", 11  , 0 ),
	    		array("username",  "C", 20      ),
			array("dgroup",    "N", 11  , 0 ),
	    		array("viewgrp",   "C", 10      )
		    	),

		array(						// twig_todo_prefs
			array("id",        "N", 11  , 0 ),
	    		array("username",  "C", 20      ),
	    		array("sortby",    "C", 10      ),
			array("sortorder", "N", 1   , 0 ),
			array("dgroup",    "N", 11  , 0 ),
			array("priority",  "N", 4   , 0 ),
   			array("pagesize",  "N", 11  , 0	),
	    		array("viewgrp",   "C", 10      ),
   			array("duetype",   "N", 11  , 0	)
		    	),

		array(						// twig_main_prefs
			array("id",        "N", 11  , 0 ),
	    		array("username",  "C", 20      ),
	    		array("schedule",  "N", 1   , 0 ),
	    		array("recentmail","N", 1   , 0 )
		    	),

		array(						// twig_context
			array("id",        "C", 40      ),
	    		array("username",  "C", 20      ),
	    		array("context",   "C", 254     ),
			array("SID",       "N", 11  , 0 )
		    	),

		array(						// twig_session
			array("id",        "C", 40      ),
	    		array("username",  "C", 20      ),
	    		array("sdata",     "C", 254     ),
			array("SID",       "N", 11  , 0 )
		    	),

		array(						// twig_lhsqltable
			array("LID",       "C", 40      ),
	    		array("username",  "C", 20      ),
	    		array("password",  "C", 20      ),
			array("expire",    "C", 21      )
		    	),

		array( 						// twig_notes
			array("id",        "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
        		array("thedate",   "C", 14      ),
			array("groupid",   "N", 5  , 0  ),
        		array("item",      "C", 255     ),
        		array("descriptio","C", 255     ),
        		array("attachname","C", 255     ),
			array("attachment","C", 255	)
			),

		array( 						// twig_notes_prefs
			array("id",        "N", 11  , 0 ),
	    		array("username",  "C", 20      ),
	    		array("sortby",    "C", 10      ),
			array("sortorder", "N", 1   , 0 ),
			array("dgroup",    "N", 11  , 0 ),
			array("width",     "N", 11  , 0 ),
			array("height",    "N", 11  , 0 ),
			array("pagesize",  "N", 11  , 0	),
	    		array("viewgrp",   "C", 10      )
		    	),

		array( 						// twig_meetings
			array("id",        "N", 5  , 0  ),
			array("groupid",   "N", 5  , 0  ),
	    		array("username",  "C", 20      ),
	    		array("secretary", "C", 20      ),
	    		array("responsibl","C", 20      ),
        		array("thedate",   "C", 14      ),
        		array("itemstart", "C", 14      ),
        		array("itemstop",  "C", 14      ),
        		array("item",      "C", 255     ),
        		array("descriptio","C", 255     ),
        		array("minutes",   "C", 255     ),
        		array("conclusion","C", 255     ),
        		array("actionitem","C", 255     ),
			array("location",  "N", 5  , 0  ),
			array("userlimit", "N", 5  , 0  ),
			array("closed",    "N", 5  , 0  ),
			array("deleted",   "N", 5  , 0  ),
			array("private",   "N", 5  , 0  )
			),
		
		array( 						// twig_meetings_prefs
			array("id",        "N", 11  , 0 ),
	    		array("username",  "C", 20      ),
			array("dgroup",    "N", 11  , 0 ),
			array("mainview",  "N", 11  , 0 ),
			array("pagesize",  "N", 11  , 0 ),
	    		array("viewgrp",   "C", 10      )
			),

		array(						// twig_meetings_registration
			array("idx",       "N", 11  , 0 ),
	    		array("user_idx",  "C", 20      ),
			array("event_idx", "N", 11  , 0 ),
	    		array("r_date",    "C", 14      ),
			array("rsvp",      "N", 11  , 0 )
			),

		array(
   			array("LID",	   "C", 40	),	// twig_sclhsqltable
   			array("pwdata",	   "C", 128	),	
   			array("username",  "C", 20 	),	
   			array("expire",    "N", 11  , 0 )	
			),

		array(						
  			array("idx",       "N", 11  , 0 ),	// twig_meetings_invitations
			array("user_idx",  "C", 20      ),
  			array("event_idx", "N", 11  , 0 ),
  			array("r_date",    "C", 14      ),
  			array("priority",  "N", 11  , 0 )
			),

		array(
			array("id",        "N", 11  , 0 ),	// twig_announce
   			array("thedate",   "C", 14      ),
   			array("username",  "C", 128     ),
   			array("email",     "C", 128     ),
   			array("subject",   "C", 128     ),
   			array("announce",  "C", 128     )
			),

		array(						
			array("listid",    "N", 11  , 0 ),	// twig_contacts_lists_entries
			array("type",      "N", 11  , 0 ),
			array("item",      "N", 11  , 0 ),
			array("subitem",   "N", 11  , 0 )
			),

		array(						
			array("id",        "N", 11  , 0 ),	// twig_schedule_recurring
			array("schid",     "N", 11  , 0 ),
			array("recurtype", "N", 11  , 0 ),
			array("schedule",  "N", 11  , 0 ),
			array("cycle",     "N", 11  , 0 ),
			array("position",  "N", 11  , 0 ),
			array("days",      "C", 13      ),
			array("endtype",   "N", 11  , 0 ),
			array("end",       "C", 14      )
			)
		);

Function TWIGCreateDB( $names, $dbpath )
	{
	GLOBAL $dbdefs, $dbnametranslate;

	$j = count( $names );

	for( $i = 0; $i < $j; $i++ )
		{
		$dbnum = $dbnametranslate[trim($names[$i])];
		dbase_create( $dbpath . $names[$i] . ".dbf", $dbdefs[$dbnum] );
		}
	}

Function TWIGPackDB( $names, $dbpath )
	{
	GLOBAL $dbdefs, $dbnametranslate;

	$j = count( $names );
	
	for( $i = 0; $i < $j; $i++ )
		{
		$cdb = dbase_open( $dbpath . $names[$i] . ".dbf", 2 );
		if( !dbase_pack( $cdb ) ) { echo "Failed to pack " . $names[$i] . "!"; } 
		dbase_close( $cdb );
		}
	}

?>

