#include <vector>
#include <ubit/ubit.hpp>
#include <ubit/ext/uctlmenu.hpp>
using namespace std;

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UCtlmenu::UCtlmenu(const UArgs& args) :
  op(null), postponed_op(null)
{
  for (int k = 0; k < 8; k++) actions[k] = null;

  rows[0] = &utrow(utcell() + utcell() + utcell());
  rows[2] = &utrow(utcell() + utcell() + utcell());

  rows[1] = &utrow
    (
     utcell()
     + ulabel(uhcenter() + uvcenter() 
	      + UPix::cross
	      + UOn::mdrag / ucall(this, &UCtlmenu::mdrag)
	      + UOn::mrelease / ucall(this, &UCtlmenu::mrelease)
	      + UOn::enter / ucall(this, &UCtlmenu::reset)
	      + UOn::leave / ucall(this, &UCtlmenu::reset)
	      )
     + utcell()
     );

  addlist
    (
     UBorder::none + UBgcolor::none // transparent by default
     //+ ualpha(0.2) + UBgcolor::black  // translucent menu
     + args
     + utable(*rows[0] + rows[1] + rows[2])
     );

  setSoftwinMode();  // !!

  timer = UAppli::openTimer(0, 0);
  timer->onAction(ucall(this, &UCtlmenu::timeout));
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// we use Freeman code for coding button numbers

void UCtlmenu::setAction(int no, UBox& item, UCtlmenu::Action& a) {
  if (no < 0 || no >= 8) return;

  int r;
  int c;
  switch(no)  {
  case 0: r = 1; c = 2; break;
  case 1: r = 0; c = 2; break;
  case 2: r = 0; c = 1; break;
  case 3: r = 0; c = 0; break;
  case 4: r = 1; c = 0; break;
  case 5: r = 2; c = 0; break;
  case 6: r = 2; c = 1; break;
  case 7: r = 2; c = 2; break;
  }

  rows[r]->remove(c, true);
  rows[r]->insert(c, item);

  actions[no] = &a;
  item.add(UOn::enter / ucall(this, &UCtlmenu::reset));
  item.add(UOn::leave / ucall(this, &a, &UCtlmenu::select));
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UCtlmenu::autoOpens(UBox& opener, u_id buttons, u_id keysym,
                         bool active_on_children) {
  UPopmenu::autoOpens(opener, buttons, keysym, active_on_children);
  // init the control menu
  opener.addAttr(UOn::viewPaint / ucall(this, &UCtlmenu::init));
}

void UCtlmenu::autoOpens(UBox& opener,
                          const vector<InputCond>& _input_conds,
                          bool active_on_children) {
  UPopmenu::autoOpens(opener, _input_conds, active_on_children);
  // init the control menu
  opener.addAttr(UOn::viewPaint / ucall(this, &UCtlmenu::init));
}

/* ==================================================== ======== ======= */

void UCtlmenu::autoOpenImpl(UEvent& e) {
  if (autoOpenCheck(e)) {
    op = null;
    open_source = e.getSource();
    // because we want to center the menu relatively to the mouse position
    // we must calculate the geometry of the menu before it pops up
    u_dim ww = 0, hh = 0;
    getSize(ww,hh);
    move(e, -ww/2, -hh/2);
    open();	// use open(), not show() to open menus!
  }
}

/* ==================================================== ======== ======= */

void UCtlmenu::init() {
  static bool first_time = true;
  if (first_time) {
    first_time = false;
    // this will update the lay out of the menu when the GUI is shown
    // the first time
    open();
    close(0);
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UCtlmenu::reset(UEvent& e) {
  op = null;
  xselect = e.getXwin();
  yselect = e.getYwin();
}

void UCtlmenu::select(UEvent& e, UCtlmenu::Action* _op) {
  op = _op;
  xselect = e.getXwin();
  yselect = e.getYwin();
  if (op) op->select(e, *this);
}

void UCtlmenu::mdrag(UEvent& e) {
  if (op) {
    if (isShown()) op->mdrag(e, *this);
    else op = null;    // securite si jamais le release etait manque
  }
}

void UCtlmenu::mrelease(UEvent& e) {
  close(0);
  if (op) op->mrelease(e, *this);
  open_source = null;
  op = null;
}

void UCtlmenu::timeout(UEvent& e) {
  if (op && postponed_op == op) op->postdrag(e, *this);
  postponed_op = null;
}

void UCtlmenu::postpone(UCtlmenu::Action* a) {
  if (op) {
    postponed_op = a;
    timer->reset(1, 1);  // delay, #times
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
