#include <ubit/ubit.hpp>
#include <ubit/ext/utree.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UNode::UNode(UTreebox& treebox, const UArgs& a) {
	state_btn = ulinkbutton
	(
		utop() + uhcenter() + UFont::bold
		+ UOn::select   / USymbol::down
		+ UOn::unselect / USymbol::right
		+ UOn::select   / ushow(&children, true)
		+ UOn::unselect / ushow(&children, false)
		);
	state_btn->select(true);

	content = uitem
		(
			treebox.content_sel
			+ UOn::select   / ucall(&treebox, this, true, &UTreebox::selectCB)
			+ UOn::unselect / ucall(&treebox, this, false, &UTreebox::selectCB)
			+ a
			);

	addlist(UBgcolor::none + UColor::black + treebox.node_sel
									+ *state_btn + uvbox(*content + children));
}

void UNode::addChild(UNode* n) {
	children.add(n);
	update();
}

void UNode::removeChild(UNode* n) {
	children.remove(n, true);
	update();
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UTreebox::selectCB(UNode* node, bool state) {
	//cerr << "selectCB " << node << " state: " << state << endl;
	if (state) node_sel.setItem(node);
	else if (node_sel.getItem() == node) node_sel.unselect();
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== ======== ======= */


