/* ==================================================== ======== ======= *
 *
 *  unatgraph.hpp  [Native Layer: platform dependent implementation]
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _unatgraph_hpp_
#define	_unatgraph_hpp_
//pragma ident	"@(#)unatgraph.hpp	ubit:03.06.04"
#include <ubit/config.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#ifdef WITH_GL
#  include <GL/gl.h>
#  include <GL/glu.h>
#  include <GL/glx.h>
#endif
#include <ubit/uevent.hpp>
#include <ubit/ucolor.hpp>


typedef union _XEvent*  UX_Event;        // also in uevent.hpp
typedef Display*	UX_Display;
typedef Screen*		UX_Screen;
typedef Visual*		UX_Visual;
typedef XVisualInfo*	UX_VisualInfo;
typedef Colormap	UX_Colormap;
typedef Window		UX_Window;
typedef GC		UX_GC;
typedef XFontStruct*	UX_Font;
typedef Cursor		UX_Cursor;
typedef unsigned long   UX_Color;
typedef Pixmap		UX_Pixmap;
typedef XImage*		UX_Image;
typedef XRectangle	UX_Rectangle;
typedef Atom		UX_Atom;

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */
// sert a catcher les X Errors safely
// usage (att: les { } sont essentiels!)
// {
//    UXtry xtry;
//    xDoTrucQuiPlante();
//    if (!xtry.status()) doOnError();
// }

struct UXtry {
  //NB: pas vraiment thread-safe car xerror doit etre static
  //(mais pas tres grave, le but 1er etant d'eviter des exit intempestifs)
  static int xerror;
  XErrorHandler xhandler;
  static int quietErrorHandler(Display *, XErrorEvent *xer);

  UXtry();
  ~UXtry();
  bool status();
};

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */
//!ATTENTION: les NatGraph sont PARTAGES!
//(en fait il n'y a generalement qu'un seul natgraph pour toute l'appli)

struct UNatGraph {
  UGraph*    graph_lock;
  UX_GC      gc;
  UX_Color   color, bgcolor;
  UX_Font    font;
  short      font_styles, thickness;
  bool       xor_mode;
#ifdef WITH_GL
  GLuint     glFontList;
#endif

  UNatGraph(class UNatDisp*);

  void reset();
  void lock(UGraph*);
  void unlock();
  bool isLocked()     {return (graph_lock != null);}

  UX_GC    getGC()      {return gc;}   // !NB: Implementation dependent
  UX_Color getPixel()   {return color;}
  UX_Color getBgpixel() {return bgcolor;}
  UX_Font  getFont()    {return font;}
#ifdef WITH_GL
  GLuint getGLFontList() {return glFontList;}
#endif
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
