/* ==================================================== ======== ======= *
 *
 *  unatwin.hpp  [Native Layer: platform dependent implementation]
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _unatwin_hpp_
#define	_unatwin_hpp_
//pragma ident	"@(#)unatwin.hpp	ubit:03.06.04"
#include <ubit/config.h>
#include <ubit/unatgraph.hpp>


class UNatWin {
public:
  UNatWin();
  ~UNatWin();

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  void move(class UNatDisp*, u_pos x, u_pos y);
  void resize(class UNatDisp*, u_dim w, u_dim h);
  void show(class UNatDisp*, bool);
  void toBack(class UNatDisp*);
  void toFront(class UNatDisp*);

  /// gets coordinates of the windown in the screen
  void where(class UNatDisp*, u_pos &screen_x, u_pos &screen_y);
  void setTitle(class UNatDisp*, const UStr&);

  /// corresponding X Window
  UX_Window getXWindow() {return xwin;}

  bool isRealized() const {return (xwin != None);}
  static bool realizeMenu(class UNatDisp*,     UNatWin*, UWin*);
  static bool realizeDialog(class UNatDisp*,   UNatWin*, UWin*);
  static bool realizeFrame(class UNatDisp*,    UNatWin*, UWin*);
  static bool realizeMainFrame(class UNatDisp*,UNatWin*, UWin*);
  static bool realizeIncrust(class UNatDisp*,  UNatWin*, UWin*);
  //void reshapeCB(class UNatDisp*, class UView *winview);
  void reshapeCB(class UNatDisp*, class UWin*);

  static void initWinAttributes(class UNatDisp*, XSetWindowAttributes&, 
				unsigned long &wattr_mask);
  void initEventsAndProperties(class UNatDisp*, UWin*);

private:
  friend class UGraph;
  friend class UWinGraph;
  friend class UNatGraph;
  UX_Window xwin;   // corresponding X Window
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
