/* ==================================================== ======== ======= *
 *
 *  ufilebox.cpp
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uufilebox.cpp	ubit:03.05.05"
#include <algorithm>
#include <vector>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>  
#include <dirent.h>
#include <time.h>
#include <ubit/ubit.hpp>
#include <ubit/udir.hpp>
using namespace std;

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UFilebox::showHiddenFiles(bool st) {
	show_hidden_files->select(st);
}

void UFilebox::showDirOnly(bool st) {
	show_dirs_only->select(st);
}

void UFilebox::showList(bool st) {
	show_list->select(st);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UFilebox& ufilebox(const UArgs& a) {return *(new UFilebox(a));}

UFilebox::~UFilebox() {
  // objects are implicitely deleted as they are filebox children
}

UFilebox::UFilebox(const UArgs& args) {
  viewport = null;
  fdir = "./";  // => scan du directory courant
  ffilter = "*.*";

  setCmodes(UMode::HAS_CLOSE_MENU_MODE, true);
  setCmodes(UMode::CLOSE_MENU_MODE, false);

  UButton& ok = ulinkbutton
    (
     //UOrient::horizontal +
     UPix::check/*ray*/
     + UFont::bold + "OK"
     + UOn::action / ucallref(this,fname,&UFilebox::okBehavior)
     );
  ok.setCmodes(UMode::HAS_CLOSE_MENU_MODE|UMode::CLOSE_MENU_MODE, true);

  UButton& cancel = ulinkbutton
  (
   //UOrient::horizontal +
   UPix::cross + "Cancel"
   + UOn::action / ucall(this,&UFilebox::cancelBehavior)
   );
  cancel.setCmodes(UMode::HAS_CLOSE_MENU_MODE|UMode::CLOSE_MENU_MODE, true);

  show_list = &ubutton
  (
   UMode::canSelect
   + UFont::small + "List"
   + UOn::action / ucall(this, &UFilebox::rescan)
   );
  
  show_hidden_files = &ubutton
  (
   UMode::canSelect
   + UFont::small + "All"  //+ UPix::rball
   + UOn::action / ucall(this, &UFilebox::rescan)
   );

  show_dirs_only = &ubutton
  (
   UMode::canSelect
   + UFont::small + UPix::folder
   + UOn::action / ucall(this, &UFilebox::rescan)
   );

  UBox &tbar = ubar
    (
     UBorder::none
     + uleft() + uhspacing(5) + uhmargin(4) + uvmargin(2)
     + uitem(uvcenter() +UBorder::none           // PARENT Dir
             + UFont::x_large + USymbol::up
             + UOn::action / ucall(this, &ustr(".."), &UFilebox::changeDir)
             )
     + uitem(uvcenter() +UBorder::none                         // HOME Dir
             + UFont::x_large + USymbol::right
             + UOn::action / ucallref(this, ustr("./"), &UFilebox::setDir)
             )
     + uhflex()
     + utextbox(UBgcolor::white + uhflex()        //CURRENT Dir
                + uedit() + UPix::ofolder + " " + fdir
                //ca va pas: on reappellerait rescan a tort et a travers
                // des qu'on reformatte fdir
                //+ ucall(this, &UFilebox::rescan, UOn::change)
                + UOn::ktype / ucall(this, &UFilebox::rescan)
                )
     + uright()
     + show_list
     + show_hidden_files
     // + show_dirs_only
     );

  scrollpane = &uscrollpane
    (
     UAppli::getDefaults().filebox_width
     + UAppli::getDefaults().filebox_height
     // + uheight(UHeight::keepSize) + UBorder::etchedIn
     + UBgcolor::white
    );

  // chaque fois que le filtre est modifier, soit interactivement, 
  // soit par appel de la fct. setFilter(), on rescanne la liste
  ffilter.onChange( ucall(this, &UFilebox::rescan) );

  UBox &controls = uhbox
    (
     uvflex()
     + uvbox(UValign::center + ulabel("File Name:") + ulabel("Filters:"))
     + uhflex()
     + uvbox(uvspacing(3)
             + utextbox(UBgcolor::white + uedit()
                        + fname
                        + UOn::action / ucallref(this,fname,&UFilebox::okBehavior))
             // NB: ffilter est reactif et associe a rescan() (cf plus haut)
             + utextbox(UBgcolor::white + uedit() + ffilter)
             )
     + uright()
     //+ubar(UOrient::vertical + UBorder::none + uvmargin(0) + ok + cancel)
     + uvbox(ok + cancel)
     );

  addlist
  (
   UOrient::vertical + uhflex() + uvspacing(4) + uhmargin(4)
   //uhflex() + uvflex()
   //+ uvbox(uhmargin(4) + uvmargin(3) + uvspacing(4)
   //        + uhflex()
   + utop() + tbar
   + uvflex()  + scrollpane
   + ubottom() + controls
   //)
   + args  //pbm place des args!
  );

  viewport = null;
  rescan();   //devrait etre a l'apparition du dialog
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// separer le chemin et du repertoire et le reste (remain) qui
// servira de filtre
// -- reduit s_dir si necessaire : enleve filter et / final
// -- renvoie nouvelle longueur de s_dir
// -- met le filter dans *sremain si sremain!= null
//    (il faudra faire un delete de *sremain si != null)

static int separ(char *s_dir, char **s_remain) {
  int l_dir = strlen(s_dir);
  if (s_remain) *s_remain = null;

  //chercher si dir se termine par un / (et l'enlever)
  if (s_dir[l_dir-1] == '/') {
    if (l_dir > 1) {   // ne pas enlever le / de la racine
      s_dir[l_dir-1] = 0;  //securite pour opendir() si / final pas admis
      l_dir--;
    }
  }
  else {  // chercher le / du parent
    char *p = strrchr(s_dir, '/');
    //s_remain = ce qui reste apres le dernier /
    if (p) {
      if (s_remain) {
        *s_remain = new char [strlen(p)];
        strcpy(*s_remain, p+1);
      }

      //!att: ne pas enlever le / de la racine
      if (p > s_dir) *p = 0;
      else *(p+1) = 0;
      l_dir = strlen(s_dir);  // la taille a change!
    }
  }

  return l_dir;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// new_path is relative except if starting by a /
// cette fonction reinitialise fdir sauf si arg null ou == fdir

void UFilebox::changeDir(UStr *argpath_str) {  
  const char* argpath = argpath_str ? argpath_str->chars() : null;

  if (argpath && argpath[0] == '/') {      // new_path is absolute
    setDir(*argpath_str);
  }
  
  else {			// new_path is relative
    UStr newpath = fdir;
    if (newpath.empty()) newpath = "/";

    if (!argpath || !argpath[0])
      /*nop*/;

    else if (strcmp(argpath, "..")==0 || strcmp(argpath, "../")==0) {
      // trouver le path du parent (et skip du dernier /)
      int ll = newpath.length();
      //char *pc = null;
      int ix = -1;
      
      if (ll > 0) {
	// newpath[ll-1] = 0;
        newpath.remove(-1, 1);
	//pc = strrchr(newpath, '/');
        ix = newpath.rfind('/');
      }
      
      //if (pc) *(pc+1) = '\0';       // garder le /
      if (ix >= 0) newpath.remove(ix+1, UStr::npos);
      else newpath = "/";    // racine
    }

    else { //ajouter le subdirectory
      //concatener (mais apres avoir enleve un filtre eventuel)
      int ll = separ((char*)newpath.chars(), null);

      char *pc = new char[ll + strlen(argpath) + 4];
      sprintf(pc, "%s/%s/", newpath.chars(), argpath);
      //delete newpath;
      newpath = pc;
    }
    
    // ne pas oublier de remettre a jour fdir
    fdir = newpath;
    //delete newpath;
    rescan();
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UFilebox::rescan() {
  bool want_list = show_list->isSelected();
  bool want_hidden_files = show_hidden_files->isSelected();
  bool want_normalfiles = ! show_dirs_only->isSelected();

  // on repositionne les items dans tous les cas
  scrollpane->setScroll(0,0);

  // detruire l'ancien viewport (do not redisplay)
  if (viewport) scrollpane->remove(viewport, true, false);

  // creer le nouveau contenu du Filebox
  viewport = &uhbox(uhmargin(3) + uvmargin(3) + uhspacing(3)+ uvspacing(3));
  scrollpane->add(viewport, false); // no update

  UStr dirpath = fdir.getFileDir(true); 
  UStr prefix  = fdir.getFileName(true);
		
  UDir dir(dirpath, prefix, ffilter, want_hidden_files);

  //NB: UDir normalise dirpath qui peut donc avoir change
  fdir = dir.getPath() & prefix;  // !!

  if (want_list) {     // vertical list with attributes
    UBox* col =
      &utable(uhmargin(3) + uvmargin(3) + uhspacing(3)+ uvspacing(1));
    viewport->add(col, false);  // no update

    int n = 0;
    for (u_int k = 0; k < dir.getFileCount(); k++) {
      UDir::Entry* e = dir.getFileEntry(k);

      if (e->isDir()) {	// cas directory
	UArgs call = UOn::action / ucall(this, e->getName(), &UFilebox::changeDir);
	col->add
	  (
	   utrow(uitem(new_sel + call + e->getSmallIcon())
		 + uitem(new_sel + call + e->createModeStr())
		 + uitem(new_sel + call + e->createSizeStr())
		 + uitem(new_sel + call + e->createTimeStr())
		 + uitem(new_sel + call + UFont::bold + e->getName())
		 ),
	   false);
	n++; 
      }
      else if (want_normalfiles) {    // cas ordinary file or whatever
	// NB:UOn::select la cond la plus appropriee car :
	// - selectBehavior fires select
	// - pas de rappel si meme btn clique  plusieurs fois
	// - coherent si selection changee par programme (typiquement via
	//   le USelect) et non par l'utilisateur

	UArgs calls = //UOn::select / usetref(&fname, *e->getName())
	  UOn::select / ucallref(this,*e->name,&UFilebox::selectBehavior)
	  + UOn::mbiclick/ ucallref(this,*e->name,&UFilebox::okBehavior);

	col->add
	  (
	   utrow(uitem(new_sel + calls + e->getSmallIcon()) 
		 + uitem(new_sel + calls + e->createModeStr())
		 + uitem(new_sel + calls + e->createSizeStr())
		 + uitem(new_sel + calls + e->createTimeStr())
		 + uitem(new_sel + calls + UFont::bold + e->getName())
		 ),
	   false);
	n++; 
      }
    } //endfor(int k)
  } //endif(want_attributes)

  else {   // no attributes -> matrix
    UVbox* col = &uvbox();  //premiere colonne verticale du viewport
    viewport->add(col, false);

    int n = 0;
    for (u_int k=0; k < dir.getFileCount(); k++) {
      UDir::Entry* e = dir.getFileEntry(k);

      if (e->isDir()) {	// cas directory
	col->add
	  (
	   uitem(new_sel + e->getSmallIcon() 
		 + e->getName()
		 + UOn::action / ucall(this,e->getName(),&UFilebox::changeDir)),
	   false);
	n++; 
      }
    
      else if (want_normalfiles) {    // cas ordinary file or whatever
	// NB:UOn::select la cond la plus appropriee car :
	// - selectBehavior fires select
	// - pas de rappel si meme btn clique  plusieurs fois
	// - coherent si selection changee par programme (typiquement via
	//   le USelect) et non par l'utilisateur
	col->add
	  (
	   uitem(new_sel + e->getSmallIcon()
		 + e->getName()
		 //+ UOn::select / usetref(&fname, *e->getName())
		 + UOn::select / ucallref(this,*e->name,&UFilebox::selectBehavior)
		 + UOn::mbiclick/ ucallref(this,*e->name,&UFilebox::okBehavior)
		 ),
	   false);
	n++; 
      }
      
      // nouvelle colonne verticale
      if (!want_list && n % UAppli::getDefaults().filebox_line_count == 0) {
	col = &uvbox();
	viewport->add(col, false);
      }
    } //endfor(int k)
  } //endelse(want_attributes)

  scrollpane->update();
}

/* ==================================================== ======== ======= */

void UFilebox::selectBehavior(UEvent& e, const UStr& filename) {
  fname = filename;
  e.setID(UEvent::select);
  e.setAux(e.getSource());  // new
  fire(e, UOn::select);
}

void UFilebox::okBehavior(UEvent& e, const UStr& filename) {
  closeWin(1);   // return 1 to lock()
   e.setAux(e.getSource());  // new
  fire(e, UOn::action);
}

void UFilebox::cancelBehavior(UEvent& e) {
  closeWin(0);  // return 0 to lock()
}

/* ==================================================== ======== ======= */

void UFilebox::setName(const UStr&s) {
  fname = s;
}

void UFilebox::setDir(const UStr&s) {
  fdir = s;
  // rajouter un / a la fin si necessaire
  if (fdir.charAt(-1) != '/') fdir.append("/");
  rescan();
}

void UFilebox::setFilter(const UStr&s) {
  ffilter = s;
}

const UStr& UFilebox::getFilter() const {
  return ffilter;
}

const UStr& UFilebox::getName() const {
  return fname;
}

const UStr& UFilebox::getDir() const {
  // il faut enlever ce qui suit le / dans fdir
  fdir2 = fdir.getFileDir(true);  // with final slash
  return fdir2;

  /* complement FAUX : detruit l'item sur lequel on est
     peut etre en train de double cliquer !

  //virer ce qui se trouve apres le / (sert de filtre)
  //(sinon les pathnames seront incorrects: il y aura le filtre!)
  const char* slash = strrchr(fdir->chars(), '/');
  if (slash && *++slash != 0) {
    int pos = slash - fdir->chars();
    fdir->remove(pos, fdir->length() - pos);
    //remettre a jour la liste puisque fdir a change
    //en fait ca devrait plutot etre qd le dialog reapparait
    const_cast<UFilebox*>(this)->rescan();
  }
  return *fdir;
  */
}

const UStr& UFilebox::getPath() const {
  fpath = getDir();
  fpath.append(fname);
  return fpath;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

