/* ==================================================== ======== ======= *
 *
 *  uunumber.cc
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uunumber.cc	ubit:03.02.00"
//#include <ctype.h>
#include <stdlib.h>     
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uerror.hpp>
#include <uctrl.hpp>
#include <ustr.hpp>
#include <uevent.hpp>
#include <unumber.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UIntgBase::UIntgBase(const UFloatBase& val) {
  value = int(val.getValue());                // conversion to int !
}

UIntgBase::UIntgBase(const UStr& val) {
  value = 0;
  set(val);
}

/* ==================================================== ======== ======= */

void UIntgBase::set(int _n) {
  if (equals(_n)) return;
  value = _n;
  changed(true);
}

void UIntgBase::set(const UIntgBase& _n) {
  if (equals(_n)) return;
  value = _n.value;
  changed(true);
}

void UIntgBase::set(const UFloatBase& _n) {
  if (equals(_n)) return;
  value = int(_n.getValue());                // conversion to int !
  changed(true);
}

void UIntgBase::set(const UStr&_s) {
  if (!_s.chars()) {
    UError::error("warning@UIntgBase::set", UError::Null_argument); return;
  }
  set(strtol(_s.chars(), null, 0)); 
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UIntgBase::incr(int _n) {
  if (_n == 0) return;
  value += _n;
  changed(true);
}

void UIntgBase::incr(const UIntgBase& _n) {
  if (_n.value == 0) return;
  value += _n.value;
  changed(true);
}

void UIntgBase::decr(int _n) {
  if (_n == 0) return;
  value -= _n;
  changed(true);
}

void UIntgBase::decr(const UIntgBase& _n) {
  if (_n.value == 0) return;
  value -= _n.value;
  changed(true);
}
/* ==================================================== ======== ======= */

bool UIntgBase::equals(const UFloatBase& v) const {
  return value == v.getValue();
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UIntg::onChange(UCall& c) {
  addChangeCall(c);
}

void UIntg::changed(bool update_now) {
  //cerr << "UIntg::changed" << endl;
  //  if (update_now && (bmodes & UMode::NO_AUTO_UPDATE) == 0)  update();

  UEvent e(UEvent::change,  null, null, NULL);
  e.setAux(this);

  if (cache) fire(e, UOn::change);

  // ensuite on lance les callbacks des parents
  // parents.fireParents(e, UOn::propChange);
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UFloatBase::UFloatBase(const UStr& val) {
  value = 0;
  set(val);
}

/* ==================================================== ======== ======= */

void UFloatBase::set(float _n) {
  if (equals(_n)) return;
  value = _n;
  changed(true);
}

void UFloatBase::set(const UIntgBase&_n) {
  if (equals(_n)) return;
  value = _n.getValue();
  changed(true);
}

void UFloatBase::set(const UFloatBase&_n) {
  if (equals(_n)) return;
  value = _n.value;
  changed(true);
}

void UFloatBase::set(const UStr&_s) {
  if (!_s.chars()) {
    UError::error("warning@UFloatBase::set", UError::Null_argument); return;
  }
  set(strtod(_s.chars(), null));	// ! atof
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UFloatBase::incr(float _n) {
  if (_n == 0) return;
  value += _n;
  changed(true);
}

void UFloatBase::incr(const UFloatBase& _n) {
  if (_n.value == 0) return;
  value += _n.value;
  changed(true);
}

void UFloatBase::decr(float _n) {
  if (_n == 0) return;
  value -= _n;
  changed(true);
}

void UFloatBase::decr(const UFloatBase &_n) {
  if (_n.value == 0) return;
  value -= _n.value;
  changed(true);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UFloat::onChange(UCall& c) {
  addChangeCall(c);
}

void UFloat::changed(bool update_now) {
  // if (update_now && (bmodes & UMode::NO_AUTO_UPDATE) == 0) update();

  UEvent e(UEvent::change,  null, null, NULL);
  e.setAux(this);

  if (cache) fire(e, UOn::change);

  // ensuite on lance les callbacks des parents
  // parents.fireParents(e, UOn::propChange);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
