/* ==================================================== ======== ======= *
 *
 *  serial_mouse.hh : serial mouse driver (logitec 3 btns) for the UMS.
 *
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet (adapted from code by Thierry Duval / IRISA Siames)
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _serial_mouse_hpp
#define	_serial_mouse_hpp
#include "umssource.hpp"
#include "umsflow.hpp"

/* ==================================================== ======== ======= */
/**
 * Serial Mouse event source.
 */
class UMSserialMouseSource : public UMSeventSource {
public:
  UMSserialMouseSource(class UMSmouseFlow*, const char* port_name);
  virtual ~UMSserialMouseSource();

  virtual int open(const char* port_name);  
  ///< returns filedesc ; can be used to reopen the port

  virtual void close();
  virtual bool read();

private:
  class UMSmouseFlow& mflow;
  bool is_init;                // mouse reader initialized
  bool is_b1_pressed, is_b2_pressed, is_b3_pressed;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
