/* @(#) Function which returns an int.  This integer is the threshold 
 * @(#) above which there are percent values of the input images
 * @(#)  If for instance precent=.1, the number of pels of the input image
 * @(#) with values greater than the returned int will correspond to
 * @(#) 10% of all pels of the image.
 * @(#) One band IM_BANDFMT_UCHAR images only.
 * @(#)
 * @(#) Function im_mpercent() assumes that input
 * @(#) is either memory mapped or in a buffer.
 * @(#)
 * @(#) int im_percent(in, percent)
 * @(#) IMAGE *in;
 * @(#) double percent;
 * @(#)
 * @(#) Returns 0 on success and -1 on error
 *
 * Copyright: 1990, N. Dessipris
 *
 * Author: N. Dessipris
 * Written on: 02/08/1990
 * Modified on : 29/4/93 K.Martinez   for Sys5
 * 20/2/95 JC
 *	- now returns result through parameter
 *	- ANSIfied a little
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <stdio.h>
#include <string.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Prints percent of the max values of the input image
 */
int
im_mpercent( IMAGE *in, double percent, int *out )
{	
	PEL *p;
	int hist[ 256 ];
	double dhist[ 256 ];
	double sum;
	gint64 s, i;

/* Check args: input must be memory mapped or in buffer */
	if( im_incheck( in ) )
		return( -1 );
	if( in->Bands != 1 || in->Bbits != 8 || in->Coding != IM_CODING_NONE || 
		in->data == NULL || in->BandFmt != IM_BANDFMT_UCHAR ) { 
		im_errormsg( "im_percent: 1 band uncoded uchar only" ); 
		return( -1 ); 
	}
	if( percent < 0.0 || percent > 1.0 ) {
		im_errormsg( "im_percent: percent %g should be between "
			"0 and 1", percent );
		return( -1 );
	}

/* Number of PELs */
	s = (gint64) in->Xsize * in->Ysize;

/* Make hist.  */
	memset( (char*)hist, 0, 256 * sizeof( int ) );
	for( p = (PEL *) in->data, i = 0; i < s; i++ )
		hist[ *p++ ]++;

/* Turn into normalised hist.  */
	for( i = 0; i < 256; i++ )
		dhist[ i ] = (double) hist[i]/(double)s;

/* find thresh for the corresponding percent */
	sum = 0.0;
	for( i = 255; i >= 0; i-- ) {
		sum += dhist[i];
		if( sum >= percent ) 
			break;
	}
	*out = i;

	return( 0 );
}
