/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "getNameDirController.h"

@implementation GetNameDirController

- (id) initWithRemote: (BOOL) ptype
{
	GetNameWindow* theWindow;
	theWindow = [[GetNameWindow alloc] initWithContentRect: NSMakeRect (300,300,300,70)
				styleMask: 	(NSTitledWindowMask |
						NSClosableWindowMask |
						NSMiniaturizableWindowMask)
				backing: NSBackingStoreBuffered
				defer: YES];
	[super initWithWindow: theWindow];
	[theWindow layoutWindow];
	[theWindow setDelegate: self];
	
	name = [theWindow name];
	go = [theWindow go];
	type = ptype;

	[name setNextKeyView: go];
	[go setNextKeyView: name];

	[[self window] setTitle: @"Create Directory"];
	return self;
}

- (void) dealloc
{
}

- (IBAction) makedir: (id) sender
{
	NSLog (@"On est dans le makedir ... \n");	
	NSLog (@"Nom du repertoire : %@\n", [name stringValue]);
	[self close];
	if (type) // Remote directory
	{
		NSMutableString* str = AUTORELEASE ([[NSMutableString alloc] initWithString: @"MKD "]);
		[str appendString: [[[NSApp delegate] window] remotePath]];
		[str appendString: @"/"];
		[str appendString: [name stringValue]];
		NSLog (@"on envoie au ftp la commande : %@\n", str);
		[[[NSApp delegate] ftp] command: str];
		[[[NSApp delegate] window] refreshRemote];
	}
	else
	{
		// local
		NSMutableString* str = AUTORELEASE ([[NSMutableString alloc] initWithString: 
			[[[NSApp delegate] window] localPath]]);
		[str appendString: @"/"];
		[str appendString: [name stringValue]];
		NSLog (@"on veut creer le repertoire %@\n", str);
		mkdir ([str cString], 0700);
		[[[NSApp delegate] window] refreshLocal];
	}
}


@end
