#ifndef SEQUENTIAL_CONFIGURATION_MANAGER_H
#define SEQUENTIAL_CONFIGURATION_MANAGER_H

// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "ConfigurationManager.h"
#include "EventSetFactory.h"
#include "SequentialSimulationManager.h"

class Application;

/** The SequentialConfigurationManager class.

    The SequentialConfigurationManager class represents the concrete
    class that is responsible for constructing and configuring a
    Sequential Simulation Manager and its components.
*/
class SequentialConfigurationManager : public ConfigurationManager {
public:

   /**@name Public Class Methods of SequentialConfigurationManager */
   //@{

   /// Default constructor
   SequentialConfigurationManager( Application *initApplication );
   
   /// Default destructor
   ~SequentialConfigurationManager();

  /** 
      configure the sequential simulation manager.
  */
  void configure( SimulationConfiguration &configuration );

  vector<Configurer *> &getConfigurers() const;

  /**
     Gets the simulation manager for this configuration.
     
     @return The Simulation Manager;
  */
  SimulationManager *getSimulationManager();
  
  //@} // End of Public Class Methods of SequentialConfigurationManager

protected:

   /**@name Protected Class Attributes of SequentialConfigurationManager */
   //@{

   /// handle to the sequential simulation manager
   SequentialSimulationManager *const mySimulationManager;

   /// handle to the event set factory
   EventSetFactory *myEventSetFactory;
   
   //@} // End of Protected Class Attributes of SequentialConfigurationManager
   
};
#endif
