/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "dialog.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "application.h"
#include "rootwindow.h"
#include "mixer.h"
#include "font.h"

#include <sigc++/object_slot.h>

namespace wftk {

Dialog::HighStack Dialog::highest_;

Dialog::Dialog() :
  SingleContainer(0, 0, 0, 0),
  open_(false)
{
  // want an opaque background
  Color back_color = color();
  if(back_color.a == SDL_ALPHA_TRANSPARENT)
    setColor(Color(0, 0, 0));
  else if(back_color.a != SDL_ALPHA_OPAQUE) { 
    back_color.a = SDL_ALPHA_OPAQUE;
    setColor(back_color);
  }

  getResourceBackground("dialog");
}

Dialog::~Dialog()
{
  if(open_)
    close();
}

void
Dialog::exec(ScreenArea *root, bool blocking, bool modal)
{
  if(!root)
    root = RootWindow::instance();

  if(open_) {
    if(parent() == root)
      return;
    else
      close();
  }

  setParent(root);
  if(modal) // add to the front of the input locking list
    highest_.insert(highest_.begin(), this);
  raise();
  Mixer::instance()->playSample("open"); 

  open_ = true;

  if(blocking)
    {
      //local event loop
      //      Debug::out << "entering local eventloop ..."<<Debug::endl;

      ref();
      Application::instance()->waitFor(open_, false);

      // we don't drop the reference we just created

      // Blocking dialogs are usually declared on the stack, so we
      // don't want to auto-delete them. Adding a reference fixes
      // that.
      //Debug << "leaving local eventloop ..." << Debug::endl;
    }

  // Don't do anything after this, the dialog may have been deleted.

  //Debug << "returning from exec() " << Debug::endl;
}

void Dialog::packingUpdateParent()
{
  // since Dialog is essentially the root of its own packing
  // structure (i.e., a dialog's size doesn't affect how RootWindow's
  // other children are packed), we now resize Dialog based on the
  // new packing info.

  Rect r;

  r.w = packing_info_.x.pref;
  r.h = packing_info_.y.pref;

  if(parent()) {
    if(r.w > parent()->width())
      r.w = parent()->width();
    if(r.w < packing_info_.x.min) {
      r.w = packing_info_.x.min;
      r.x = 0;
    }
    else
      r.x = (parent()->width() - r.w) / 2;

    if(r.h > parent()->height())
      r.h = parent()->height();
    if(r.h < packing_info_.y.min) {
      r.h = packing_info_.y.min;
      r.y = 0;
    }
    else
      r.y = (parent()->height() - r.h) / 2;
  }

  resize(r);
}

void Dialog::close()
{
  if(!open_)
    return;

  open_ = false;
  done();

  setParent(0);
  Mixer::instance()->playSample("close");

  HighStack::iterator I;
  for(I = highest_.begin(); I != highest_.end(); ++I) {
    if(*I == this) {
      highest_.erase(I);
      return;
    }
  }

  // if we get this far, we've got a non-modal dialog
}

}

