/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2003 Ron Steinke <rsteinke@w-link.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "videowidget.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include "debug.h"

#include <sigc++/object_slot.h>

#include "application.h"

wftk::VideoWidget::VideoWidget()
{
  assert(Application::instance());
  setPackingInfo();
  Application::instance()->update.connect(SigC::slot(*this,
	&VideoWidget::updateExposeMask));
}

bool wftk::VideoWidget::load(const std::string& filename, double scale)
{
  if(!Video::load(filename, scale))
    return false;
  packingUpdate();
  return true;
}
 
void wftk::VideoWidget::handleResize(Uint16 w, Uint16 h)
{
  Debug out(Debug::PACKING);
  Point new_loc = screenRect().origin();
  out << "Moving video to location " << new_loc << " in root window" << Debug::endl;
  Video::move(new_loc);
  Video::setMask(ScreenArea::getExposed());
  Rect video(0, 0, Video::width(), Video::height());
  out << "Setting video widget shape to " << video << Debug::endl;
  ScreenArea::setShape(video, video);
}

void wftk::VideoWidget::setPackingInfo()
{
  packing_info_.x.expand = packing_info_.y.expand = false;
  packing_info_.x.min = packing_info_.x.pref = Video::width();
  packing_info_.y.min = packing_info_.y.pref = Video::height();
}
