// $Id: ETNew.h,v 1.2 2002/02/17 00:27:04 nekeme Exp $
#ifndef WE_ETNEW_H

#include "EntityTool.h"
#include "Command.h"

/// Entity Tool: new
class ETNew : public EntityTool
{
      Entity *m_Entity;
      Entity *GetEntity();

  public:
      ETNew (World *world);
      virtual ~ETNew();
      
      /// Apply tool at (x,z)
      virtual void Apply3D (Ark::Vector3 newpos, const Ark::Collision &col);
      
      /// Update or reset tool
      virtual void Update();
      
   public:
      /// Create a command with a correct state.
      virtual Command* CreateCommand();
};

class ETDelete : public EntityTool
{
      Entity *m_Entity;
 
   public:
      ETDelete (World *world);
      virtual ~ETDelete ();
      
      /// Apply tool at (x,z)
      virtual void Apply3D (Ark::Vector3 newpos, const Ark::Collision &col);
      
   public:
      /// Create a command with a correct state.
      virtual Command* CreateCommand();	
};

/// Entity command: new or delete.
class ECNewDelete : public Command
{
      World *m_World;
      Entity *m_Entity;
      bool m_Delete;

   public:
      ECNewDelete (World *world, Entity *entity,
		   bool deletecmd = true);
      virtual ~ECNewDelete();

      /// Return the command type.
      virtual std::string Type() const;

      /// Execute this command.
      virtual void Execute();

      /// Undo the action done by this command.
      virtual void Unexecute();
};

#endif
