// $Id: ETRotate.h,v 1.1 2003/02/08 13:14:51 mrq Exp $
#ifndef WE_ETROTATE_H

#include "EntityTool.h"
#include "Command.h"

class ETRotate : public EntityTool
{
      Entity *m_Entity;
      Ark::Vector3 m_NewPos, m_OldPos;
      Ark::Quat m_NewRot, m_OldRot;

  public:
      ETRotate (World *world);
      virtual ~ETRotate();
      
      /// Apply tool at (x,z)
      virtual void Apply3D (Ark::Vector3 newpos, const Ark::Collision &col);
      
      /// Update or reset tool
      virtual void Update();
      
   public:
      /// Create a command with a correct state.
      virtual Command* CreateCommand();
};

/// Entity command: move
class ECRotate : public Command
{
      World *m_World;
      Entity *m_Entity;
      Ark::Quat m_NewRot, m_OldRot;

   public:
      ECRotate (World *world, Entity *entity, Ark::Quat newrot);
      virtual ~ECRotate();

      /// Return the command type.
      virtual std::string Type() const;

      /// Execute this command.
      virtual void Execute();

      /// Undo the action done by this command.
      virtual void Unexecute();
};

#endif

