/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44Defs_H
#define	JT44Defs_H

// For the DSP part
const int JT44_SAMPLE_RATE    = 11025;
const int JT44_SYMBOL_LENGTH  = 2048;
const int JT44_FFT_LENGTH     = JT44_SYMBOL_LENGTH;

const int JT44_MAX_AUDIO_DATA = 30 * JT44_SAMPLE_RATE;

const double JT44_SEND_VOLUME = 0.5;

const int JT44_SYNCBIN_FIRST = 124;	// 668 Hz
const int JT44_SYNCBIN_LAST  = 348;	// 1873 Hz

const double JT44_SYNC_POS_COEFF =  1.0;
const double JT44_SYNC_NEG_COEFF = -1.0;

const int JT44_SKIP_FACTOR = 512;	// For the preliminary correlation
const int JT44_SKIP_RATE   = JT44_SYMBOL_LENGTH / JT44_SKIP_FACTOR;

const int JT44_MESSAGE_LENGTH     = 22;
const int JT44_MESSAGE_REPITITION = 3;
const int JT44_ALPHABET_COUNT     = 43;

const int JT44_SOUNDBUF_LENGTH = 2048;

// For the GUI
const wxString JT44_LOGFILE_NAME  = wxT("jt44");
const wxString JT44_LOGFILE_EXT   = wxT("log");
const wxString JT44_MESSAGES_NAME = wxT("jt44");
const wxString JT44_MESSAGES_EXT  = wxT("cum");

const wxString title = wxT("JT44 (WS Tools 0.4.8d)");

const int JT44_MAX_MESSAGES   = 6;

const int JT44_GRAPH_WIDTH     = 570;
const int JT44_AUDIO_WIDTH     = 25;
const int JT44_GRAPH_HEIGHT    = 125;
const int JT44_MESSAGES_WIDTH  = 600;
const int JT44_MESSAGES_HEIGHT = 150;
const int JT44_AVERAGES_HEIGHT = 50;
const int JT44_MOON_HEIGHT     = 305;

// For the configuration
const wxString JT44_VENDOR_NAME = wxT("G4KLX");
const wxString JT44_APPL_NAME   = wxT("JT44");

#endif
