//XChat Events Listener
#include "events.h"
/*
#ifndef _WIN32_
	//notify icons
	#include "images/GTKTray/xchatpng.h"
	#include "images/GTKTray/xchatredpng.h"
	#include "images/GTKTray/xchatbluepng.h"
	#include "images/GTKTray/xchatdccxpm.h"
	#include "images/GTKTray/xchatdiscxpm.h"
	#include "images/GTKTray/xchatinvxpm.h"
	#include "images/GTKTray/xchatnotoutxpm.h"
	#include "images/GTKTray/xchatnotinxpm.h"
#endif
// EVENTS HANDLING AND FLASHING
*/
//set flashing icon
gboolean flash_timeout(gpointer userdata) 
{

	static int i = 0;

	i++;
	if (i == 2) 
	{
		i = 0;
		if (global_away) 
			update_tray(pix_xchat_away,motivation);
		else 
			update_tray(pix_xchat,motivation);
	}
	else update_tray(icontype,motivation);
	return TRUE;

}

//make flash start
void flash_start() 
{
	if (flash_id == 0) 
		flash_id = g_timeout_add(flash_interval, flash_timeout, NULL);
}

//stop flash
void flash_stop() {

	if(flash_id)
	{
		if (global_away) update_tray(pix_xchat_away,"XChat2 - Nothing Particular");
		else update_tray(pix_xchat,"XChat2 - Nothing Particular");
		g_source_remove(flash_id);
		flash_id = 0;
	}
}

//on hilight
int noti_hilight_cb(char *word[], void *userdata) 
{
	if(highlight)
	{
		if(xchat_get_context(ph) != focus_ctx || !status)
		{
			flash_ctx = xchat_get_context(ph);
			icontype=pix_xchat_blue;
			motivation="XChat2 - Somebody asked for you";
			flash_start();
		}
	}

	return XCHAT_EAT_NONE;

}

//find focus
int noti_focus_cb(char *word[], void *userdata) 
{
	focus_ctx = xchat_get_context(ph);

	if(focus_ctx == flash_ctx)
		flash_stop();

	return XCHAT_EAT_NONE;
}

//on query
int query_cb(char *word[],  void *userdata) 
{

	if (query)
	{
		if ( xchat_get_context(ph) != focus_ctx ||!status )
		{
			flash_ctx = xchat_get_context(ph);
			icontype=pix_xchat_blue;
			motivation="XChat2 - Somebody send you a message";
			flash_start();
		}
	}

        return XCHAT_EAT_NONE;
}

//on disconnection
int disconnect_cb(char *word[], void *userdata) {

	if(disconnection)
	{
		if ( xchat_get_context(ph) != focus_ctx ||!status )
		{
			flash_ctx = xchat_get_context(ph);
			icontype=pix_xchat_disc;
			motivation="XChat2 - Disconnected from server";
			flash_start();
			
		}
	}

        return XCHAT_EAT_NONE;
}

//on kick/ban
int kicked_cb(char *word[], void *userdata) {

	if(kick)
	{
		if ( xchat_get_context(ph) != focus_ctx ||!status )
		{
			flash_ctx = xchat_get_context(ph);
			icontype=pix_xchat_red;
			motivation="XChat2 - You have been kicked";
			flash_start();
		}
	}

        return XCHAT_EAT_NONE;
}

//on kill
int killed_cb(char *word[], void *userdata) {

	if (killevent) 
	{
		if ( xchat_get_context(ph) != focus_ctx ||!status )
		{
			flash_ctx = xchat_get_context(ph);
			icontype=pix_xchat_red;
			motivation="XChat2 - You have been killed";
			flash_start();

		}
	}

        return XCHAT_EAT_NONE;
}

//on dcc char request
int chatreq_cb(char *word[], void *userdata) {

	if(dcc_chat) 
	{
		flash_ctx = xchat_get_context(ph);
		icontype=pix_xchat_dcc;
		motivation="XChat2 - Somebody offering a dcc chat to you";
		flash_start();
	}

        return XCHAT_EAT_NONE;
}

//on dcc send/ dcc event
int dcc_cb(char *word[], void *userdata) {

	if(dcc_send) 
	{
		flash_ctx = xchat_get_context(ph);
		icontype=pix_xchat_dcc;
		motivation="XChat2 - Somebody offering a dcc to you";
		flash_start();
	}

        return XCHAT_EAT_NONE;
}

//on invite
int invited_cb(char *word[], void *userdata) {

	if (invite)
	{
		if ( xchat_get_context(ph) != focus_ctx ||!status ) 
		{
			flash_ctx = xchat_get_context(ph);
			icontype=pix_xchat_inv;
			motivation="XChat2 - Somebody invited you to a channel";
			flash_start();
		}
	}

        return XCHAT_EAT_NONE;
}

// friend away from notify
int notout_cb(char *word[], void *userdata) {

	if (notify_list)
	{
		if ( xchat_get_context(ph) != focus_ctx ||!status ) 
		{
			flash_ctx = xchat_get_context(ph);
			icontype=pix_xchat_notout;
			motivation="XChat2 - A friend went away";
			flash_start();
		}
	}

        return XCHAT_EAT_NONE;
}

//a new friend in notify
int notin_cb(char *word[], void *userdata) {

	if (notify_list)
	{
		if ( xchat_get_context(ph) != focus_ctx ||!status ) {
			flash_ctx = xchat_get_context(ph);
			icontype=pix_xchat_notin;
			motivation="XChat2 - A new friend online";
			flash_start();
		}
	}

        return XCHAT_EAT_NONE;
}

