/*
	Copyright (C) 1994	Edward Der-Hua Liu, Hsin-Chu, Taiwan
*/

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "protocol.h"

static void p_err(char *fmt,...)
{
  va_list args;
  
  va_start(args, fmt);
  fprintf(stderr,"%s:", "clisock.c");
  vfprintf(stderr, fmt, args);
  va_end(args);
  fprintf(stderr,"\n");
  exit(-1);
} 


/*static int sockfd=-1;*/
static Window xcin_win, mwin;
static Display *display;
static Atom xcin_atom;
#define BSIZE (64*1024)
static u_char *bf;
int ofs;

void xioerr()
{
	puts("xioerr");
}

void init_channel()
{
char *display_name;
if (!(display_name=getenv("DISPLAY")))
        display_name=":0";
if (!(display = XOpenDisplay(display_name)))
        p_err("Cannot open display %s", display_name);

XSetErrorHandler((XErrorHandler)xioerr);

xcin_atom=XInternAtom(display,XCIN_ATOM,False);

if ((xcin_win=XGetSelectionOwner(display,xcin_atom))==None) {
	fprintf(stderr,"Cannot connect to xcin server\n");
	exit(-1);
}

mwin = XCreateSimpleWindow(display,DefaultRootWindow(display),
		0,0,90,90,1,0,0);

if (!(bf=malloc(BSIZE))) {
		puts("malloc err");
}
ofs=4;  /* reserved for header */ 
}

void upload_keyword(KeySym kk, char *str)
{
	memcpy(bf+ofs, &kk, 4);
	ofs+=4;
	if (kk) {
		int len=strlen(str);
		strcpy(bf+ofs, str);
		ofs+=len+1;
	}
	if (ofs>BSIZE) puts("ph file size too large > 64K");
}

void send_all()
{
	XPropertyEvent eve;
	*(int *)bf=LOAD_KEYWORD;
	XChangeProperty(display, mwin , xcin_atom, XA_STRING, 8,
		PropModeReplace, bf, ofs);
	eve.type=PropertyNotify;
	eve.window=mwin;
	eve.state=PropertyNewValue;
	eve.atom=xcin_atom;
	XSendEvent(display, xcin_win, False, 0, (XEvent *)&eve);
	XSync(display,0);
	XCloseDisplay(display);
}

