/*
 *	xeno_style_images.h
 */

#ifndef XENO_STYLE_IMAGES_H
#define XENO_STYLE_IMAGES_H

#include "xeno_theme.h"
#include "xeno_rc_style.h"
#include "xeno_style.h"
#include "xeno_color.h"

/*
 *	Enums
 */
typedef enum {
	/* colors in the style */
	XENO_PEN_FG, XENO_PEN_BG,
	XENO_PEN_LIGHT, XENO_PEN_DARK, XENO_PEN_MID,
	XENO_PEN_TEXT, XENO_PEN_BASE,
	XENO_PEN_WHITE, XENO_PEN_BLACK,
	
	XENO_PEN_PURE_WHITE,
	XENO_PEN_PURE_BLACK,
	
	XENO_PEN_FILL,
	
	XENO_PEN_TOP0 = 0x10,
	XENO_PEN_TOP1 = 0x11,
	XENO_PEN_TOP2 = 0x12, 
	XENO_PEN_BOT0 = 0x14,
	XENO_PEN_BOT1 = 0x15,
	XENO_PEN_BOT2 = 0x16,
	XENO_PEN_MID0 = 0x18,
	XENO_PEN_MID1 = 0x19,
	XENO_PEN_MID2 = 0x1a,
	
	XENO_PEN_PARENT = 0x80,
} XenoPenType;

typedef enum {
	XENO_STATE_NORMAL		= GTK_STATE_NORMAL,
	XENO_STATE_ACTIVE		= GTK_STATE_ACTIVE,
	XENO_STATE_PRELIGHT		= GTK_STATE_PRELIGHT,
	XENO_STATE_SELECTED		= GTK_STATE_SELECTED,
	XENO_STATE_INSENSITIVE	= GTK_STATE_INSENSITIVE,

	XENO_STATE_GTK_MASK		= 0x07,
	
	XENO_STATE_CURRENT		= 0x10
} XenoStateType;

/*
 *	Images
 */


/*
 *	Image variants and info
 */

/* Radio button */
#define XENO_STYLE_IMAGE_RADIO_BUTTON_MIN			11
#define XENO_STYLE_IMAGE_RADIO_BUTTON_MAX			15
#define	XENO_STYLE_IMAGE_RADIO_BUTTON_STEP			2
#define	XENO_STYLE_IMAGE_RADIO_BUTTON_DEFAULT		1

/* Check button */                          	
#define XENO_STYLE_IMAGE_CHECK_BUTTON_MIN			7
#define	XENO_STYLE_IMAGE_CHECK_BUTTON_MAX			11
#define	XENO_STYLE_IMAGE_CHECK_BUTTON_STEP			2
#define	XENO_STYLE_IMAGE_CHECK_BUTTON_DEFAULT 		1
	
/* Menu item images */                      	
#define XENO_STYLE_IMAGE_RADIO_MENU_MIN		5
#define	XENO_STYLE_IMAGE_RADIO_MENU_MAX		7
#define	XENO_STYLE_IMAGE_RADIO_MENU_STEP	1

#define XENO_STYLE_IMAGE_CHECK_MENU_MIN		7
#define	XENO_STYLE_IMAGE_CHECK_MENU_MAX		11
#define	XENO_STYLE_IMAGE_CHECK_MENU_STEP	2

#define	XENO_STYLE_IMAGE_MENU_DEFAULT		1

/* Dimple */                                
#define XENO_STYLE_IMAGE_DIMPLE_SIZE		6

/* Triangle
	> \/
    /\ <
*/
#define XENO_STYLE_IMAGE_TRIANGLE_BASE		31
#define XENO_STYLE_IMAGE_TRIANGLE_HEIGHT	27

#define XENO_STYLE_IMAGE_TRIANGLE_UP_X		15
#define XENO_STYLE_IMAGE_TRIANGLE_UP_Y		31

#define XENO_STYLE_IMAGE_TRIANGLE_DOWN_X	(27+15)
#define XENO_STYLE_IMAGE_TRIANGLE_DOWN_Y	27

#define XENO_STYLE_IMAGE_TRIANGLE_LEFT_X	31
#define XENO_STYLE_IMAGE_TRIANGLE_LEFT_Y	(27+15)

#define XENO_STYLE_IMAGE_TRIANGLE_RIGHT_X	27
#define XENO_STYLE_IMAGE_TRIANGLE_RIGHT_Y	15

#define	XENO_STYLE_IMAGE_TRIANGLE_RATIO		0.866025403783


XenoPixmap * xeno_style_pixmap_get	(XenoStyle			*style,
									 GtkStyle			*parent_style,
									 XenoStyleImageType	image_type,
									 guint				variant_type,
									 XenoPixmapMask		**mask_p);

void		 xeno_style_mask_unref	(XenoStyleImageType	image_type,
									 guint				variant_type);


/*
 *	Shadows
 */
enum {
	XENO_SHADOW_GC_TOP = 0,
	XENO_SHADOW_GC_BOTTOM = 1,
	XENO_SHADOW_GC_CORNER = 2
};

typedef struct {
	GdkGC		*gc[3];
} XenoShadowGCRing;

typedef struct {
	XenoShadowGCRing	ring[3];
	gint				thickness;
} XenoShadow;

void xeno_shadow_init  (XenoShadow		*shadow,
					     GtkStyle		*style,
					     GdkWindow		*window,
					     GtkStateType	state_type,
					     XenoShadowType	shadow_type,
					     GdkRectangle	*area,
					     GtkWidget		*widget);

void xeno_shadow_done	(XenoShadow		*shadow,
						 GdkRectangle	*area);

const GdkColor * xeno_shadow_color  (GtkStyle		*style,
									 GtkStyle		*parent_style,
									 GtkStateType	state_type,
									 XenoPenType	pen_type);

#endif /* XENO_STYLE_IMAGES_H */

