.TH XMCPUSTATE 1 "17 September 1996" "X Version 11"
.SH NAME
xmcpustate - display CPU states (idle, nice, system, kernel) statistics
.SH SYNTAX
\fBxmcpustate\fP [\fI-toolkitoption\fP ...] [\fI-count\fP iterations] 
[\fI-interval\fP seconds]
[\fI-barwidth\fP pixels] [\fI-barheight\fP pixels]
[\fI-idlecol\fP color] [\fI-usercol\fP pixels]
[\fI-kernelcol\fP color] [\fI-nicecol\fP pixels]
[\fI-systemcol\fP color]
.SH DESCRIPTION
.I Xmcpustate
displays bars showing the percentage of time the CPU spends in
different states. 
.PP
On a machine running Berkeley Unix, or a derivative (Suns with SunOS,
microVaxen with Ultrix), the bar indicates the proportions of idle,
user, nice, and system time with increasing levels of gray scale (from
left to right) 
.PP
On an Iris4D, there may be more than one bar, one for each CPU, and
each bar indicates the proportions of idle + wait, user, kernel, sxbrk
and interrupt time for each cpu.
.PP
On a Cray X/MP or Y/MP, under Unicos 5.1 or greater, it will display
bars for as many cpus as are configured.  The proportions of
idle, user and system time are shown for each cpu.
.PP
On Linux, it will display 4 separate bars: CPU, Memory, Swap and Ethernet
load.

.SH OPTIONS
.I Xmcpustate
accepts all of the standard X Toolkit command line options, plus:
.TP 8
.IR -count " iterations"
The number of times it should update the display. Default is forever.
.TP 8
.IR -interval " seconds"
the interval in between updates. Default is 1 second.
.TP 8
.IR -barwidth " pixels"
the width of a displayed status bar. Default is 350 pixels.
.TP 8
.IR -barheight " pixels"
the height of a displayed status bar. Default is 20 pixels.
.TP 8
.IR -idlecol " color" 
the color to use for idle. Default is green.
.TP 8
.IR -usercol " color"
the color to use for user space. Default is magenta.
.TP 8
.IR -kernelcol " color"
the color to use for kernel space. Default is yellow.
.TP 8
.IR -nicecol " color"
the color to use for nice. Default is DarkRed.
.TP 8
.IR -systemcol " color"
the color to use for system space. Default is black.

A color must be given by it's symbolic name.
.SH X DEFAULTS
For
.I xmcpustate
the available class identifiers are:
.sp
.nf
xmcpustate - the application
Form - enclosing the entire application, and sub-Forms enclosing 
Label/Bar pairs.
.fi
.PP
The default font list is lucida bold at 12pt.
The default background color is SlateBlue.
.PP
For
.I xmcpustate,
the available name identifiers are:
.sp
.nf
xmcpustate - application name
The outer Form is "form".
The Forms enclosing the Label/Bar pairs are "formN", where N is the
index number, starting with the top pair as zero.
Each Label name is the same as the label string.
Each Bar name is "barN".
The form enclosing the colored labels is "colorLegend"
.fi
.sp
.LP
For
.I xmcpustate,
the available resources are:
.IP "name interval, class Interval"
corresponds to the -interval option. Takes an integer value.
.IP "name count, class Count"
corresponds to the -count argument, also takes and integer value.
.IP "name barwidth, class Barwidth"
corresponds to the -barwidth option. Takes an integer value.
.IP "name barheight, class Barheight"
corresponds to the -barheight option. Takes an integer value.
.IP "name idlecol, class Idlecol"
corresponds to the -idlecol option. Takes a string value.
.IP "name usercol, class Usercol"
corresponds to the -usercol option. Takes a string value.
.IP "name kernelcol, class Kernelcol"
corresponds to the -kernelcol option. Takes a string value.
.IP "name nicecol, class Nicecol"
corresponds to the -nicecol option. Takes a string value.
.IP "name systemcol, class Systemcol"
corresponds to the -systemcol option. Takes a string value.

.SH NOTES
.I Xmcpustate 
is derived from Xcpustate
.I Xcpustate 
was designed for a multiprocessor (a Silicon Graphics Iris4D/240) - it
happens to work for conventional BSD uniprocessors. It is meant to be
easy to port, and extend to monitor a wide variety of statistics.
.SH SEE ALSO
xperfmon, xload
.SH AUTHOR
Mark Moraes, University of Toronto
Thanks to Chris Siebenmann for the code for BSD systems.
Thanks to Walter D. Poxon from Cray Research for the code for Cray X/MP and
Y/MPs.
Modified to Xmcpustate by Koen D'Hondt (ripley@xs4all.nl) from the Delft University of 
Technology, Netherlands.
