/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include <xmms/configfile.h>

#include "dialogs.h"

#include "singit/macros.h"
#include "singit/config_gen.h"
#include "singit/displayer_plugin.h"
#include "singit/dlg_multiline.h"
#include "singit/wgt_colorbutton.h"

#include "singit_debug.h"
#include "singit_plugin_scanner.h"
#include "singit_main.h"
#include "singit_tools.h"

#include "dlg_singit_config.h"

static GtkWidget *singit_config_win = NULL;
static GtkWidget
	*config_vbox,
		*config_notebook,
		*config_displayer_vbox, *config_displayer_label,
			*config_filefound_frame, *config_filefound_table,
				*config_filefound_basepath_label,
				*config_filefound_basepath_entry,
				*config_filefound_basepath_button,
				*config_filefound_hsep1,
				*config_filefound_construct_filename_label,
				*config_filefound_construct_filename_entry,
				*config_filefound_construct_filename_button,
				*config_filefound_extension_label,
				*config_filefound_extension_entry,
				*config_filefound_extension_button,
			*config_font_frame,
				*config_font_hbox,
				*config_font_entry,
				*config_font_browse,
				*config_fontsel,
			*config_color_frame,
				*config_color_table,
				*config_color_background_label,
				*config_color_background_button,
				*config_color_normal_text_label,
				*config_color_normal_text_button,
				*config_color_normal_bar_label,
				*config_color_normal_bar_button,
				*config_color_progress_text_label,
				*config_color_progress_text_button,
				*config_color_progress_bar_label,
				*config_color_progress_bar_button,

		*config_displayer_toggle_vbox, *config_displayer_toggle_label,
			*config_toggle_yz_check_button,
			*config_show_empty_check_button,
			*config_auto_resize_check_button,
			*config_hide_if_not_found_check_button,
			*config_show_ball_check_button,
			*config_guess_sync_lyrics_check_button,
			*config_find_optimal_font_check_button,
			*config_use_xmms_usleep_check_button,
			*config_show_time_indicator_check_button,
			*cfg_toggle_options_hseparator,
			*cfg_limit_framerate_hbox,
				*cfg_limit_framerate_checkbutton,
				*cfg_limit_framerate_spinbutton,

		*cfg_editor_vbox, *cfg_editor_label,
			*cfg_editor_options_frame, *cfg_editor_options_vbox,
				*cfg_reaction_time_hbox,
					*cfg_reaction_time_label,
					*cfg_reaction_time_spinbutton,
				*cfg_submitting_author_label,
				*cfg_submitting_author_entry_hbox,
					*cfg_submitting_author_fixed,
					*cfg_submitting_author_entry,
			*cfg_http_proxy_frame, *cfg_http_proxy_table,
				*cfg_http_proxy_enable_usage_checkbutton,
				*cfg_http_proxy_server_label, *cfg_http_proxy_server_port_hbox,
					*cfg_http_proxy_server_entry,
					*cfg_http_proxy_server_port_label,
					*cfg_http_proxy_server_port_spinbutton,
				*cfg_http_proxy_user_label, *cfg_http_proxy_user_entry,
				*cfg_http_proxy_password_label, *cfg_http_proxy_password_entry,
				*cfg_http_proxy_save_plain_password_checkbutton,

		*cfg_second_vbox, *cfg_dialogs_label,
			*cfg_dialogs_frame, *cfg_dialogs_vbox,
				*cfg_show_about_button,
				*cfg_dialog_buttons_first_hseparator,
#ifdef HAVE_TAG_MANAGEMENT_SUPPORT
				*cfg_show_tag_manager_button,
				*cfg_dialog_buttons_second_hseparator,
#endif
				*cfg_show_editor_button,
#ifdef CODEDEBUG
			*config_debug_frame, *config_debug_vbox,
				*config_debug_enable_check_button,
				*config_debug_exclusive_check_button,
				*config_debug_level_hbox,
					*config_debug_level_label,
					*config_debug_level_spinbutton,
#endif

		*config_dis_plugin_vbox, *config_dis_plugin_label,
				*config_dis_plugin_clist,
				*config_dis_plugin_scrolled_window,
			*config_dis_plugin_hbox,
				*config_dis_plugin_configure_button,
				*config_dis_plugin_about_button,
				*config_dis_plugin_use_check_button,
		*bottom_button_hbox,
			*bottom_button_ok,
			*bottom_button_cancel,
			*bottom_button_apply;

static GtkObject *cfg_reaction_time_spinbutton_adj = NULL,
#ifdef CODEDEBUG
	*config_debug_level_spinbutton_adj = NULL,
#endif
	*cfg_limit_framerate_spinbutton_adj = NULL,
	*cfg_http_proxy_server_port_spinbutton_adj = NULL;

static GtkAccelGroup *accel_group;

// static GtkWidget *font_select_dialog = NULL;
/*
static GtkTooltips
		*plugin_clist_tooltips = NULL;
*/
typedef struct {

	guchar *color_array;
	guint exporter_selection;

	gboolean updating_displayer_list;

} ConfigStatus;

ConfigStatus config_status;

#define cfg_dialog_descr_show(wgt) \
	create_std_wgt_description(wgt, #wgt, TRUE, singit_config_win)

static void config_font_browse_ok(GtkWidget * w, gpointer data)
{
	gtk_entry_set_text(GTK_ENTRY(config_font_entry),
		gtk_font_selection_dialog_get_font_name
			(GTK_FONT_SELECTION_DIALOG(config_fontsel)));
	gtk_widget_destroy(config_fontsel);
}

static void config_font_browse_cb(GtkWidget * w, gpointer data)
{
	gchar *temp;

	if (!config_fontsel)
	{
		temp = g_strconcat(_("Select lyric font"), ":", NULL);
		config_fontsel = gtk_font_selection_dialog_new(temp);
		g_free(temp);
		gtk_window_set_modal(GTK_WINDOW(config_fontsel), TRUE);
		gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(config_fontsel),
			GET_SCD->lyricFontName);
		gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(config_fontsel)->ok_button), "clicked",
			GTK_SIGNAL_FUNC(config_font_browse_ok), NULL);
		gtk_signal_connect_object(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(config_fontsel)->cancel_button),
			"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(config_fontsel));
		gtk_signal_connect(GTK_OBJECT(config_fontsel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			&config_fontsel);
		gtk_widget_show(config_fontsel);
	}
}

static void start_singit_editor(GtkWidget *button, gpointer config)
{
	singit_config_save_editor();
	singit_editor_show();
}

static void multi_line_dialog_new_text_event(MultiLineDialog *mldlg, gpointer user_data)
{
	gchar *text = NULL, *new_text;
	SingitConfigData *scd = GET_SCD;

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_singit_config.c [multi_line_dialog_new_text_event]\n"));
#endif

	text = multi_line_dialog_get_text(mldlg);
	new_text = tools_replace_string(text, "/,", ",");
	g_free(text);
	text = tools_replace_string(new_text, ",", "/,");
	g_free(new_text);
	if (text[strlen(text)-1] != '/') {
		new_text = text;
		text = g_strconcat(new_text, "/", 0);
		g_free(new_text);
	}

	switch ((gint) user_data) {
	case 0:
		if (scd->basePath) { g_free(scd->basePath); }
		scd->basePath = text;
		gtk_entry_set_text(GTK_ENTRY(config_filefound_basepath_entry),
			scd->basePath);
		break;
	case 1:
		if (scd->basePath) { g_free(scd->constructFilename); }
		scd->constructFilename = text;
		gtk_entry_set_text(GTK_ENTRY(config_filefound_construct_filename_entry),
			scd->constructFilename);
		break;
	case 2:
		if (scd->basePath) { g_free(scd->lyricExtension); }
		scd->lyricExtension = text;
		gtk_entry_set_text(GTK_ENTRY(config_filefound_extension_entry),
			scd->lyricExtension);
		break;
	default:
		if (text) { g_free(text); }
	}
}

static void config_open_multiline_editor_ok(GtkWidget *button, gpointer user_data)
{
	GtkWidget * dialog;

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_singit_config.c [config_open_multiline_editor_ok]\n"));
#endif

	dialog = multi_line_dialog_new("Editor");
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	gtk_signal_connect(GTK_OBJECT(dialog),
		"new_text", GTK_SIGNAL_FUNC(multi_line_dialog_new_text_event), user_data);
	gtk_signal_connect(GTK_OBJECT(dialog),
		"button_pressed", GTK_SIGNAL_FUNC(multi_line_dialog_hide), user_data);

	switch ((gint) user_data) {
	case 0: multi_line_dialog_set_text(MULTI_LINE_DIALOG(dialog),
			g_strstrip(gtk_entry_get_text(GTK_ENTRY(config_filefound_basepath_entry)))
		);
		break;
	case 1: multi_line_dialog_set_text(MULTI_LINE_DIALOG(dialog),
			gtk_entry_get_text(GTK_ENTRY(config_filefound_construct_filename_entry))
		);
		break;
	case 2: multi_line_dialog_set_text(MULTI_LINE_DIALOG(dialog),
			g_strstrip(gtk_entry_get_text(GTK_ENTRY(config_filefound_extension_entry)))
		);
		break;
	}

	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
	multi_line_dialog_show(MULTI_LINE_DIALOG(dialog), GTK_WINDOW(singit_config_win));
}


/*********************************************
	displayer plugin funtions
*********************************************/

static void config_dis_plugins_plugins(void)
{
	GList *glist;
	gchar *description[2] = { 0 }, *tooltip, *enabled_str;
	DisplayerPlugin *dp;
	gint i = 0, column;

	glist = get_dis_plugin_list();

	gtk_clist_clear(GTK_CLIST(config_dis_plugin_clist));

	while (glist)
	{
		dp = (DisplayerPlugin *) glist->data;
		if (is_dis_plugin_enabled(i)) {
			enabled_str = _("enabled");
			description[1] = g_strconcat(dp->description, "   (",
				enabled_str, ")", NULL);
			tooltip = g_strdup_printf("%s   [%s] (%s)", dp->description,
				g_basename(dp->filename), enabled_str);
		}
		else {
			description[1] = g_strdup(dp->description);
			tooltip = g_strdup_printf("%s  [%s]", dp->description,
				g_basename(dp->filename));
		}

		if (i < 10) {
			description[0] = g_strdup_printf("[%i]", (i + 1) % 10);
		}
		else { description[0] = g_strdup(""); }

		column = gtk_clist_append(GTK_CLIST(config_dis_plugin_clist), description);
/*		gtk_tooltips_set_tip(plugin_clist_tooltips,
			gtk_clist_get_column_widget(GTK_CLIST(config_dis_plugin_clist), column),
			tooltip, NULL); */
		g_free(description[0]);
		g_free(description[1]);
		g_free(tooltip);
		glist = glist->next;
		i++;
	}

	gtk_widget_set_sensitive(config_dis_plugin_use_check_button, FALSE);
	gtk_widget_set_sensitive(config_dis_plugin_configure_button, FALSE);
	gtk_widget_set_sensitive(config_dis_plugin_about_button, FALSE);
}

void config_dis_plugins_rescan(void)
{
	gint sel;
	GtkAdjustment *adj;
	gfloat pos;

	if (!singit_config_win) { return; }

	if(GTK_CLIST(config_dis_plugin_clist)->selection)
		sel = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;
	else
		sel = -1;
	adj = gtk_clist_get_vadjustment(GTK_CLIST(config_dis_plugin_clist));
	pos = adj->value;
	config_dis_plugins_plugins();
	gtk_adjustment_set_value(adj, pos);
	gtk_clist_set_vadjustment(GTK_CLIST(config_dis_plugin_clist), adj);
	if(sel != -1)
		gtk_clist_select_row(GTK_CLIST(config_dis_plugin_clist), sel, 0);
}

static void config_dis_plugins_use_cb(GtkWidget * w, gpointer data)
{
	gint sel;
	SingitConfigData *scd;

	g_return_if_fail(STATUS->config != NULL);

	scd = GET_SCD;

	if (!(GTK_CLIST(config_dis_plugin_clist)->selection) ||
		config_status.updating_displayer_list) { return; }

	sel = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;

	if (set_dis_plugin_status(sel, GTK_TOGGLE_BUTTON(w)->active) == FALSE)
		{ goto rescan; }

	if (GTK_TOGGLE_BUTTON(w)->active == TRUE) {
		GDK_THREADS_LEAVE();
		dis_plugin_set_time(sel, STATUS->old_time, STATUS->next_lyric_line);
		GDK_THREADS_ENTER();
	}

	g_free(scd->enabled_dplugins);
	scd->enabled_dplugins = dis_plugin_stringify_enabled_list();

rescan:
	config_dis_plugins_rescan();
}

static void config_dis_plugins_configure(GtkWidget * w, gpointer data)
{
	gint sel = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;

	dis_plugin_configure(sel);
}

static void config_dis_plugins_about(GtkWidget * w, gpointer data)
{
	gint sel = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;

	dis_plugin_about(sel);
}

static void config_dis_plugins_clist_clicked(GtkWidget * w, gint row, gint column, GdkEvent *event)
{
	DisplayerPlugin *dp;
	gint index;
	GList *dplist;

	if (GTK_CLIST(config_dis_plugin_clist)->selection)
	{
		dplist = get_dis_plugin_list();
		index = (gint) GTK_CLIST(config_dis_plugin_clist)->selection->data;
		dp = g_list_nth(dplist, index)->data;

		gtk_widget_set_sensitive(config_dis_plugin_use_check_button, TRUE);
		config_status.updating_displayer_list = TRUE;
		gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON(config_dis_plugin_use_check_button), is_dis_plugin_enabled(index));
		config_status.updating_displayer_list = FALSE;

		gtk_widget_set_sensitive(config_dis_plugin_configure_button, (dp && dp->configure));
		gtk_widget_set_sensitive(config_dis_plugin_about_button, (dp && dp->about));

		if (event && event->type == GDK_2BUTTON_PRESS)
			gtk_signal_emit_by_name(GTK_OBJECT(config_dis_plugin_configure_button), "clicked");
	}
	else
	{
		gtk_widget_set_sensitive(config_dis_plugin_configure_button, FALSE);
		gtk_widget_set_sensitive(config_dis_plugin_about_button, FALSE);
	}
}

// * -------------------------------------------------------------------------------- *


static void singit_config_apply_clicked(GtkButton *button, gpointer user_data)
{
	gchar tmp[13] = { 0 };
#define GET_RGB_AS_STRING(a,b) { sprintf(tmp, "rgb:%.2x/%.2x/%.2x", \
		(gushort) ((guchar *) (COLOR_BUTTON(a)->color))[0], \
		(gushort) ((guchar *) (COLOR_BUTTON(a)->color))[1], \
		(gushort) ((guchar *) (COLOR_BUTTON(a)->color))[2]); \
		b = g_strdup(tmp); }

	gchar *temp;
	SingitConfigData *scd;

#ifdef CODEDEBUG
	DEBUG(2, ("dlg_singit_config.c [singit_config_apply_clicked]\n"));
#endif

	g_return_if_fail(singit_config_win != NULL);
	g_return_if_fail(GTK_WIDGET_REALIZED(singit_config_win));
	g_return_if_fail(STATUS != NULL);
	g_return_if_fail(STATUS->config != NULL);

	pthread_mutex_lock(&STATUS->config_rw_mutex);

	scd = GET_SCD;

	g_free(scd->basePath);
	g_free(scd->constructFilename);
	g_free(scd->lyricExtension);
	g_free(scd->lyricFontName);

	g_free(scd->backgroundColor);
	g_free(scd->normalTextColor);
	g_free(scd->normalBarColor);
	g_free(scd->progressTextColor);
	g_free(scd->progressBarColor);

/*	g_free(scd->htmlHeader);
	g_free(scd->htmlTail);
	g_free(scd->lyricLine);*/
	g_free(scd->enabled_dplugins);
	g_free(scd->submittingAuthor);

	g_free(scd->httpProxyServer);
	g_free(scd->httpProxyUser);
	g_free(scd->httpProxyPasswd);

	// * set new values *

	scd->basePath = temp = gtk_editable_get_chars(GTK_EDITABLE(config_filefound_basepath_entry), 0, -1);
	if (temp) {
		scd->basePath = g_strdup(g_strstrip(temp));
		g_free(temp);
		if ((scd->basePath[strlen(scd->basePath)-1]) != '/') {
			temp = scd->basePath;
			scd->basePath = g_strconcat(temp, "/", NULL);
			g_free(temp);
		}
	}
	scd->constructFilename = gtk_editable_get_chars
		(GTK_EDITABLE(config_filefound_construct_filename_entry), 0, -1);
	scd->lyricExtension = gtk_editable_get_chars
		(GTK_EDITABLE(config_filefound_extension_entry), 0, -1);
	scd->lyricFontName = gtk_editable_get_chars
		(GTK_EDITABLE(config_font_entry), 0, -1);
	scd->submittingAuthor = gtk_editable_get_chars
		(GTK_EDITABLE(cfg_submitting_author_entry), 0, -1);

	scd->toggleYZ =
		GTK_TOGGLE_BUTTON(config_toggle_yz_check_button)->active;
	scd->showEmpty =
		GTK_TOGGLE_BUTTON(config_show_empty_check_button)->active;
	scd->autoResize =
		GTK_TOGGLE_BUTTON(config_auto_resize_check_button)->active;
	scd->hideIfNotFound =
		GTK_TOGGLE_BUTTON(config_hide_if_not_found_check_button)->active;
	scd->showJumpingBall =
		GTK_TOGGLE_BUTTON(config_show_ball_check_button)->active;
	scd->guessSyncLyrics =
		GTK_TOGGLE_BUTTON(config_guess_sync_lyrics_check_button)->active;
#ifdef CODEDEBUG
	scd->debugEnable =
		GTK_TOGGLE_BUTTON(config_debug_enable_check_button)->active;
	scd->debugLevelExcl =
		GTK_TOGGLE_BUTTON(config_debug_exclusive_check_button)->active;
	scd->debugLevel =
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(config_debug_level_spinbutton));
#endif
	scd->findOptimalFont =
		GTK_TOGGLE_BUTTON(config_find_optimal_font_check_button)->active;
	scd->useXMMSuSleep =
		GTK_TOGGLE_BUTTON(config_use_xmms_usleep_check_button)->active;
	scd->showTimeIndicator =
		GTK_TOGGLE_BUTTON(config_show_time_indicator_check_button)->active;
	scd->enabled_dplugins = dis_plugin_stringify_enabled_list();

	GET_RGB_AS_STRING(config_color_background_button, scd->backgroundColor);
	GET_RGB_AS_STRING(config_color_normal_text_button, scd->normalTextColor);
	GET_RGB_AS_STRING(config_color_normal_bar_button, scd->normalBarColor);
	GET_RGB_AS_STRING(config_color_progress_text_button, scd->progressTextColor);
	GET_RGB_AS_STRING(config_color_progress_bar_button, scd->progressBarColor);

	scd->reactionTime = gtk_spin_button_get_value_as_int
		(GTK_SPIN_BUTTON(cfg_reaction_time_spinbutton));

	scd->framerateLimit = gtk_spin_button_get_value_as_int
		(GTK_SPIN_BUTTON(cfg_limit_framerate_spinbutton));

	scd->framerateLimitEnabled =
		GTK_TOGGLE_BUTTON(cfg_limit_framerate_checkbutton)->active;

	// HTTP Proxy settings
	scd->httpProxyUsage =
		GTK_TOGGLE_BUTTON(cfg_http_proxy_enable_usage_checkbutton)->active;
	scd->httpProxyServer = gtk_editable_get_chars
		(GTK_EDITABLE(cfg_http_proxy_server_entry), 0, -1);
	scd->httpProxyPort = gtk_spin_button_get_value_as_int
		(GTK_SPIN_BUTTON(cfg_http_proxy_server_port_spinbutton));
	scd->httpProxyUser = gtk_editable_get_chars
		(GTK_EDITABLE(cfg_http_proxy_user_entry), 0, -1);
	scd->httpProxyPasswd = gtk_editable_get_chars
		(GTK_EDITABLE(cfg_http_proxy_password_entry), 0, -1);
	scd->httpProxySavePasswd =
		GTK_TOGGLE_BUTTON(cfg_http_proxy_save_plain_password_checkbutton)->active;

	pthread_mutex_unlock(&STATUS->config_rw_mutex);

	singit_config_gen_emit_update(STATUS->config);

	singit_config_gen_save(STATUS->config);
}

static void singit_config_cleanup()
{
#ifdef CODEDEBUG
	DEBUG(2, ("dlg_singit_config.c [singit_config_cleanup]\n"));
#endif

	if (singit_config_win && singit_config_win->window) {
		gdk_window_get_position(singit_config_win->window,
			&(GET_SCD->configWinPosX), &(GET_SCD->configWinPosY));
		singit_config_save_positions();
	}

	g_free(config_status.color_array);

	singit_main_finish(FALSE);

	singit_status_unref(NULL);
}

static void singit_config_ok_clicked(GtkButton *button, gpointer user_data)
{
	singit_config_apply_clicked(NULL, NULL);
	singit_config_cleanup();
	gtk_widget_destroy(singit_config_win);
}

static void singit_config_cancel_clicked(GtkButton *button, gpointer user_data)
{
	singit_config_cleanup();
	gtk_widget_destroy(singit_config_win);
}

static gint dlg_singit_config_delete_event( GtkWidget *widget, GdkEvent  *event, gpointer data )
{
	singit_config_cleanup();
	return (FALSE);
}

static void add_color_button(gchar *trans_label, gchar *color_str, gint col_arr_offset,
	gint row, GtkWidget *table, GtkWidget **col_label, GtkWidget **col_button)
{
	GdkColor color;

	gdk_color_parse(color_str, &color);
	config_status.color_array[col_arr_offset] = color.red;
	config_status.color_array[col_arr_offset + 1] = color.green;
	config_status.color_array[col_arr_offset + 2] = color.blue;

	*col_label = gtk_label_new(trans_label);
	gtk_table_attach (GTK_TABLE(table),
		*col_label, 0, 1, row, row + 1,
		GTK_SHRINK | GTK_FILL | GTK_EXPAND, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_misc_set_alignment(GTK_MISC(*col_label), 1, 0.5);
	*col_button = color_button_new(trans_label, 60, 20,
		&config_status.color_array[col_arr_offset], 3);
	gtk_table_attach (GTK_TABLE(table),
		*col_button, 1, 2, row, row + 1,
		GTK_SHRINK | GTK_EXPAND, GTK_SHRINK | GTK_FILL, 0, 0);

	gtk_widget_show(*col_label);
	gtk_widget_show(*col_button);
}

static void singit_config_displayer_page(SingitConfigData *scd)
{
	config_displayer_vbox = gtk_vbox_new(FALSE, 2);
	gtk_container_set_border_width(GTK_CONTAINER(config_displayer_vbox), 2);
	gtk_widget_show (config_displayer_vbox);
	config_displayer_label = gtk_label_new(_("Lyrics / Font"));
	gtk_widget_show(config_displayer_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(config_notebook),
		config_displayer_vbox, config_displayer_label);

	config_filefound_frame = gtk_frame_new(_("Lyric file constructor"));
	gtk_box_pack_start(GTK_BOX(config_displayer_vbox),
		config_filefound_frame, FALSE, FALSE, 0);
	gtk_widget_show(config_filefound_frame);

	config_filefound_table = gtk_table_new (3, 4, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (config_filefound_table), 3);
	gtk_table_set_col_spacings (GTK_TABLE (config_filefound_table), 3);
	gtk_container_set_border_width(GTK_CONTAINER(config_filefound_table), 2);
	gtk_container_add(GTK_CONTAINER(config_filefound_frame),
		config_filefound_table);
	gtk_widget_show(config_filefound_table);

// * lyric basepath *
	config_filefound_basepath_label = gtk_label_new(_("Dirs:"));
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_basepath_label, 0, 1, 0, 1,
		GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_misc_set_alignment(GTK_MISC(config_filefound_basepath_label), 1, 0.5);
	gtk_widget_show(config_filefound_basepath_label);

	config_filefound_basepath_entry = gtk_entry_new();
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_basepath_entry, 1, 2, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_entry_set_text(GTK_ENTRY(config_filefound_basepath_entry),
		scd->basePath);
	gtk_widget_show(config_filefound_basepath_entry);

	config_filefound_basepath_button = gtk_button_new_with_label ("...");
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_basepath_button, 2, 3, 0, 1,
		GTK_SHRINK | GTK_FILL,
		GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_signal_connect(GTK_OBJECT(config_filefound_basepath_button), "clicked",
		GTK_SIGNAL_FUNC(config_open_multiline_editor_ok), (gpointer) 0);
	gtk_widget_show (config_filefound_basepath_button);

	config_filefound_hsep1 = gtk_hseparator_new();
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_hsep1, 0, 3, 1, 2,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_filefound_hsep1);

// * lyric filename constructor *
	config_filefound_construct_filename_label = gtk_label_new(_("%1 = filename"));
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_construct_filename_label, 0, 1, 2, 3,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
//	gtk_widget_show(config_filefound_construct_filename_label);

	config_filefound_construct_filename_entry = gtk_entry_new();
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_construct_filename_entry, 1, 2, 2, 3,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_entry_set_text(GTK_ENTRY(config_filefound_construct_filename_entry),
		scd->constructFilename);
//	gtk_widget_show(config_filefound_construct_filename_entry);

	config_filefound_construct_filename_button = gtk_button_new_with_label ("...");
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_construct_filename_button, 2, 3, 2, 3,
		GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_signal_connect(GTK_OBJECT(config_filefound_construct_filename_button), "clicked",
		GTK_SIGNAL_FUNC(config_open_multiline_editor_ok), (gpointer) 1);
//	gtk_widget_show (config_filefound_construct_filename_button);

// * lyric extension *
	config_filefound_extension_label = gtk_label_new(_("Exts':"));
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_extension_label, 0, 1, 3, 4,
		GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_misc_set_alignment(GTK_MISC(config_filefound_extension_label), 1, 0.5);
	gtk_widget_show(config_filefound_extension_label);

	config_filefound_extension_entry = gtk_entry_new();
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_extension_entry, 1, 2, 3, 4,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_entry_set_text(GTK_ENTRY(config_filefound_extension_entry),
		scd->lyricExtension);
	gtk_widget_show(config_filefound_extension_entry);

	config_filefound_extension_button = gtk_button_new_with_label ("...");
	gtk_table_attach (GTK_TABLE (config_filefound_table),
		config_filefound_extension_button, 2, 3, 3, 4,
		GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_signal_connect(GTK_OBJECT(config_filefound_extension_button), "clicked",
		GTK_SIGNAL_FUNC(config_open_multiline_editor_ok), (gpointer) 2);
	gtk_widget_show (config_filefound_extension_button);

// * font selection box (from XMMS) *
	config_font_frame = gtk_frame_new(_("Lyrics font"));
	gtk_box_pack_start(GTK_BOX(config_displayer_vbox), config_font_frame, FALSE, FALSE, 2);
	gtk_widget_show(config_font_frame);

	config_font_hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_border_width(GTK_CONTAINER(config_font_hbox), 5);
	gtk_container_add(GTK_CONTAINER(config_font_frame), config_font_hbox);
	gtk_widget_show(config_font_hbox);

	config_font_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(config_font_hbox), config_font_entry, TRUE, TRUE, 0);
	gtk_entry_set_text(GTK_ENTRY(config_font_entry),
		scd->lyricFontName);
	gtk_widget_show(config_font_entry);

	config_font_browse = gtk_button_new_with_label("...");
	gtk_signal_connect(GTK_OBJECT(config_font_browse), "clicked",
		GTK_SIGNAL_FUNC(config_font_browse_cb), NULL);
	gtk_box_pack_start(GTK_BOX(config_font_hbox), config_font_browse, FALSE, FALSE, 0);
	gtk_widget_show(config_font_browse);

// * color selection frame *
	config_color_frame = gtk_frame_new(_("Colors"));
	gtk_box_pack_start(GTK_BOX(config_displayer_vbox), config_color_frame, FALSE, FALSE, 0);
	gtk_widget_show(config_color_frame);

	config_color_table = gtk_table_new (2, 5, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (config_color_table), 3);
	gtk_table_set_col_spacings (GTK_TABLE (config_color_table), 5);
	gtk_container_set_border_width(GTK_CONTAINER(config_color_table), 3);
	gtk_container_add(GTK_CONTAINER(config_color_frame), config_color_table);
	gtk_widget_show(config_color_table);

	add_color_button(_("Background Color"), scd->backgroundColor, 0, 0,
		config_color_table,
		&config_color_background_label,
		&config_color_background_button);

	add_color_button(_("Normal Text Color"), scd->normalTextColor, 3, 1,
		config_color_table,
		&config_color_normal_text_label,
		&config_color_normal_text_button);

	add_color_button(_("Normal Bar Color"), scd->normalBarColor, 6, 2,
		config_color_table,
		&config_color_normal_bar_label,
		&config_color_normal_bar_button);

	add_color_button(_("Progress Text Color"), scd->progressTextColor, 9, 3,
		config_color_table,
		&config_color_progress_text_label,
		&config_color_progress_text_button);

	add_color_button(_("Progress Bar Color"), scd->progressBarColor, 12, 4,
		config_color_table,
		&config_color_progress_bar_label,
		&config_color_progress_bar_button);
}

static void singit_config_options_page(SingitConfigData *scd)
{
	config_displayer_toggle_vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(config_displayer_toggle_vbox), 2);
	gtk_widget_show (config_displayer_toggle_vbox);

	config_displayer_toggle_label = gtk_label_new(_("Options"));
	gtk_widget_show(config_displayer_toggle_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(config_notebook),
		config_displayer_toggle_vbox, config_displayer_toggle_label);

	config_toggle_yz_check_button =
		gtk_check_button_new_with_label
		(_("Toggle y/z-key"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		config_toggle_yz_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_toggle_yz_check_button),
		scd->toggleYZ);
	gtk_widget_show(config_toggle_yz_check_button);

	config_show_empty_check_button =
		gtk_check_button_new_with_label
		(_("Show empty lines"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		config_show_empty_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_show_empty_check_button),
		scd->showEmpty);
	gtk_widget_show(config_show_empty_check_button);

	config_auto_resize_check_button =
		gtk_check_button_new_with_label
		(_("Automagically resize lyric displayer"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		config_auto_resize_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_auto_resize_check_button),
		scd->autoResize);
	gtk_widget_show(config_auto_resize_check_button);

	config_hide_if_not_found_check_button =
		gtk_check_button_new_with_label
		(_("Hide displayer if no lyrics were found"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		config_hide_if_not_found_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(config_hide_if_not_found_check_button),
		scd->hideIfNotFound);
	gtk_widget_show(config_hide_if_not_found_check_button);

	config_show_ball_check_button =
		gtk_check_button_new_with_label
		(_("Show the jumping ball"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		config_show_ball_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(config_show_ball_check_button),
		scd->showJumpingBall);
	gtk_widget_show(config_show_ball_check_button);

	config_guess_sync_lyrics_check_button =
		gtk_check_button_new_with_label
		(_("Guess if we have synced lyrics and set ball"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		config_guess_sync_lyrics_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_guess_sync_lyrics_check_button),
		scd->guessSyncLyrics);
	gtk_widget_show(config_guess_sync_lyrics_check_button);

	config_find_optimal_font_check_button =
		gtk_check_button_new_with_label
		(_("Find the optimal font size (slow fullscreen start)"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		config_find_optimal_font_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_find_optimal_font_check_button),
		scd->findOptimalFont);
	gtk_widget_show(config_find_optimal_font_check_button);

	config_use_xmms_usleep_check_button =
		gtk_check_button_new_with_label
		(_("Use XMMS usleep to save CPU time"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		config_use_xmms_usleep_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_use_xmms_usleep_check_button),
		scd->useXMMSuSleep);
	gtk_widget_show(config_use_xmms_usleep_check_button);

	config_show_time_indicator_check_button =
		gtk_check_button_new_with_label
		(_("Show time indicators on empty lines"));
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		config_show_time_indicator_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active
		(GTK_TOGGLE_BUTTON(config_show_time_indicator_check_button),
		scd->showTimeIndicator);
	gtk_widget_show(config_show_time_indicator_check_button);

	cfg_toggle_options_hseparator = gtk_hseparator_new ();
	cfg_dialog_descr_show(cfg_toggle_options_hseparator);
	gtk_box_pack_start (GTK_BOX (config_displayer_toggle_vbox),
		cfg_toggle_options_hseparator, FALSE, FALSE, 2);

	cfg_limit_framerate_hbox = gtk_hbox_new (FALSE, 0);
	cfg_dialog_descr_show(cfg_limit_framerate_hbox);
	gtk_box_pack_start(GTK_BOX(config_displayer_toggle_vbox),
		cfg_limit_framerate_hbox, FALSE, FALSE, 2);

	cfg_limit_framerate_checkbutton =
		gtk_check_button_new_with_label
		(_("Enable framerate limit:"));
	cfg_dialog_descr_show(cfg_limit_framerate_checkbutton);
	gtk_box_pack_start (GTK_BOX (cfg_limit_framerate_hbox),
		cfg_limit_framerate_checkbutton, TRUE, TRUE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
		(cfg_limit_framerate_checkbutton), scd->framerateLimitEnabled);

	cfg_limit_framerate_spinbutton_adj =
		gtk_adjustment_new (scd->framerateLimit, 0, 99, 1, 10, 10);
	cfg_limit_framerate_spinbutton = gtk_spin_button_new
		(GTK_ADJUSTMENT (cfg_limit_framerate_spinbutton_adj), 1, 0);
	cfg_dialog_descr_show(cfg_limit_framerate_spinbutton);
	gtk_box_pack_start (GTK_BOX (cfg_limit_framerate_hbox),
		cfg_limit_framerate_spinbutton, FALSE, FALSE, 5);
}

static void singit_config_editor_page(SingitConfigData *scd)
{
	cfg_editor_vbox = gtk_vbox_new (FALSE, 3);
	cfg_dialog_descr_show(cfg_editor_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (cfg_editor_vbox), 3);

	cfg_editor_label = gtk_label_new(_("Editor"));
	gtk_notebook_append_page(GTK_NOTEBOOK(config_notebook),
		cfg_editor_vbox, cfg_editor_label);
	gtk_widget_show(cfg_editor_label);

	cfg_editor_options_frame = gtk_frame_new (_("Editor options"));
	cfg_dialog_descr_show(cfg_editor_options_frame);
	gtk_box_pack_start (GTK_BOX (cfg_editor_vbox),
		cfg_editor_options_frame, FALSE, TRUE, 0);

	cfg_editor_options_vbox = gtk_vbox_new (FALSE, 2);
	cfg_dialog_descr_show(cfg_editor_options_vbox);
	gtk_container_add (GTK_CONTAINER (cfg_editor_options_frame),
		cfg_editor_options_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (cfg_editor_options_vbox), 4);

	cfg_reaction_time_hbox = gtk_hbox_new (FALSE, 3);
	cfg_dialog_descr_show(cfg_reaction_time_hbox);
	gtk_box_pack_start (GTK_BOX (cfg_editor_options_vbox),
		cfg_reaction_time_hbox, FALSE, TRUE, 0);

	cfg_reaction_time_label = gtk_label_new (_("Reaction time [ms] (> slower):"));
	cfg_dialog_descr_show(cfg_reaction_time_label);
	gtk_box_pack_start (GTK_BOX (cfg_reaction_time_hbox),
		cfg_reaction_time_label, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (cfg_reaction_time_label), 0, 0.5);

	cfg_reaction_time_spinbutton_adj =
		gtk_adjustment_new(scd->reactionTime, 0, 999, 1, 20, 20);
	cfg_reaction_time_spinbutton = gtk_spin_button_new
		(GTK_ADJUSTMENT (cfg_reaction_time_spinbutton_adj), 1, 0);
	cfg_dialog_descr_show(cfg_reaction_time_spinbutton);
	gtk_box_pack_start (GTK_BOX (cfg_reaction_time_hbox),
		cfg_reaction_time_spinbutton, FALSE, FALSE, 5);

// * Submitting author *
	cfg_submitting_author_label = gtk_label_new (_("Submitting author:"));
	cfg_dialog_descr_show(cfg_submitting_author_label);
	gtk_box_pack_start (GTK_BOX (cfg_editor_options_vbox),
		cfg_submitting_author_label, TRUE, TRUE, 0);
	gtk_misc_set_alignment (GTK_MISC (cfg_submitting_author_label), 0, 1);
	gtk_misc_set_padding (GTK_MISC (cfg_submitting_author_label), 0, 1);

	cfg_submitting_author_entry_hbox = gtk_hbox_new (FALSE, 0);
	cfg_dialog_descr_show(cfg_submitting_author_entry_hbox);
	gtk_box_pack_start (GTK_BOX (cfg_editor_options_vbox),
		cfg_submitting_author_entry_hbox, TRUE, TRUE, 0);

	cfg_submitting_author_fixed = gtk_fixed_new ();
	cfg_dialog_descr_show(cfg_submitting_author_fixed);
	gtk_box_pack_start (GTK_BOX (cfg_submitting_author_entry_hbox),
		cfg_submitting_author_fixed, FALSE, TRUE, 0);
	gtk_widget_set_usize (cfg_submitting_author_fixed, 15, -2);

	cfg_submitting_author_entry = gtk_entry_new ();
	cfg_dialog_descr_show(cfg_submitting_author_entry);
	gtk_entry_set_text(GTK_ENTRY(cfg_submitting_author_entry),
		scd->submittingAuthor);
	gtk_box_pack_start (GTK_BOX (cfg_submitting_author_entry_hbox),
		cfg_submitting_author_entry, TRUE, TRUE, 0);

// * HTTP Proxy settings *
	cfg_http_proxy_frame = gtk_frame_new (_("HTTP proxy settings"));
	cfg_dialog_descr_show(cfg_http_proxy_frame);
	gtk_box_pack_start (GTK_BOX (cfg_editor_vbox),
		cfg_http_proxy_frame, FALSE, TRUE, 0);

	cfg_http_proxy_table = gtk_table_new (5, 2, FALSE);
	cfg_dialog_descr_show(cfg_http_proxy_table);
	gtk_container_add (GTK_CONTAINER (cfg_http_proxy_frame), cfg_http_proxy_table);
	gtk_container_set_border_width (GTK_CONTAINER (cfg_http_proxy_table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (cfg_http_proxy_table), 2);
	gtk_table_set_col_spacings (GTK_TABLE (cfg_http_proxy_table), 2);

	cfg_http_proxy_password_label = gtk_label_new (_("Password:"));
	cfg_dialog_descr_show(cfg_http_proxy_password_label);
	gtk_table_attach (GTK_TABLE (cfg_http_proxy_table),
		cfg_http_proxy_password_label, 0, 1, 3, 4,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (cfg_http_proxy_password_label), 1, 0.5);

	cfg_http_proxy_password_entry = gtk_entry_new ();
	cfg_dialog_descr_show(cfg_http_proxy_password_entry);
	gtk_table_attach (GTK_TABLE (cfg_http_proxy_table),
		cfg_http_proxy_password_entry, 1, 2, 3, 4,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_entry_set_text(GTK_ENTRY(cfg_http_proxy_password_entry),
		scd->httpProxyPasswd);

	cfg_http_proxy_user_label = gtk_label_new (_("User:"));
	cfg_dialog_descr_show(cfg_http_proxy_user_label);
	gtk_table_attach (GTK_TABLE (cfg_http_proxy_table),
		cfg_http_proxy_user_label, 0, 1, 2, 3,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (cfg_http_proxy_user_label), 1, 0.5);

	cfg_http_proxy_user_entry = gtk_entry_new ();
	cfg_dialog_descr_show(cfg_http_proxy_user_entry);
	gtk_table_attach (GTK_TABLE (cfg_http_proxy_table),
		cfg_http_proxy_user_entry, 1, 2, 2, 3,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_entry_set_text(GTK_ENTRY(cfg_http_proxy_user_entry),
		scd->httpProxyUser);

	cfg_http_proxy_server_label = gtk_label_new (_("Server:"));
	cfg_dialog_descr_show(cfg_http_proxy_server_label);
	gtk_table_attach (GTK_TABLE (cfg_http_proxy_table),
		cfg_http_proxy_server_label, 0, 1, 1, 2,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (cfg_http_proxy_server_label), 1, 0.5);

	cfg_http_proxy_server_port_hbox = gtk_hbox_new (FALSE, 2);
	cfg_dialog_descr_show(cfg_http_proxy_server_port_hbox);
	gtk_table_attach (GTK_TABLE (cfg_http_proxy_table),
		cfg_http_proxy_server_port_hbox, 1, 2, 1, 2,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		(GtkAttachOptions) (GTK_FILL), 0, 0);

	cfg_http_proxy_server_entry = gtk_entry_new ();
	cfg_dialog_descr_show(cfg_http_proxy_server_entry);
	gtk_box_pack_start (GTK_BOX (cfg_http_proxy_server_port_hbox),
		cfg_http_proxy_server_entry, TRUE, TRUE, 0);
	gtk_entry_set_text(GTK_ENTRY(cfg_http_proxy_server_entry),
		scd->httpProxyServer);

	cfg_http_proxy_server_port_label = gtk_label_new (":");
	cfg_dialog_descr_show(cfg_http_proxy_server_port_label);
	gtk_box_pack_start (GTK_BOX (cfg_http_proxy_server_port_hbox),
		cfg_http_proxy_server_port_label, FALSE, FALSE, 0);

	cfg_http_proxy_server_port_spinbutton_adj =
		gtk_adjustment_new (scd->httpProxyPort, 0, 65535, 1, 100, 100);
	cfg_http_proxy_server_port_spinbutton = gtk_spin_button_new
		(GTK_ADJUSTMENT (cfg_http_proxy_server_port_spinbutton_adj), 1, 0);
	cfg_dialog_descr_show(cfg_http_proxy_server_port_spinbutton);
	gtk_box_pack_start (GTK_BOX (cfg_http_proxy_server_port_hbox),
		cfg_http_proxy_server_port_spinbutton, FALSE, TRUE, 0);
	gtk_widget_set_usize (cfg_http_proxy_server_port_spinbutton, 60, -2);

	cfg_http_proxy_enable_usage_checkbutton =
		gtk_check_button_new_with_label (_("Enable proxy usage"));
	cfg_dialog_descr_show(cfg_http_proxy_enable_usage_checkbutton);
	gtk_table_attach (GTK_TABLE (cfg_http_proxy_table),
		cfg_http_proxy_enable_usage_checkbutton, 0, 2, 0, 1,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
		(cfg_http_proxy_enable_usage_checkbutton),
			scd->httpProxyUsage);

	cfg_http_proxy_save_plain_password_checkbutton =
		gtk_check_button_new_with_label
		(_("Save password as plain text into config file\nThink twice before activating this option"));
	cfg_dialog_descr_show(cfg_http_proxy_save_plain_password_checkbutton);
	gtk_table_attach (GTK_TABLE (cfg_http_proxy_table),
		cfg_http_proxy_save_plain_password_checkbutton, 0, 2, 4, 5,
		(GtkAttachOptions) (0),
		(GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
		(cfg_http_proxy_save_plain_password_checkbutton),
			scd->httpProxySavePasswd);
}

static void singit_config_dialogs_page(SingitConfigData *scd)
{
#ifdef CODEDEBUG
	gchar *cat_str = NULL;
#endif
	guint cfg_show_about_button_key,
#ifdef HAVE_TAG_MANAGEMENT_SUPPORT
		cfg_show_tag_manager_button_key,
#endif
		cfg_show_editor_button_key;

	cfg_second_vbox = gtk_vbox_new (FALSE, 3);
	cfg_dialog_descr_show(cfg_second_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (cfg_second_vbox), 3);

	cfg_dialogs_label = gtk_label_new(_("Dialogs"));
	gtk_notebook_append_page(GTK_NOTEBOOK(config_notebook),
		cfg_second_vbox, cfg_dialogs_label);
	gtk_widget_show(cfg_dialogs_label);

	accel_group = gtk_accel_group_new ();

	cfg_dialogs_frame = gtk_frame_new (_("Dialogs"));
	cfg_dialog_descr_show(cfg_dialogs_frame);
	gtk_box_pack_start (GTK_BOX (cfg_second_vbox),
		cfg_dialogs_frame, FALSE, TRUE, 0);

	cfg_dialogs_vbox = gtk_vbox_new (FALSE, 4);
	cfg_dialog_descr_show(cfg_dialogs_vbox);
	gtk_container_add (GTK_CONTAINER (cfg_dialogs_frame), cfg_dialogs_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (cfg_dialogs_vbox), 5);

	cfg_show_about_button = gtk_button_new_with_label ("");
	cfg_show_about_button_key = gtk_label_parse_uline
		(GTK_LABEL (GTK_BIN (cfg_show_about_button)->child),
		_("Show _about dialog..."));
	gtk_widget_add_accelerator (cfg_show_about_button, "clicked", accel_group,
		cfg_show_about_button_key, GDK_MOD1_MASK, (GtkAccelFlags) 0);
	cfg_dialog_descr_show(cfg_show_about_button);
	gtk_box_pack_start (GTK_BOX (cfg_dialogs_vbox),
		cfg_show_about_button, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (cfg_show_about_button), 5);

	cfg_dialog_buttons_first_hseparator = gtk_hseparator_new ();
	cfg_dialog_descr_show(cfg_dialog_buttons_first_hseparator);
	gtk_box_pack_start (GTK_BOX (cfg_dialogs_vbox),
		cfg_dialog_buttons_first_hseparator, TRUE, TRUE, 0);

#ifdef HAVE_TAG_MANAGEMENT_SUPPORT
	cfg_show_tag_manager_button = gtk_button_new_with_label ("");
	cfg_show_tag_manager_button_key = gtk_label_parse_uline
		(GTK_LABEL (GTK_BIN (cfg_show_tag_manager_button)->child),
		_("Show _tag manager..."));
	gtk_widget_add_accelerator (cfg_show_tag_manager_button, "clicked", accel_group,
		cfg_show_tag_manager_button_key, GDK_MOD1_MASK, (GtkAccelFlags) 0);
	cfg_dialog_descr_show(cfg_show_tag_manager_button);
	gtk_box_pack_start (GTK_BOX (cfg_dialogs_vbox),
		cfg_show_tag_manager_button, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (cfg_show_tag_manager_button), 5);

	cfg_dialog_buttons_second_hseparator = gtk_hseparator_new ();
	cfg_dialog_descr_show(cfg_dialog_buttons_second_hseparator);
	gtk_box_pack_start (GTK_BOX (cfg_dialogs_vbox),
		cfg_dialog_buttons_second_hseparator, TRUE, TRUE, 0);
#endif

	cfg_show_editor_button = gtk_button_new_with_label ("");
	cfg_show_editor_button_key = gtk_label_parse_uline
		(GTK_LABEL (GTK_BIN (cfg_show_editor_button)->child),
		_("Show lyrics _editor..."));
	gtk_widget_add_accelerator (cfg_show_editor_button, "clicked", accel_group,
		cfg_show_editor_button_key, GDK_MOD1_MASK, (GtkAccelFlags) 0);
	cfg_dialog_descr_show(cfg_show_editor_button);
	gtk_box_pack_start (GTK_BOX (cfg_dialogs_vbox),
		cfg_show_editor_button, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (cfg_show_editor_button), 5);

#ifdef CODEDEBUG
/* Debug frame */
	config_debug_frame = gtk_frame_new(_("Debug options"));
	gtk_box_pack_start(GTK_BOX(cfg_second_vbox), config_debug_frame, FALSE, FALSE, 10);
	gtk_widget_show(config_debug_frame);

	config_debug_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(config_debug_frame), config_debug_vbox);
	gtk_container_set_border_width(GTK_CONTAINER(config_debug_vbox), 3);
	gtk_widget_show(config_debug_vbox);

	config_debug_enable_check_button = gtk_check_button_new_with_label(_("Enable console debug output"));
	gtk_box_pack_start(GTK_BOX(config_debug_vbox),
		config_debug_enable_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_debug_enable_check_button),
		scd->debugEnable);
	gtk_widget_show(config_debug_enable_check_button);

	config_debug_exclusive_check_button = gtk_check_button_new_with_label(_("Use exclusive debug level"));
	gtk_box_pack_start(GTK_BOX(config_debug_vbox),
		config_debug_exclusive_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_debug_exclusive_check_button),
		scd->debugLevelExcl);
	gtk_widget_show(config_debug_exclusive_check_button);

/* Debug level spin button */
	config_debug_level_hbox = gtk_hbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(config_debug_vbox), config_debug_level_hbox);
	gtk_container_border_width(GTK_CONTAINER(config_debug_level_hbox), 2);
	gtk_widget_show(config_debug_level_hbox);

	cat_str = g_strconcat(_("Debug level"), ": ", NULL);
	config_debug_level_label = gtk_label_new(cat_str);
	g_free(cat_str);
	gtk_box_pack_start(GTK_BOX(config_debug_level_hbox),
		config_debug_level_label, FALSE, FALSE, 2);
	gtk_widget_show(config_debug_level_label);

	config_debug_level_spinbutton_adj = gtk_adjustment_new
		(scd->debugLevel, 0, 9, 1, 1, 1);
	config_debug_level_spinbutton = gtk_spin_button_new
		(GTK_ADJUSTMENT (config_debug_level_spinbutton_adj), 1, 0);
	gtk_entry_set_max_length(GTK_ENTRY(config_debug_level_spinbutton), 1);
	gtk_box_pack_start(GTK_BOX(config_debug_level_hbox),
		config_debug_level_spinbutton, FALSE, FALSE, 2);
	gtk_widget_show (config_debug_level_spinbutton);
#endif

	gtk_signal_connect(GTK_OBJECT(cfg_show_about_button), "clicked",
		GTK_SIGNAL_FUNC(singit_about_show), NULL);
#ifdef HAVE_TAG_MANAGEMENT_SUPPORT
	gtk_signal_connect(GTK_OBJECT(cfg_show_tag_manager_button), "clicked",
		GTK_SIGNAL_FUNC(singit_tag_manager_show), NULL);
#endif
	gtk_signal_connect(GTK_OBJECT(cfg_show_editor_button), "clicked",
		GTK_SIGNAL_FUNC(start_singit_editor), NULL);
}

static void singit_config_plugins_page(SingitConfigData *scd)
{
	static const gchar *displayer_titles[] =
		{ N_(" K "), N_(" displayer plugins ") };

	config_dis_plugin_vbox = gtk_vbox_new(FALSE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(config_dis_plugin_vbox), 2);
	gtk_widget_show(config_dis_plugin_vbox);

	config_dis_plugin_label = gtk_label_new(_("Plugins"));
	gtk_notebook_append_page(GTK_NOTEBOOK(config_notebook), config_dis_plugin_vbox, config_dis_plugin_label);
	gtk_widget_show(config_dis_plugin_label);

	config_dis_plugin_clist = gtk_clist_new_with_titles(2, (gchar**) displayer_titles);
	gtk_clist_column_titles_passive(GTK_CLIST(config_dis_plugin_clist));
	gtk_clist_set_selection_mode(GTK_CLIST(config_dis_plugin_clist), GTK_SELECTION_SINGLE);
	gtk_clist_set_column_resizeable(GTK_CLIST(config_dis_plugin_clist), 0, FALSE);
	gtk_clist_set_column_resizeable(GTK_CLIST(config_dis_plugin_clist), 1, FALSE);
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_clist),
		"select_row", GTK_SIGNAL_FUNC(config_dis_plugins_clist_clicked), NULL);
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_clist),
		"unselect_row", GTK_SIGNAL_FUNC(config_dis_plugins_clist_clicked), NULL);
	gtk_widget_show(config_dis_plugin_clist);

	config_dis_plugin_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(config_dis_plugin_scrolled_window), config_dis_plugin_clist);
	gtk_container_border_width(GTK_CONTAINER(config_dis_plugin_scrolled_window), 5);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(config_dis_plugin_scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(config_dis_plugin_vbox), config_dis_plugin_scrolled_window, TRUE, TRUE, 0);
	gtk_widget_show(config_dis_plugin_scrolled_window);

	config_dis_plugin_hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(config_dis_plugin_hbox), 2);
	gtk_box_pack_start(GTK_BOX(config_dis_plugin_vbox), config_dis_plugin_hbox, FALSE, FALSE, 0);
	gtk_widget_show(config_dis_plugin_hbox);

	config_dis_plugin_configure_button = gtk_button_new_with_label(_("Configure"));
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_configure_button),
		"clicked", GTK_SIGNAL_FUNC(config_dis_plugins_configure), NULL);
	gtk_box_pack_start(GTK_BOX(config_dis_plugin_hbox), config_dis_plugin_configure_button, TRUE, TRUE, 5);
	gtk_widget_set_sensitive(config_dis_plugin_configure_button, FALSE);
	gtk_widget_show(config_dis_plugin_configure_button);

	config_dis_plugin_about_button = gtk_button_new_with_label(_("About"));
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_about_button), "clicked", GTK_SIGNAL_FUNC(config_dis_plugins_about), NULL);
	gtk_box_pack_start(GTK_BOX(config_dis_plugin_hbox), config_dis_plugin_about_button, TRUE, TRUE, 5);
	gtk_widget_set_sensitive(config_dis_plugin_about_button, FALSE);
	gtk_widget_show(config_dis_plugin_about_button);

	config_dis_plugin_use_check_button = gtk_check_button_new_with_label(_("Enable displayer"));
	gtk_box_pack_start(GTK_BOX(config_dis_plugin_hbox), config_dis_plugin_use_check_button, TRUE, TRUE, 5);
	gtk_signal_connect(GTK_OBJECT(config_dis_plugin_use_check_button), "toggled", GTK_SIGNAL_FUNC(config_dis_plugins_use_cb), NULL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_dis_plugin_use_check_button), FALSE);
	gtk_widget_set_sensitive(config_dis_plugin_use_check_button, FALSE);
	gtk_widget_show(config_dis_plugin_use_check_button);
}

void singit_config_show_page(gint page)
{
	SingitConfigData *scd;

#ifdef CODEDEBUG
	DEBUG(2, ("dlg_singit_config.c [singit_config_show]\n"));
#endif

	if (singit_config_win) {
		if (gtk_notebook_current_page(GTK_NOTEBOOK(config_notebook)) != page)
			gtk_notebook_set_page(GTK_NOTEBOOK(config_notebook), page);
		gdk_window_raise(singit_config_win->window);
		return;
	}

	if (singit_status_ref() == NULL)
		{ return; }

	scd = GET_SCD;

	singit_main_init(FALSE);

#ifdef ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALE_DIR);
#endif

	config_status.color_array = g_malloc(sizeof(guchar) * 3 * 5);
	config_status.updating_displayer_list = FALSE;

//	plugin_clist_tooltips = gtk_tooltips_new ();

	singit_config_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(singit_config_win), "delete_event",
		GTK_SIGNAL_FUNC(dlg_singit_config_delete_event), NULL);

	/* update singit_config_win when window is destroyed */
	gtk_signal_connect(GTK_OBJECT(singit_config_win), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &singit_config_win);

	gtk_window_set_title(GTK_WINDOW(singit_config_win), SINGIT_VERSION_STRING " Config");
	gtk_window_set_policy(GTK_WINDOW(singit_config_win), FALSE, FALSE, FALSE);
	gtk_container_border_width(GTK_CONTAINER(singit_config_win), 5);
//	gtk_object_set_data (GTK_OBJECT(singit_config_win), "tooltips", plugin_clist_tooltips);

	config_vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(singit_config_win), config_vbox);
	gtk_widget_show(config_vbox);

	config_notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(config_notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(config_vbox), config_notebook, FALSE, FALSE, 0);
	gtk_widget_show(config_notebook);

/*
	Generate all notebook pages
*/
	singit_config_displayer_page(scd);
	singit_config_options_page(scd);
	singit_config_editor_page(scd);
	singit_config_dialogs_page(scd);
	singit_config_plugins_page(scd);

/*
	Bottom button row ([Ok] [Cancel] [Apply])
*/
	bottom_button_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bottom_button_hbox), 5);
	gtk_box_pack_start(GTK_BOX(config_vbox), bottom_button_hbox, FALSE, FALSE, 0);
	gtk_widget_show(bottom_button_hbox);

	bottom_button_ok = gtk_button_new_with_label(_("Ok"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_ok), "clicked", GTK_SIGNAL_FUNC(singit_config_ok_clicked), (GtkObject*) TRUE);
	GTK_WIDGET_SET_FLAGS(bottom_button_ok, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_ok, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_ok);

	bottom_button_cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_cancel), "clicked", GTK_SIGNAL_FUNC(singit_config_cancel_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_cancel, TRUE, TRUE, 0);
	gtk_widget_grab_default(bottom_button_cancel);
	gtk_widget_show(bottom_button_cancel);

	bottom_button_apply = gtk_button_new_with_label(_("Apply"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_apply), "clicked", GTK_SIGNAL_FUNC(singit_config_apply_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_apply, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_apply, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_apply);

	gtk_widget_show(singit_config_win);

	config_dis_plugins_plugins();

	if ((scd->configWinPosX < 0) || (scd->configWinPosY < 0)) {
		gtk_window_set_position(GTK_WINDOW(singit_config_win), GTK_WIN_POS_MOUSE);
	}
	else {
		gtk_widget_set_uposition(singit_config_win, scd->configWinPosX, scd->configWinPosY);
	}

	if (gtk_notebook_current_page(GTK_NOTEBOOK(config_notebook)) != page)
		gtk_notebook_set_page(GTK_NOTEBOOK(config_notebook), page);

	gtk_window_add_accel_group (GTK_WINDOW(singit_config_win), accel_group);
}

void singit_config_hide(void)
{
#ifdef CODEDEBUG
	DEBUG(2, ("dlg_singit_config.c [singit_config_hide]\n"));
#endif

	if (singit_config_win) {
		singit_config_cancel_clicked(NULL, NULL);
	}
}

void singit_config_show(void)
{
#ifdef CODEDEBUG
	DEBUG(2, ("dlg_singit_config.c [singit_config_show]\n"));
#endif

	singit_config_show_page(0);
}

void singit_config_show_author(void)
{
#ifdef CODEDEBUG
	DEBUG(2, ("dlg_singit_config.c [singit_config_show_author]\n"));
#endif

	singit_config_show_page(2);
	gtk_widget_grab_focus(cfg_submitting_author_entry);
}
