/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "displayer_fullscreen_status.h"

// Since the fullscreen is a singleton, keep this global static object
static SingitSingleton       *fullscreen_status = NULL;
static SingitSingletonClass  *parent_class = NULL;

static void fullscreen_status_class_init (FullscreenStatusClass *klass);
static void fullscreen_status_init (FullscreenStatus *sstat);
static void fullscreen_status_destroy(GtkObject *object);

GtkType fullscreen_status_get_type (void)
{
	static GtkType fullscreen_status_type = 0;

	if (!fullscreen_status_type) {

		static const GtkTypeInfo fullscreen_status_info =
		{
			(gchar*) "FullscreenStatus",
			sizeof (FullscreenStatus),
			sizeof (FullscreenStatusClass),
			(GtkClassInitFunc) fullscreen_status_class_init,
			(GtkObjectInitFunc) fullscreen_status_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		fullscreen_status_type = gtk_type_from_name("FullscreenStatus");
		if ((fullscreen_status_type == GTK_TYPE_NONE) ||
			(fullscreen_status_type == GTK_TYPE_INVALID))
		{
			fullscreen_status_type = gtk_type_unique
				(TYPE_SINGIT_SINGLETON, &fullscreen_status_info);
		}
		else { parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON); }
	}

	return fullscreen_status_type;
}

static void fullscreen_status_class_init (FullscreenStatusClass *klass)
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;

	parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON);

	object_class->destroy = fullscreen_status_destroy;
}

static void fullscreen_status_init(FullscreenStatus *sstat)
{
	sstat->song = NULL;

	sstat->hide_mouse_id = -1;
	sstat->jump_to_song = 0;
	sstat->print_debug = FALSE;
	sstat->toggle_yz = FALSE;
	sstat->guess_synced_lyrics = TRUE;
	sstat->show_jumping_ball = TRUE;
	sstat->find_optimal_font = FALSE;
}

static void fullscreen_status_destroy(GtkObject *object)
{
	FullscreenStatus *sstat;

	g_return_if_fail(object != NULL);
	g_return_if_fail(IS_FULLSCREEN_STATUS (object));

	sstat = FULLSCREEN_STATUS(object);

	singit_song_detach(&sstat->song);

	if (GTK_OBJECT_CLASS(parent_class)->destroy)
		GTK_OBJECT_CLASS(parent_class)->destroy(object);
}

SingitSingleton* fullscreen_status_ref(void)
{
	gboolean init;
	SingitSingleton *status = singit_singleton_construct
		(&fullscreen_status, TYPE_FULLSCREEN_STATUS, &init);
	if (init == TRUE)
		{ return status; }
	return singit_singleton_attach(status);
}

void fullscreen_status_unref(SingitSingleton** single)
{
	g_return_if_fail(fullscreen_status != NULL);

	if (single == NULL) {
		SingitSingleton* unref_single = fullscreen_status;
		singit_singleton_detach(&unref_single);
	}
	else {
		g_return_if_fail(*single == fullscreen_status);
		singit_singleton_detach(single);
	}
}

SingitSingleton* fullscreen_status_noref(void)
{
	if (fullscreen_status == NULL)
		{ return NULL; }

	g_return_val_if_fail(IS_FULLSCREEN_STATUS(fullscreen_status), NULL);

	return fullscreen_status;
}
