
#include "ImportedImage.h"

#if EG_MAC
#include <QuickTimeComponents.h>
#endif

#ifdef WIN_QUICKTIME_PRESENT
#include <QTML.h>
#include <QuickTimeComponents.h>
#endif

#include "PixPort.h"

ImportedImage::ImportedImage() {

}


bool ImportedImage::IsImage( CEgFileSpec& inSpec ) {

	bool isImage = false;

#if EG_MAC || WIN_QUICKTIME_PRESENT

	if ( EgOSUtils::sQTAvailable ) {

		GraphicsImportComponent importRef	= nil;
		OSErr err;
		Boolean isFolder, wasAliased;
		FSSpec spec;

#if EG_MAC
		spec = *((FSSpec*) inSpec.OSSpec());
#else
		::NativePathNameToFSSpec( (char*) inSpec.OSSpec(), &spec, 0 );
#endif

		// Open the image using QuickTime...
		err = ::ResolveAliasFile( &spec, true, &isFolder, &wasAliased );
		err = ::GetGraphicsImporterForFile( &spec, &importRef );
		if ( err == noErr && importRef )
			isImage = true;

		if ( importRef )
			::CloseComponent( importRef );
	}
#endif

#if EG_WIN
	if ( ! isImage )
		isImage = inSpec.CompareExtn( ".BMP" );
#endif

	return isImage;
}



bool ImportedImage::Read( CEgFileSpec& inSpec, bool inForce8Bit ) {

	bool loadOK = false;
	long depth = 8, x = 1, y = 1; // Default picture  values

#if EG_MAC || WIN_QUICKTIME_PRESENT
	GWorldPtr			oldGW;
	GDHandle			oldGD;
	GraphicsImportComponent importRef	= nil;
	ImageDescriptionHandle	imageDesc	= nil;
	QDErr err;
	Boolean isFolder, wasAliased;
	FSSpec spec;

	if ( EgOSUtils::sQTAvailable ) {

#if EG_MAC
		spec = *((FSSpec*) inSpec.OSSpec());
#else
		::NativePathNameToFSSpec( (char*) inSpec.OSSpec(), &spec, 0 );
#endif

		// Open the image using QuickTime...
		err = ::ResolveAliasFile( &spec, true, &isFolder, &wasAliased );
		err = ::GetGraphicsImporterForFile( &spec, &importRef );
		if ( err || ! importRef ) {

			if ( importRef )
				::CloseComponent( importRef );

			goto bail;
		}

		// Get some basic info about it...
		if ( ::GraphicsImportGetImageDescription( importRef, &imageDesc ) )
			goto bail;

		// quality is a value 0 to 1024 (a class variable here)
		::GraphicsImportSetQuality( importRef, 1024 );

		// If the image is 8 bit and uses a palette, we'll need to restore it to full color first
		depth = imageDesc[0] -> depth;
		if ( depth == 8 )
			depth = 32;

		// Load 1 bit images in real color to avoid any palette issues
		else if ( depth == 1 )
			depth = 16;

		// Make a compatible port for a weird depths
		else if ( depth != 32 || depth != 16 )
			depth = 32;

		x = imageDesc[0] -> width;
		y = imageDesc[0] -> height;

		// Save current draw envir
		::GetGWorld( &oldGW, &oldGD );

		{
			PixPort workPort;
			workPort.Init( x, y, depth );
			::SetGWorld( workPort.GetGWorld(), nil );

			// Be sure the colors are set up right for QD
			RGBColor c = { 0, 0, 0 };
			::RGBBackColor( &c );
			c.red = 0xFFFF;  c.green = 0xFFFF;  c.blue = 0xFFFF;
			::RGBForeColor( &c );

			// Draw the bitmap to our offscreen world buffer
			::GraphicsImportSetGWorld( importRef, workPort.GetGWorld(), nil );
			::GraphicsImportDraw( importRef );

			// Copy the bits from our temp GWorld to the FrameBuffer
			{
				PixMapHandle BM = ::GetGWorldPixMap( workPort.GetGWorld() );
				::LockPixels( BM );
				if ( inForce8Bit )
					Assign8Bit(	::GetPixBaseAddr( BM ), x, y, (**BM).rowBytes & 0x1FFF, depth );
				else
					Assign(		::GetPixBaseAddr( BM ), x, y, (**BM).rowBytes & 0x1FFF, depth );
				::UnlockPixels( BM );
			}

			// Restore the initial grafx environment
			if ( oldGW && oldGD )
				::SetGWorld( oldGW, oldGD );

			// Clean up
			::CloseComponent( importRef );
			loadOK = true;
		}
	}

bail:
#endif

#if EG_WIN
	if ( ! loadOK ) {
		HBITMAP bitmap = (HBITMAP) ::LoadImage( nil, (char*) inSpec.OSSpec(), IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE | LR_CREATEDIBSECTION );
		if ( bitmap ) {
			BITMAP info;
			::GetObject( bitmap, sizeof( info ), &info );

			// Dim the offscreen buffer. If the image is 8 bit (and uses a palette), restore it to full color.
			// If 24 bit color, put it at 32 bit for better compatibilty
			depth = info.bmBitsPixel;
			if ( depth == 8 || depth == 24 )
				depth = 32;
			if ( depth == 1 )
				depth = 16;

			x = info.bmWidth;
			y = info.bmHeight;

			/* This is a inefficient way to convert bitmaps.  We get a HBITMAP, select it into a tempDC, copy it to
			a temp PixPort, *then* copy the bit out.  One advantage of this method is that Windoze does all the palette
			mapping for us if the HBITMAP is 8 bit (b/c we dim the temp port to 32 bits if its 8 bit--see above) */
			PixPort port;
			port.Init( x, y, depth );

			// Copy the bitmap to the PixPort bits
			HDC tempDC = ::CreateCompatibleDC( port.GetDC() );
			::SelectObject( tempDC, bitmap );
			::BitBlt( port.GetDC(), 0, 0, x, y, tempDC, 0, 0, SRCCOPY );
			::DeleteDC( tempDC );
			::DeleteObject( bitmap );

			// Now move the bits from the PixPort to our frame buffer
			if ( inForce8Bit )
				Assign8Bit(	(char*) port.Bits(), x, y, port.BytesPerRow(), port.GetDepth() );
			else
				Assign(		(char*) port.Bits(), x, y, port.BytesPerRow(), port.GetDepth() );

			loadOK = true;
		}
	}
#endif

	// If we couldn't load the image, make a dummy frame buffer
	if ( ! loadOK )
		Resize( x, y, depth );

	return loadOK;
}
