/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2003 Nicolas Adenis-Lamarre (aspegic500@free.fr)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_XOSD_STATUS_H__
#define __DISPLAYER_XOSD_STATUS_H__

#include "singit/singleton.h"
#include "singit/song.h"
#include "singit/config_gen.h"
#include "xosd.h"

#define DISPLAYER_XOSD_VERSION "0.1"

#ifdef __cplusplus
extern "C" {
#endif // * __cplusplus *

#define TYPE_XOSD_STATUS            (xosd_status_get_type ())
#define XOSD_STATUS(obj)            (GTK_CHECK_CAST ((obj), TYPE_XOSD_STATUS, XosdStatus))
#define XOSD_STATUS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_XOSD_STATUS, XosdStatus))
#define IS_XOSD_STATUS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_XOSD_STATUS))
#define IS_XOSD_STATUS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_XOSD_STATUS))

typedef struct _XosdStatus       XosdStatus;
typedef struct _XosdStatusClass  XosdStatusClass;

struct _XosdStatus {

	SingitSingleton       singleton;

	SingitConfigGen      *m_config;

	SingitSong           *m_song;

	xosd                 *m_osd; /* for display */
	gchar                *displayed_line;
};

struct _XosdStatusClass {

	SingitSingletonClass  parent_class;
};

GtkType            xosd_status_get_type(void);

SingitSingleton*   xosd_status_ref(void);
void               xosd_status_unref(SingitSingleton** single);

SingitSingleton*   xosd_status_noref(void);

#define STATUS \
	XOSD_STATUS(xosd_status_noref())

/* return a new XosdStatus or NULL on failure */
XosdStatus* displayer_xosd_status_new();

/* destroy a osd structure */
void displayer_xosd_status_destroy(XosdStatus *osd);

/* */
int displayer_xosd_status_get_colour (XosdStatus *osd, int *red, int *green, int *blue);
int displayer_xosd_status_set_color(XosdStatus *osd, char *color);
char* displayer_xosd_status_get_font(XosdStatus *osd);
int displayer_xosd_status_set_font(XosdStatus *osd, char *font);
int displayer_xosd_status_show(XosdStatus *osd);
int displayer_xosd_status_hide(XosdStatus *osd);
int displayer_xosd_status_toggle(XosdStatus *osd);

int displayer_xosd_status_get_alignement(XosdStatus *osd, xosd_align *align);
int displayer_xosd_status_set_alignement(XosdStatus *osd, xosd_align align);
int displayer_xosd_status_get_position(XosdStatus *osd, xosd_pos *position);
int displayer_xosd_status_set_position(XosdStatus *osd, xosd_pos position);
int displayer_xosd_status_set_v_offset(XosdStatus *osd, int offset);
int displayer_xosd_status_set_h_offset(XosdStatus *osd, int offset);
int displayer_xosd_status_set_shadow_offset(XosdStatus *osd, int offset);

SingitSong* displayer_xosd_status_get_song(XosdStatus *osd);
void displayer_xosd_status_set_song(XosdStatus *osd, SingitSong *song);

int displayer_xosd_status_update(XosdStatus *osd);

#ifdef __cplusplus
}
#endif // * __cplusplus *

#endif /* __DISPLAYER_XOSD_STATUS_H__ */
