/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "editor_status.h"
#include "editor_config.h"

// Since the status is a singleton, keep this global static object
static SingitSingleton       *editor_status = NULL;
static SingitSingletonClass  *parent_class  = NULL;

static void editor_status_class_init (EditorStatusClass *klass);
static void editor_status_init (EditorStatus *sstat);
static void editor_status_destroy(GtkObject *object);
static gboolean editor_status_after_init(SingitSingleton *single);

GtkType editor_status_get_type (void)
{
	static GtkType editor_status_type = 0;

	if (!editor_status_type) {

		static const GtkTypeInfo editor_status_info =
		{
			(gchar*) "EditorStatus",
			sizeof (EditorStatus),
			sizeof (EditorStatusClass),
			(GtkClassInitFunc) editor_status_class_init,
			(GtkObjectInitFunc) editor_status_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		editor_status_type = gtk_type_unique
			(TYPE_SINGIT_SINGLETON, &editor_status_info);
	}

	return editor_status_type;
}

static void editor_status_class_init (EditorStatusClass *klass)
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;
	SingitSingletonClass *singleton_class =
		(SingitSingletonClass*) klass;

	parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON);

	object_class->destroy = editor_status_destroy;
	singleton_class->after_init = editor_status_after_init;
}

static void editor_status_init(EditorStatus *sstat)
{
	sstat->cleanedUp = FALSE;

	sstat->time_context_id = 0;
	sstat->mode_context_id = 0;
	sstat->modified_context_id = 0;
	sstat->filename_context_id = 0;
	sstat->valid_consistency_id = 0;

	sstat->filename = NULL;
	sstat->is_guessed_filename = FALSE;
	sstat->text_changed = FALSE;
	sstat->valid_consistency = FALSE;
	sstat->changed_spaces = NULL;
	sstat->continue_func = FALSE;

	sstat->strip_html_state = 0;

	sstat->text = NULL;
	sstat->text_carret = 0;

	sstat->last_directory = NULL;

	sstat->config = NULL;
}

static void editor_status_destroy(GtkObject *object)
{
	EditorStatus *sstat;

	g_return_if_fail(object != NULL);
	g_return_if_fail(IS_EDITOR_STATUS (object));

	sstat = EDITOR_STATUS(object);

	if (sstat->filename != NULL)
		{ g_free(sstat->filename); }

	if (sstat->changed_spaces)
		{ g_free(sstat->changed_spaces); }

	if (sstat->last_directory)
		{ g_free(sstat->last_directory); }

	if (sstat->text)
		{ g_free(sstat->text); }

	singit_config_gen_detach(&sstat->config);

	if (GTK_OBJECT_CLASS(parent_class)->destroy)
		GTK_OBJECT_CLASS(parent_class)->destroy(object);
}

static gboolean editor_status_after_init(SingitSingleton *single)
{
	g_return_val_if_fail(single != NULL, FALSE);
	g_return_val_if_fail(IS_EDITOR_STATUS(single), FALSE);

	EDITOR_STATUS(single)->config = editor_config_new();
	singit_config_gen_load(EDITOR_STATUS(single)->config);

	return (EDITOR_STATUS(single)->config != NULL);
}

SingitSingleton* editor_status_ref(void)
{
	gboolean init;
	SingitSingleton *status = singit_singleton_construct
		(&editor_status, TYPE_EDITOR_STATUS, &init);
	if (init == TRUE)
		{ return status; }
	return singit_singleton_attach(status);
}

void editor_status_unref(SingitSingleton** single)
{
	g_return_if_fail(editor_status != NULL);

	if (single == NULL) {
		SingitSingleton* unref_single = editor_status;
		singit_singleton_detach(&unref_single);
	}
	else {
		g_return_if_fail(*single == editor_status);
		singit_singleton_detach(single);
	}
}

SingitSingleton* editor_status_noref(void)
{
	if (editor_status == NULL)
		{ return NULL; }

	g_return_val_if_fail(IS_EDITOR_STATUS(editor_status), NULL);

	return editor_status;
}
