/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_PLUGIN_DATA_H__
#define __SINGIT_PLUGIN_DATA_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtkobject.h>
#include <pthread.h>

#define TYPE_DISPLAYER_PLUGIN_DATA            (displayer_plugin_data_get_type ())
#define DISPLAYER_PLUGIN_DATA(obj)            (GTK_CHECK_CAST ((obj), TYPE_DISPLAYER_PLUGIN_DATA, DisplayerPluginData))
#define DISPLAYER_PLUGIN_DATA_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_DISPLAYER_PLUGIN_DATA, DisplayerPluginData))
#define IS_DISPLAYER_PLUGIN_DATA(obj)         (GTK_CHECK_TYPE ((obj), TYPE_DISPLAYER_PLUGIN_DATA))
#define IS_DISPLAYER_PLUGIN_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_DISPLAYER_PLUGIN_DATA))

typedef struct _DisplayerPluginData       DisplayerPluginData;
typedef struct _DisplayerPluginDataClass  DisplayerPluginDataClass;

struct _DisplayerPluginData
{
	GtkObject      object;

	GList *displayer_list; // All displayers
	GList *enabled_list; // All enabled displayers
	GList *visible_list; // All visible displayers

	gpointer displayer_last; // Store the last selected displayer

	gboolean playback_started;

	pthread_mutex_t plugin_update_mutex;
	pthread_mutex_t init_finish_mutex;

	gboolean initialized;
};

struct _DisplayerPluginDataClass
{
	GtkObjectClass parent_class;
};

GtkType     displayer_plugin_data_get_type   (void);
GtkObject*  displayer_plugin_data_new        (void);

gboolean    displayer_plugin_data_attach(DisplayerPluginData *dpd);
void        displayer_plugin_data_detach(DisplayerPluginData **dpd);

// Standart fuction to initialize plugin init and finish sequences
// has_lock indicates wether the calling function already holds the init_finish_mutex
// Remember to releasethe lock at the end!!!
inline gboolean   displayer_plugin_data_lock_init
	(DisplayerPluginData *dpd, gboolean *initialized);
inline gboolean   displayer_plugin_data_lock_init_ext
	(DisplayerPluginData *dpd, gboolean finish, 
		gboolean has_lock, gboolean trylock);
inline void       displayer_plugin_data_unlock_init
	(DisplayerPluginData *dpd);

// When calling a displayer plugin function the program must lock the plugins
// to prevent interference with init and finish functions
inline gboolean   displayer_plugin_data_lock_plugins
	(DisplayerPluginData *dpd, gboolean trylock);
inline void       displayer_plugin_data_unlock_plugins
	(DisplayerPluginData *dpd);

// Depending on the initialization status the one mutexes is locked:
// TRUE: "plugin"
// FALSE: "init"
gboolean   displayer_plugin_data_lock_lower
	(DisplayerPluginData *dpd, gboolean *initialized);

#endif // __SINGIT_PLUGIN_DATA_H__
